//
// Error class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Error.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>




Error::Error()
{
    // clear error message
}


Error::Error(const char message[])
{
    // set error message
    strcpy(this->m_message,message);
}


Error::Error(const Error &other)
{
    // assignment
    *this = other;
}


Error::~Error()
{
    // destructor
}




void Error::rethrow(const char message[])
{
    // todo: prepend message

    // rethrow
    throw *this;
}




void Error::report() const
{
    //
    // Report error
    // ------------
    //
    // This function should report an error string to the user in
    // the most natural way on the target platform and exit the program.
    //
    // The implementation below just outputs an error string to stdout,
    // however, on many platforms there is a better way to report errors.
    // For example, under Win32 the best way is to just pop up an error
    // message box. Under unix reporting the error to stderr would
    // probably be more appropriate.
    //
    // It is up to the implementer to code the most appropriate error
    // reporting method for the target platform.
    //

    // report error
    printf("ptc error: %s\n",m_message);

    // exit
    exit(1);
}




const char* Error::message() const
{
    // get message
    return m_message;
}




Error& Error::operator =(const Error &other)
{
    // assignment
    strcpy(m_message,other.m_message);
    return *this;
}


bool Error::operator ==(const Error &other) const
{
    // is equal to
    if (!strcmp(other.m_message,m_message)) return true;
    else return false;
}


bool Error::operator !=(const Error &other) const
{
    // not equal to
    return !(*this==other);
}
