//
// Clear class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include <memory.h>
#include "Clear.h"
#include "Color.h"




void Clear::request(const Format &format)
{
    // request a clear format
    m_format = format;
}



void Clear::clear(void *pixels,int x,int y,int width,int height,int pitch,const Color &color)
{
    // note: this clear implementation does not support the clear color parameter it always clears to zero!

    // get memory pointers
    char8 *s = ((char8*)pixels) + pitch*y + x*m_format.bytes();

    // copy a line at a time
    for (int i=0; i<height; i++)
    {
        // clear line
        memset(s,0,m_format.bytes());

        // next line
        s += pitch;
    }

}
