//
// Area class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_AREA_H
#define __PTC_AREA_H

#include "Types.h"


class Area
{
    public:

        // setup
        Area();
        Area(int left,int top,int right,int bottom);
        Area(const Area &other);

        // data access
        int left()   const;
        int right()  const;
        int top()    const;
        int bottom() const;
        int width()  const;
        int height() const;

        // operators
        Area& operator =(const Area &other);
        bool operator ==(const Area &other) const;
        bool operator !=(const Area &other) const;
    private:

        // data
        int m_left;
        int m_right;
        int m_top;
        int m_bottom;
};




#endif
