//
// Area example: draws random pixels and copies to an area of the console
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU GPL
//

// include files
#include "ptc.h"
#include <stdlib.h>


extern int random(int max)
{
    // random number between 0 and max-1
    return (int) ( rand()/(float)RAND_MAX * max );
}


void main()
{
    try
    {
        // create console
        Console console;

        // create format
        Format format(32,0x00FF0000,0x0000FF00,0x000000FF);
 
        // create console
        console.open("Area example",320,200,format);

        // create surface
        Surface surface(320,150,format);
        
        // loop until a key is pressed
        while (!console.key())
        {
            // lock surface
            int32 *pixels = (int32*) surface.lock();

            // draw random pixels
            for (int i=0; i<100; i++)
            {
                // get random position
                int x = random(318);
                int y = random(148);

                // get random color
                int r = random(256);
                int g = random(256);
                int b = random(256);

                // draw color [r,g,b] at position [x,y]
                pixels[(x+1)+((y+1)*320)] = (r<<16) + (g<<8) + b;
            }
        
            // unlock surface
            surface.unlock();

            // copy surface to console area
            surface.copy(console,Area(0,0,320,150),Area(0,25,320,175));
            
            // update console area
            console.update();
        }
   }
    catch (Error &error)
    {
        // report error
        error.report();
    }
}
