/*
pixel format and video mode tables for cabbage.
*/

#ifndef __CABBAGE_TABLES_H
#define __CABBAGE_TABLES_H

/* pixel format table (red pos, red size, green pos, green size, blue pos,
  blue size, rsvd pos, rsvd size, bpp)
formats: ARGB8888, BGRA8888, ABGR8888, RGBA8888, RGB888, BGR888,
 RGB565, BGR565, ARGB1555, ABGR1555
*/
static char pixel_format_table[11][9] = {
/* ARGB8888 */ {16, 8, 8, 8, 0, 8,24, 8, 32},
/* ABGR8888 */ { 0, 8, 8, 8,16, 8,24, 8, 32},
/* BGRA8888 */ { 8, 8,16, 8,24, 8, 0, 8, 32},
/* RGBA8888 */ {24, 8,16, 8, 8, 8, 0, 8, 32},
/*  RGB888  */ {16, 8, 8, 8, 0, 8, 0, 0, 24},
/*  BGR888  */ { 0, 8, 8, 8,16, 8, 0, 0, 24},
/*  RGB565  */ {11, 5, 5, 6, 0, 5, 0, 0, 16},
/*  BGR565  */ { 0, 5, 5, 6,11, 5, 0, 0, 16},
/* ARGB1555 */ {10, 5, 5, 5, 0, 5,15, 1, 15},
/* ABGR1555 */ { 0, 5, 5, 5,10, 5,15, 1, 15},
/*  INDEX8  */ { 0, 0, 0, 0, 0, 0, 0, 0,  8}};


// video mode tables: 0=8bpp,1=15bpp,2=16bpp,3=24bpp,4=32bpp
static char vid_mode_model[6] = { 4, 6, 6, 6, 6};
static char vid_mode_rbpp[6] =  { 8,15,16,24,32};


/* video mode search order
   mode > 128 = mode w/lfb.  mode < 128 = banked mode.
   24bpp banked is unsupported because it's stupid and slow. (pixels
    split across banks)
   8bpp banked mode isn't much worse than 8bpp linear, but it seems
   that any more than one bank switch per frame slows it down to hell.

 0 = 8bpp banked.  128 = 8bpp linear.
 1 = 15bpp banked. 129 = 15bpp linear.
 2 = 16bpp banked. 130 = 16bpp linear.
 3 = nonexistant.  131 = 24bpp linear.
 4 = 32bpp banked. 132 = 32bpp linear.
*/
static char vid_mode_search_order[4][9] = {
/*  8bpp */ {128,  0,132,131,130,129,  4,  2,  1},
/* 16bpp */ {130,129,131,132,  2,  1,  4,  4,  4},
/* 24bpp */ {131,132,130,129,  4,  2,  1,  1,  1},
/* 32bpp */ {132,131,130,129,  4,  2,  1,  1,  1}};

#endif
