//
// Surface class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_SURFACE_H
#define __PTC_SURFACE_H

// include files
#include "Types.h"
#include "Base.h"
#include "Copy.h"
#include "Clear.h"


class Surface : public BaseSurface
{
    public:

        // setup
        Surface(int width,int height,const Format &format);
        ~Surface();

        // copy to surface
        virtual void copy(BaseSurface &surface);
        virtual void copy(BaseSurface &surface,const Area &source,const Area &destination);

        // memory access
        virtual void* lock();
        virtual void unlock();

        // load pixels to surface
        virtual void load(const void *pixels,int width,int height,const Format &format,const int32 palette[]);
        virtual void load(const void *pixels,int width,int height,const Area &source,const Area &destination,const Format &format,const int32 palette[]);

        // save surface pixels
        virtual void save(void *pixels,int width,int height,const Format &format,const int32 palette[]);
        virtual void save(void *pixels,int width,int height,const Area &source,const Area &destination,const Format &format,const int32 palette[]);

        // clear surface
        virtual void clear(const Color &color);
        virtual void clear(const Color &color,const Area &area);

        // surface palette
        virtual void palette(const int32 palette[]);
        virtual const int32* palette();
   
        // data access
        virtual int width() const;
        virtual int height() const;
        virtual int pitch() const;
        virtual const Format& format() const;

    private:

        // disallow surface assignment
        Surface& operator =(const Surface &other) { return *this; };

        // data
        int m_width;
        int m_height;
        Format m_format;
        bool m_locked;
        void *m_pixels;
        int32 m_palette[256];

        // utility objects
        Copy m_copy;
        Clear m_clear;
};




#endif
