//
// Generic C converter (from 8 bit indexed) for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#include "Conv_GC.h"
#include "HermConf.h"

// FROM INDEXED 8 BIT ROUTINES

void Hermes_GC_index8_32(char8 *source,char8 *dest,unsigned int count)
{ unsigned int i;
  char8 s_pixel;
  int32 d_pixel;
  
  for(i=0;i<count;i++,source++,dest+=4)
  { s_pixel=(char8)*(source);

    d_pixel=Hermes_Lookup[s_pixel];
    WRITE32(dest,d_pixel);
  }
}


void Hermes_GC_index8_24(char8 *source,char8 *dest,unsigned int count)
{ unsigned int i;
  char8 s_pixel;
  int32 d_pixel;
  char8 *d_ptr=(char8 *)&d_pixel;
  
  for(i=0;i<count;i++,source++,dest+=3)
  { s_pixel=(char8)*(source);

    d_pixel=Hermes_Lookup[s_pixel];

    *(dest+R_24)=*(d_ptr+R_32);
    *(dest+G_24)=*(d_ptr+G_32);
    *(dest+B_24)=*(d_ptr+B_32);
    
    WRITE32(dest,d_pixel);
  }
}



void Hermes_GC_index8_16(char8 *source,char8 *dest,unsigned int count)
{ unsigned int i;
  int32 d_pixel;
  
  if(((int)dest&0x3)!=0)
  { WRITE16(dest++,Hermes_Lookup[*source++]);

    dest++;
    count--;
  }

  for(i=0;i<count>>1;i++,source+=2,dest+=4)
  { d_pixel=DWORD_BYTE0(Hermes_Lookup[(char8)*(source)]);
    d_pixel|=DWORD_BYTE2(Hermes_Lookup[(char8)*(source+1)]);
    
    WRITE32(dest,d_pixel);  
  }

  if(count&1)
  WRITE16(dest,Hermes_Lookup[*source]);
}


void Hermes_GC_index8_i8(char8 *source,char8 *dest,unsigned int count)
{ unsigned int i;
  
  while(count && ((int)dest&0x3)!=0)
  { *source++=*dest++;
    count--;
  }

  for(i=0;i<count>>2;i++,source+=4,dest+=4)
  WRITE32(dest,READ32(source));

  for(i=0;i<(count&3);i++)
  *source++=*dest++;
}


