//
// Format class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_FORMAT_H
#define __PTC_FORMAT_H

// include files
#include "Types.h"




class Format
{
    public:

        // setup
        Format();
        Format(int bits);
        Format(int bits,int32 r,int32 g,int32 b,int32 a=0);
        Format(const Format &other);

        // data access
        int32 r() const;
        int32 g() const;
        int32 b() const;
        int32 a() const;
        int bits() const;
        int bytes() const;
        bool direct() const;
        bool indexed() const;

        // operators
        Format& operator =(const Format &other);
        bool operator ==(const Format &other) const;
        bool operator !=(const Format &other) const;

    private:

        // data
        int32 m_r;
        int32 m_g;
        int32 m_b;
        int32 m_a;
        int m_bits;
        bool m_direct;
        bool m_indexed;
};




#endif
