//
// Error class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_ERROR_H
#define __PTC_ERROR_H

// include files
#include "Types.h"
#include "Index.h"




class Error
{
    public:

        // setup
        Error();
        Error(const char message[]);
        Error(const Error &other);
        ~Error();

        // rethrow error
        void rethrow(const char message[]);

        // report error
        void report() const;

        // get error message
        const char* message() const;

        // operators
        Error& operator =(const Error &other);
        bool operator ==(const Error &other) const;
        bool operator !=(const Error &other) const;

    private:

        // data
        char m_message[512];
};




#endif
