/*
        JiNX Sound System V1.0e - C Header File (DOS Port)

        (C) 1997-99, Mark Hodson (Bulk Sound System Code, IT Player, Drivers)
                     Chris Bevan (Sound Output Code Prototype)
                     Jeffrey Lim (IT2.14+ Sample Compression Code)
*/

#include "ITSTRUCT.H"

// Error code (should be checked if a non-void function ever returns NULL) ////////////////////
// Use the error code to index the ErrorString for a description of the error

extern int __syscall JiNX_SS_ErrorCode;
extern char *JiNX_SS_ErrorString[];

// Setup and Initialisation Functions (in appropriate order, PreInit is optional) /////////////

// ChooseDevice: A simple soundcard choosing function with optional autodetect
// PreInitSoundSystem: Sets optionally configurable internal sound system parameters
// InitSoundSystem: Initialises the sound system for the desired type/frequency/channels
// InitSoundSystemMax: Initialises the sound system for the desired channels and max type/freq

int JiNX_SS_ChooseDevice(int autodetect);
int JiNX_SS_PreInitSoundSystem(int zero_volume_cutoff_ticks, int reverb_delay_in_ms, int reverb_level, int continuous_samples);
int JiNX_SS_InitSoundSystem(int type, int frequency, int num_vcs);
int JiNX_SS_InitSoundSystemMax(int frequency, int num_vcs);

// Info/Convenience Functions (results only valid AFTER initialisation) ///////////////////////
// ReturnDevice: Returns a string of the name of the sound device in use
// ReturnType: Returns a string describing the quality of sound output from the device
// ReturnFrequency: Returns the actual operating frequency for the device

char *JiNX_SS_ReturnDevice(void);
char *JiNX_SS_ReturnType(void);
int   JiNX_SS_ReturnFrequency(void);

// In-Use Prototypes (can be called at any time AFTER initialisation) /////////////////////////

// LoadModuleFile: Loads a module from disk with the appropriate filename
// LoadModuleMemory: Loads a module from memory pointed to by the pointer parameter
// NoModule: Creates a blank module should you wish to have SFX only

JTM_module *JiNX_SS_LoadModuleFile(char *filename, int interpolate);
JTM_module *JiNX_SS_LoadModuleMemory(char *it_data, int interpolate);
JTM_module *JiNX_SS_NoModule(void);

// PlayModule: Commences playing of a module loaded with LoadModule/NoModule
// StopModule: Stops all mixing but keeps the sound system active (playing silence)

void JiNX_SS_PlayModule(JTM_module *mod);
void JiNX_SS_StopModule(void);

// Run-Time Manipulation Prototypes (can be called any time AFTER PlayModule) /////////////////

void JiNX_SS_ReverbOn(void);
void JiNX_SS_ReverbOff(void);

void JiNX_SS_LPfilterOn(int cutoff_frequency_in_Hz);
void JiNX_SS_LPfilterOff(void);

void JiNX_SS_HPfilterOn(int cutoff_frequency_in_Hz);
void JiNX_SS_HPfilterOff(void);

void JiNX_SS_EnableContinuation(void);
void JiNX_SS_DisableContinuation(void);

int JiNX_SS_GotoOrderRow(int order, int row);

int JiNX_SS_TriggerExternal(void *sample_ptr, int type_8_or_16, int length_in_bytes,
                            int frequency, int volume_0_to_256, int pan_32_to_32);
int JiNX_SS_TriggerInternal(int channel, int note, int instrument);
int JiNX_SS_ConvertNoteString(char *string);


// Timing Prototypes //////////////////////////////////////////////////////////////////////////

int JiNX_SS_InstallAccurateTimer(int counter);
int JiNX_SS_UninstallAccurateTimer(void);

float JiNX_SS_WhatTimeIsIt(void);


// Closing Prototypes /////////////////////////////////////////////////////////////////////////

// CloseSoundSystem: Stops all data transfer to the soundcard
// UnloadModule: Frees the memory occupied by a loaded module (module must not be playing)

int  JiNX_SS_CloseSoundSystem(void);
void JiNX_SS_UnloadModule(JTM_module *mod);


