Unit Mouse;

Interface

Function  InitMouse : Integer;
Procedure ShowMouse;
Procedure HideMouse;
Procedure ReadMouse(Var x, y, b : Integer);
Procedure ReadMickey(Var x, y : Integer);
Function  LeftButtonPressed : Boolean;
Procedure WaitBClear;


Implementation

Function InitMouse : Integer; Assembler;

Asm
  Xor ax,ax
  Int 33h
End;

Procedure ShowMouse; Assembler;

Asm
  Mov ax,1h
  Int 33h
End;

Procedure HideMouse; Assembler;

Asm
  Mov ax,02h
  Int 33h
End;

Procedure ReadMouse(Var x, y, b : Integer);

Var
  i, j, k : Integer;

Begin
  Asm
    Mov ax,03h
    Int 33h
    Mov i,bx
    Mov j,cx
    Mov k,dx
  End;
  x := j Div 2;
  y := k;
  b := i;
End;

Procedure ReadMickey(Var x, y : Integer);

Var
  i, j : Integer;

Begin
  Asm
    Mov ax,0bh
    Int 33h
    Mov i,cx
    Mov j,dx
  End;
  x := i;
  y := j;
End;

Function  LeftButtonPressed : Boolean; Assembler;

Asm
  Mov ax,3
  Int 33h
  And bx,1
  Mov ax,bx
End;


Procedure WaitBClear;

Var
  a, b, c : Integer;

Begin
  Repeat
    ReadMouse(a, b, c);
  Until c = 0;
End;

End.