(*

                     Inertia Realtime 3D Rendering Engine
     Copyright (c) 1996, Alex Chalfin, Jeroen Bouwens. All Rights Reserved.

*)
Program Example06;
{ Inertia 3d system example. Demonstrates use of multiple objects and how   }
{ to do those faked light volumes and motion blur now popular in some demos.}
{ Alex Chalfin   12/28/96 }
{ achalfin@uceng.uc.edu   }
{$N+}

Uses
  Types,    { Inertia type declarations     }
  Inertia,  { the 3d engine                 }
  Mode13h,  { Basic Mode 13h graphics unit  }
  Polygons,
  Crt;

Const
  TextureData : String = 'Mess';

{$F+}
Procedure AvgCopyClear; External;
{$L BLUR.OBJ}
{$F-}

Var
  View : ViewObject;   { The View System }
  Obj1 : VectorObject; { A vector object }
  Obj2 : VectorObject; { A second vector object }
  Obj3 : VectorObject; { A vector object }
  Obj4 : VectorObject; { A vector object }
  Obj5 : VectorObject;
  i : Integer;
  VPage2 : Pointer;

Procedure MakePlane;

Const
  PlaneSize = 1200;

Begin
  AllocObject(Obj5, 5, 4);  { allocate an object with 4 verticies and 2 polygons }
  Obj5.Object_Definition^[0].x := -PlaneSize;
  Obj5.Object_Definition^[0].z := -PlaneSize;
  Obj5.Object_Definition^[0].y := 0;
  Obj5.Object_Definition^[1].x := PlaneSize;
  Obj5.Object_Definition^[1].z := -PlaneSize;
  Obj5.Object_Definition^[1].y := 0;
  Obj5.Object_Definition^[2].x := PlaneSize;
  Obj5.Object_Definition^[2].z := PlaneSize;
  Obj5.Object_Definition^[2].y := 0;
  Obj5.Object_Definition^[3].x := -PlaneSize;
  Obj5.Object_Definition^[3].z := PlaneSize;
  Obj5.Object_Definition^[3].y := 0;
  Obj5.Object_Definition^[4].x := 0;
  Obj5.Object_Definition^[4].z := 0;
  Obj5.Object_Definition^[4].y := 0;

  Obj5.Polygons^[0].A := 3;
  Obj5.Polygons^[0].B := 2;
  Obj5.Polygons^[0].C := 4;
  Obj5.Polygons^[1].A := 2;
  Obj5.Polygons^[1].B := 4;
  Obj5.Polygons^[1].C := 1;
  Obj5.Polygons^[2].A := 0;
  Obj5.Polygons^[2].B := 4;
  Obj5.Polygons^[2].C := 1;
  Obj5.Polygons^[3].A := 3;
  Obj5.Polygons^[3].B := 4;
  Obj5.Polygons^[3].C := 0;

  Obj5.Texture_Coords^[0].uv1.u := 0;
  Obj5.Texture_Coords^[0].uv1.v := 0;
  Obj5.Texture_Coords^[0].uv2.u := 255;
  Obj5.Texture_Coords^[0].uv2.v := 0;
  Obj5.Texture_Coords^[0].uv3.u := 127;
  Obj5.Texture_Coords^[0].uv3.v := 127;

  Obj5.Texture_Coords^[1].uv1.u := 255;
  Obj5.Texture_Coords^[1].uv1.v := 0;
  Obj5.Texture_Coords^[1].uv2.u := 127;
  Obj5.Texture_Coords^[1].uv2.v := 127;
  Obj5.Texture_Coords^[1].uv3.u := 255;
  Obj5.Texture_Coords^[1].uv3.v := 255;

  Obj5.Texture_Coords^[2].uv1.u := 0;
  Obj5.Texture_Coords^[2].uv1.v := 255;
  Obj5.Texture_Coords^[2].uv2.u := 127;
  Obj5.Texture_Coords^[2].uv2.v := 127;
  Obj5.Texture_Coords^[2].uv3.u := 255;
  Obj5.Texture_Coords^[2].uv3.v := 255;

  Obj5.Texture_Coords^[3].uv1.u := 0;
  Obj5.Texture_Coords^[3].uv1.v := 0;
  Obj5.Texture_Coords^[3].uv2.u := 127;
  Obj5.Texture_Coords^[3].uv2.v := 127;
  Obj5.Texture_Coords^[3].uv3.u := 0;
  Obj5.Texture_Coords^[3].uv3.v := 255;


  SetObjectTexture(Obj5, 0);
  SetCull(Obj5, False);
  SetSurface(Obj5, Texture);
  SetShading(Obj5, AMBIENT);
  SetAbsoluteLocation(Obj5, 0, 100, 0);
End;

Begin
  Getmem(VPage2, 64000);       { extra virtual page used for motion blur }
  FillChar(VPage2^, 64000, 0);

  If (LoadPCXTexture(0, TextureData + '.PCX', 0) <> I_OK)       { load the texture }
    Then Begin
      Writeln('Error loading texture.');
      Halt(0);
    End;
  If (LoadTransparencyTable(TextureData + '.TT', 0) <> I_OK) { load transparency table }
    Then Begin
      Writeln('Error loading transparency table.');
      Halt(0);
    End;
  If (LoadGVO(Obj1, 'Lights.GVO', 0) <> I_OK)         { load the vector object }
    Then Begin
      Writeln('Error loading LIGHTS object.');
      Halt(0);
    End;
  If (LoadGVO(Obj2, 'Torus.GVO', 0) <> I_OK)         { load the vector object }
    Then Begin
      Writeln('Error loading TORUS object.');
      Halt(0);
    End;
  i := Obj1.Num_Polygons + ((Obj2.Num_Polygons * 3) Div 2) + 12;
  If (InitView(View, i) <> I_OK) { init the view }
    Then Begin
      Writeln('Error Initializing view.');
      Halt(0);
    End;


  SetMode($13);              { Set graphics mode }
  GetTexturePalette(0);      { get the texture's palette }
  SetPalette(GlobalPalette); { Set the palette }

  SetSurface(Obj1, SMOOTH);    { set smooth surface for lights}
  SetShading(Obj1, AMBIENT);   { set ambient rendering for lights }

  SetCull(Obj1, FALSE);        { Turn off culling for the lights }
  SetObjTrans(Obj1, TRUE);     { Enable transparency for the lights }
  SetBaseColor(Obj1, 240);     { Set the Light's color }

  SetSurface(Obj2, TEXTURE);   { set smooth surface for torus}
  SetShading(Obj2, AMBIENT);   { set ambient rendering for torus}
  SetObjectTexture(Obj2, 0);   { Set the nice texture for the torus }

  For i := 0 to (Obj2.Num_Verticies - 1) do
    Dec(Obj2.Object_Definition^[i].z, 250);

  { Offset the torus for our nice circular copy }
  { Make copies of the torus object }
  CopyVectorObject(Obj2, Obj3);
  CopyVectorObject(Obj3, Obj4);

  { Circular copy around Y axis }
  SetDeltaRotation(Obj3, 0, 341, 0);
  SetDeltaRotation(Obj4, 0, 341*2, 0);

  { Set the view position }
  SetViewLocation(View, 0, 1000, -Obj1.Radius);
  SetFocusPoint(View, 0, 400, 0, 0);

  { Make the base plane }
  MakePlane;

  i := 0;
  Repeat
    SetDeltaRotation(Obj5, 0, -5, 0);   { Rotate the plane }
    AddtoRenderList(View, Obj5);        { Add it to the view }
    Render(View, Vpage2);    { go ahead an render the floor to avoid all }
                             { sorting problems }

    SetDeltaRotation(Obj1, 0, -5, 0);   { Rotate the lights }
    SetAbsoluteLocation(Obj1, 0, 0, 0);
    AddtoRenderList(View, Obj1);        { Add it to the render list }

    SetDeltaRotation(Obj2, 10, 30, -8);  { rotate the torii }
    SetDeltaRotation(Obj3, 10, 30, -8);
    SetDeltaRotation(Obj4, 10, 30, -8);
    SetAbsoluteLocation(Obj2, Round(Sin(i*2*Pi/256)*300), 400, 0);
    SetAbsoluteLocation(Obj3, Round(Sin(i*2*Pi/256)*300), 400, 0);
    SetAbsoluteLocation(Obj4, Round(Sin(i*2*Pi/256)*300), 400, 0);
    AddtoRenderList(View, Obj2);  { Add th torii to the render list }
    AddtoRenderList(View, Obj3);
    AddtoRenderList(View, Obj4);

    Render(View, VPage2);       { render lights and torii to the virtual page }

    While ((Port[$3da] And 8) = 0) do;

    AvgCopyClear;               { do a blur copy and clear }

    i := i + 1;

  Until KeyPressed;
  While (KeyPressed) do ReadKey;

  FreeView(View);          { Free the view's allocated memory }
  FreeVectorObject(Obj1);  { free the vector object's allocated memory }
  FreeVectorObject(Obj2);  { free the vector object's allocated memory }
  FreeVectorObject(Obj3);  { free the vector object's allocated memory }
  FreeVectorObject(Obj4);  { free the vector object's allocated memory }
  FreeVectorObject(Obj5);  { free the vector object's allocated memory }
  FreeTransparencyTable;

  FreeTexture(0);         { Free the phong map }

  SetMode($03);           { return to text mode }
  Writeln(View.FramesPerSecond:5:2);

  Freemem(VPage2, 64000);
End.