Comment *

                     Inertia Realtime 3D Rendering Engine
     Copyright (c) 1996, Alex Chalfin, Jeroen Bouwens. All Rights Reserved.


  This source file is the color bluring procedure used by Example 6 of the
Inertia real-time rendering system.

Alex Chalfin   12/28/96
achalfin@uceng.uc.edu
*


.Model Large,Pascal
.386

.Data

Extrn TT          : DWord
Extrn VPage2      : DWord
Extrn VirtualPage : DWord
Extrn SegA000     : Word

.Code

Public AvgCopyClear

AvgCopyClear Proc Uses es di

  Push ds              ;;
                       ;;
  Les  di,TT           ;; transparency table
  Lfs  di,VPage2       ;; vpage where latest rendering is
  Lgs  di,VirtualPage  ;; temporary virtual page
  Mov  ds,SegA000      ;; video memory selector
                       ;;
  Mov  si,32000        ;; Drawing words... loop 64000/2 times
 @Looper:              ;;
  Xor  bx,bx           ;;
  Mov  ax,fs:[di]      ;; VPage2
  Mov  dx,gs:[di]      ;; VirtualScreen
                       ;; chock full of ickey pipeline stalls :(
  Mov  bl,al           ;;
  Mov  cl,es:[bx]      ;; Load Vpage2 Transparent Pixel 1
  Mov  bl,ah           ;;
  Mov  ch,es:[bx]      ;; Load Vpage2 Transparent Pixel 2
  Mov  fs:[di],cx      ;; store it
                       ;;
  Mov  bl,al           ;; now make the video memory copy...
  Mov  bh,dl           ;;
  Mov  cl,es:[bx]      ;; read the first pixel transparency combo
  Mov  bl,ah           ;;
  Mov  bh,dh           ;;
  Mov  ch,es:[bx]      ;; second pixel transparency combo
  Mov  gs:[di],cx      ;; store on VirtualPage
  Mov  ds:[di],cx      ;; store in video memory
                       ;;
  Add  di,2            ;;
                       ;;
  Dec  si              ;;
  Jnz  @Looper         ;;
                       ;;
  Pop  ds              ;;
                       ;;
  Ret                  ;;
EndP AvgCopyClear

End
