////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "game.hpp"
#define THUNDERBOLTF_INUSE 1
float ThunderBolt_Rand()
{
	float Number = 0.0f;
	for (int i=0; i<6; i++)
		Number += (M_Rand() - M_Rand());
	Number *= (1.0f/6.0f);
	return Number;
}
void ThunderBolt_GeneratePoint(Vector3** CurrentPoint,
								Vector3 StartPosition, 
								Vector3 EndPosition, 
								float NoiseAmplitude,
								int NestingLevel)
{
	Vector3 NewCenterPoint;
	if (NestingLevel == 0)
	{
		VectorCopy(**CurrentPoint, EndPosition);
		(*CurrentPoint)++;
		return;
	}
	VectorAdd(NewCenterPoint, StartPosition, EndPosition);
	VectorScale2(NewCenterPoint, 0.5f);
	for (int i=0; i<3; i++)
		NewCenterPoint[i] += (NoiseAmplitude * (ThunderBolt_Rand() - 0.0f));
	NestingLevel--;
	NoiseAmplitude *= 0.5f;
	ThunderBolt_GeneratePoint(CurrentPoint, StartPosition, NewCenterPoint, 
								NoiseAmplitude,	NestingLevel);
	ThunderBolt_GeneratePoint(CurrentPoint, NewCenterPoint, EndPosition, 
								NoiseAmplitude, NestingLevel);
}
void ThunderBolts_DrawAll()
{
#define NUM_CENTER_POINTS 64
#define NUM_SUBDIVISIONS 6
#define BOLT_COLOR 0xffffffff
const float BOLT_WIDTH = 1.5f;
	ThunderBolt_t* Bolt = gs->ThunderBolts;
	Vector3 CenterPoints[NUM_CENTER_POINTS];
	Vector3* CurrentPoint;
	Vector3 Perpendicular, PerpendicularNormalized, BoltDirection;
	Sprite_t Sprite;
	D3D_SetRenderState(D3DRENDERSTATE_CULLMODE, D3DCULL_NONE);
	Sprite.Texture = "BOLT.gif";
	Sprite.Color = BOLT_COLOR;
	Sprite.Flags = (SPRITEF_SETIDENTITYMATRIX
					| SPRITEF_SETTEXTURE
					| SPRITEF_SETDEFAULTUV
					| SPRITEF_SETCOLOR);
	Sprite_Draw(&Sprite);
	Sprite.Flags = SPRITEF_DRAW;
	for (int i=0; i<MAX_THUNDERBOLTS; i++, Bolt++)
	{
		if (!(Bolt->Flags & THUNDERBOLTF_INUSE))
			continue;
		VectorSub(BoltDirection, Bolt->EndPosition, Bolt->StartPosition);
		CurrentPoint = CenterPoints;
		ThunderBolt_GeneratePoint(&CurrentPoint,
								Bolt->StartPosition, 
								Bolt->EndPosition,
								VectorLength(BoltDirection) * 0.4f,
								NUM_SUBDIVISIONS);
		if (M_fabs(DotProduct(BoltDirection, gs->Camera[1])) 
				< M_fabs(DotProduct(BoltDirection, gs->Camera[2])))
			CrossProduct(PerpendicularNormalized, gs->Camera[1], BoltDirection);
		else
			CrossProduct(PerpendicularNormalized, BoltDirection, gs->Camera[2]);
		VectorNormalize2(PerpendicularNormalized);
		VectorScale(Perpendicular, PerpendicularNormalized, 0.1f + (BOLT_WIDTH * M_Rand()));
		CurrentPoint = CenterPoints;
		for (int j=0; j<NUM_CENTER_POINTS; j++, CurrentPoint++)
		{
			if (j == 0)
			{
				VectorAdd(&Sprite.Vertices3d[3].x, Bolt->StartPosition, Perpendicular);
				VectorSub(&Sprite.Vertices3d[1].x, Bolt->StartPosition, Perpendicular);
			}
			else
			{
				VectorCopy(&Sprite.Vertices3d[3].x, &Sprite.Vertices3d[2].x);
				VectorCopy(&Sprite.Vertices3d[1].x, &Sprite.Vertices3d[0].x);
			}
			VectorAdd(&Sprite.Vertices3d[2].x, *CurrentPoint, Perpendicular);
			VectorSub(&Sprite.Vertices3d[0].x, *CurrentPoint, Perpendicular);
			Sprite_Draw(&Sprite);
		}
	}
	D3D_SetRenderState(D3DRENDERSTATE_CULLMODE, D3DCULL_CW);
}
void ThunderBolts_UpdateAll()
{
	Sys_memClear(gs->ThunderBolts, sizeof(gs->ThunderBolts));
}
void ThunderBolt_Add(Vector3 StartPosition, Vector3 EndPosition)
{
	ThunderBolt_t* Bolt = gs->ThunderBolts;
	int i;
	for (i=0; i<MAX_THUNDERBOLTS; i++, Bolt++)
		if (!(Bolt->Flags & THUNDERBOLTF_INUSE))
			break;
	if (i == MAX_THUNDERBOLTS)
		Error("ThunderBolt_Add()");
	Bolt->Flags = THUNDERBOLTF_INUSE;
	VectorCopy(Bolt->StartPosition, StartPosition);
	VectorCopy(Bolt->EndPosition, EndPosition);
}
