////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "system.hpp"

typedef struct {
	char Name[0x20];
	float CharCoords[0x100][4];
} FontData_t;
typedef struct {
	int DrawEnable;
	int FontIndex;
	int Color;
} TextData_t;

TextData_t* pText = 0;
FontData_t Fonts[1] = {
	"MedFont.pcx",
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 0-8
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 8-16
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 16-24
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 24-32
	//	        !       "        #        $      %        &       '
	/* */0.0f/256.0f,0.0f/128.0f,7.0f/256.0f,11.0f/128.0f,/*!*/7.0f/256.0f,1.0f/128.0f,10.0f/256.0f,10.0f/128.0f,/*"*/14.0f/256.0f,1.0f/128.0f,20.0f/256.0f,10.0f/128.0f,/*#*/22.0f/256.0f,1.0f/128.0f,30.0f/256.0f,10.0f/128.0f,/*$*/31.0f/256.0f,1.0f/128.0f,39.0f/256.0f,10.0f/128.0f,/*%*/40.0f/256.0f,1.0f/128.0f,48.0f/256.0f,10.0f/128.0f,/*&*/49.0f/256.0f,1.0f/128.0f,57.0f/256.0f,10.0f/128.0f,/*'*/61.0f/256.0f,1.0f/128.0f,65.0f/256.0f,10.0f/128.0f,// 32-40
	// (        )      *        +       ,       -      .       /
	/*(*/67.0f/256.0f,1.0f/128.0f,72.0f/256.0f,10.0f/128.0f,/*)*/75.0f/256.0f,1.0f/128.0f,80.0f/256.0f,10.0f/128.0f,/***/83.0f/256.0f,1.0f/128.0f,92.0f/256.0f,10.0f/128.0f,/*+*/93.0f/256.0f,1.0f/128.0f,100.0f/256.0f,10.0f/128.0f,/*,*/102.0f/256.0f,1.0f/128.0f,106.0f/256.0f,10.0f/128.0f,/*-*/109.0f/256.0f,1.0f/128.0f,117.0f/256.0f,10.0f/128.0f,/*.*/120.0f/256.0f,1.0f/128.0f,123.0f/256.0f,10.0f/128.0f,/*/*/127.0f/256.0f,1.0f/128.0f,136.0f/256.0f,10.0f/128.0f,// 40-48
	// 0         1       2        3        4          5      6        7
	/*0*/136.0f/256.0f,1.0f/128.0f,145.0f/256.0f,10.0f/128.0f,/*1*/146.0f/256.0f,1.0f/128.0f,150.0f/256.0f,10.0f/128.0f,/*2*/151.0f/256.0f,1.0f/128.0f,160.0f/256.0f,10.0f/128.0f,/*3*/160.0f/256.0f,1.0f/128.0f,169.0f/256.0f,10.0f/128.0f,/*4*/169.0f/256.0f,1.0f/128.0f,178.0f/256.0f,10.0f/128.0f,/*5*/178.0f/256.0f,1.0f/128.0f,187.0f/256.0f,10.0f/128.0f,/*6*/187.0f/256.0f,1.0f/128.0f,196.0f/256.0f,10.0f/128.0f,/*7*/196.0f/256.0f,1.0f/128.0f,205.0f/256.0f,10.0f/128.0f,// 48-56
	// 8         9      :        ;         <        =        >        ?
	/*8*/205.0f/256.0f,1.0f/128.0f,214.0f/256.0f,10.0f/128.0f,/*9*/214.0f/256.0f,1.0f/128.0f,223.0f/256.0f,10.0f/128.0f,/*:*/225.0f/256.0f,1.0f/128.0f,228.0f/256.0f,10.0f/128.0f,/*;*/235.0f/256.0f,1.0f/128.0f,238.0f/256.0f,10.0f/128.0f,/*<*/242.0f/256.0f,1.0f/128.0f,248.0f/256.0f,10.0f/128.0f,/*=*/1.0f/256.0f,11.0f/128.0f,8.0f/256.0f,20.0f/128.0f,/*>*/11.0f/256.0f,11.0f/128.0f,17.0f/256.0f,20.0f/128.0f,/*?*/18.0f/256.0f,11.0f/128.0f,25.0f/256.0f,20.0f/128.0f,// 56-64
	//  @     A        B       C         D         E       F         G  
	/* @ */27.0f/256.0f,11.0f/128.0f,35.0f/256.0f,20.0f/128.0f,/*A*/36.0f/256.0f,11.0f/128.0f,45.0f/256.0f,20.0f/128.0f,/*B*/45.0f/256.0f,11.0f/128.0f,54.0f/256.0f,20.0f/128.0f,/*C*/54.0f/256.0f,11.0f/128.0f,63.0f/256.0f,20.0f/128.0f,/*D*/63.0f/256.0f,11.0f/128.0f,72.0f/256.0f,20.0f/128.0f,/*E*/72.0f/256.0f,11.0f/128.0f,81.0f/256.0f,20.0f/128.0f,/*F*/81.0f/256.0f,11.0f/128.0f,90.0f/256.0f,20.0f/128.0f,/*G*/90.0f/256.0f,11.0f/128.0f,99.0f/256.0f,20.0f/128.0f,// 64-72
	//   H      I         J        K      L         M       N        O
	/*H*/99.0f/256.0f,11.0f/128.0f,108.0f/256.0f,20.0f/128.0f,/*I*/109.0f/256.0f,11.0f/128.0f,112.0f/256.0f,20.0f/128.0f,/*J*/114.0f/256.0f,11.0f/128.0f,123.0f/256.0f,20.0f/128.0f,/*K*/123.0f/256.0f,11.0f/128.0f,132.0f/256.0f,20.0f/128.0f,/*L*/132.0f/256.0f,11.0f/128.0f,141.0f/256.0f,20.0f/128.0f,/*M*/141.0f/256.0f,11.0f/128.0f,150.0f/256.0f,20.0f/128.0f,/*N*/150.0f/256.0f,11.0f/128.0f,159.0f/256.0f,20.0f/128.0f,/*O*/159.0f/256.0f,11.0f/128.0f,168.0f/256.0f,20.0f/128.0f,// 72-80
	//   P      Q         R      S         T        U       V         W 
	/*P*/168.0f/256.0f,11.0f/128.0f,177.0f/256.0f,20.0f/128.0f,/*Q*/177.0f/256.0f,11.0f/128.0f,186.0f/256.0f,20.0f/128.0f,/*R*/186.0f/256.0f,11.0f/128.0f,195.0f/256.0f,20.0f/128.0f,/*S*/195.0f/256.0f,11.0f/128.0f,204.0f/256.0f,20.0f/128.0f,/*T*/204.0f/256.0f,11.0f/128.0f,213.0f/256.0f,20.0f/128.0f,/*U*/213.0f/256.0f,11.0f/128.0f,222.0f/256.0f,20.0f/128.0f,/*V*/222.0f/256.0f,11.0f/128.0f,231.0f/256.0f,20.0f/128.0f,/*W*/231.0f/256.0f,11.0f/128.0f,240.0f/256.0f,20.0f/128.0f,// 80-88
	//   X       Y       Z         [                ]        ^        _
	/*X*/240.0f/256.0f,11.0f/128.0f,249.0f/256.0f,20.0f/128.0f,/*Y*/0.0f/256.0f,21.0f/128.0f,9.0f/256.0f,30.0f/128.0f,/*Z*/9.0f/256.0f,21.0f/128.0f,9.0f/256.0f,30.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 88-96
	//   `       a        b       c        d         e       f          g
	/*'*/0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,/*a*/71.0f/256.0f,21.0f/128.0f,79.0f/256.0f,30.0f/128.0f,/*b*/80.0f/256.0f,21.0f/128.0f,88.0f/256.0f,30.0f/128.0f,/*c*/89.0f/256.0f,21.0f/128.0f,97.0f/256.0f,30.0f/128.0f,/*d*/98.0f/256.0f,21.0f/128.0f,105.0f/256.0f,30.0f/128.0f,/*e*/107.0f/256.0f,21.0f/128.0f,115.0f/256.0f,30.0f/128.0f,/*f*/116.0f/256.0f,21.0f/128.0f,124.0f/256.0f,30.0f/128.0f,/*g*/125.0f/256.0f,21.0f/128.0f,133.0f/256.0f,30.0f/128.0f,// 96-104
	//   h     i         j        k       l        m         n        o
	/*h*/134.0f/256.0f,21.0f/128.0f,142.0f/256.0f,30.0f/128.0f,/*i*/144.0f/256.0f,21.0f/128.0f,147.0f/256.0f,30.0f/128.0f,/*j*/149.0f/256.0f,21.0f/128.0f,156.0f/256.0f,30.0f/128.0f,/*k*/157.0f/256.0f,21.0f/128.0f,164.0f/256.0f,30.0f/128.0f,/*l*/166.0f/256.0f,21.0f/128.0f,171.0f/256.0f,30.0f/128.0f,/*m*/172.0f/256.0f,21.0f/128.0f,181.0f/256.0f,30.0f/128.0f,/*n*/182.0f/256.0f,21.0f/128.0f,190.0f/256.0f,30.0f/128.0f,/*o*/191.0f/256.0f,21.0f/128.0f,199.0f/256.0f,30.0f/128.0f,// 104-112
	//  p      q         r       s          t      u        v         w
	/*p*/200.0f/256.0f,21.0f/128.0f,208.0f/256.0f,30.0f/128.0f,/*q*/209.0f/256.0f,21.0f/128.0f,217.0f/256.0f,30.0f/128.0f,/*r*/218.0f/256.0f,21.0f/128.0f,226.0f/256.0f,30.0f/128.0f,/*s*/227.0f/256.0f,21.0f/128.0f,235.0f/256.0f,30.0f/128.0f,/*t*/236.0f/256.0f,21.0f/128.0f,243.0f/256.0f,30.0f/128.0f,/*u*/0.0f/256.0f,31.0f/128.0f,8.0f/256.0f,40.0f/128.0f,/*v*/9.0f/256.0f,31.0f/128.0f,17.0f/256.0f,40.0f/128.0f,/*w*/18.0f/256.0f,31.0f/128.0f,27.0f/256.0f,40.0f/128.0f,// 112-120
	//   x       y        z
	/*x*/28.0f/256.0f,31.0f/128.0f,36.0f/256.0f,40.0f/128.0f,/*y*/37.0f/256.0f,31.0f/128.0f,45.0f/256.0f,40.0f/128.0f,/*z*/46.0f/256.0f,31.0f/128.0f,54.0f/256.0f,40.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 120-128
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 128-136
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 136-144
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 144-152
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 152-160
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 160-168
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 168-176
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 176-184
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 184-192
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 192-200
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 200-208
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 208-216
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 216-224
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 224-232
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 232-240
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 240-248
	0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,  0.0f/256.0f,0.0f/128.0f,0.0f/256.0f,0.0f/128.0f,// 248-256
	};
void Text_CheckInit()
{
	if (pText)
		return;
	pText = (TextData_t*)Sys_HeapAlloc(sizeof(*pText));
	pText->DrawEnable = true;
	pText->FontIndex = 0;
	pText->Color = 0xffffffff;
}
void Text_Enable(int enable)
{
	Text_CheckInit();
	pText->DrawEnable = enable;
}
void Text_GetStringExtent(char* String, float* ExtentX)
{
	*ExtentX = 0.0f;
	while (*String != 0)
	{
		int CharIndex = *(String++);
		float* CharCoords = Fonts[pText->FontIndex].CharCoords[CharIndex];
		*ExtentX += (CharCoords[2] - CharCoords[0]);
	}
}
void Text_printf(float x0, float y0, float x1, float y1, char* szFormat,...)
{
	char String[0x100];
	Sprite_t Sprite;
	Text_CheckInit();
	if (!pText->DrawEnable)
		return;
	Sprite.SrcBlend = D3DBLEND_SRCALPHA;
	Sprite.DestBlend = D3DBLEND_INVSRCALPHA;
	Sprite.Texture = Fonts[pText->FontIndex].Name;
	Sprite.Color = pText->Color;
	Sprite.Flags = (SPRITEF_INITRENDERSTATE
					| SPRITEF_SETDEFAULTZW	
					| SPRITEF_SETTEXTURE
					| SPRITEF_SETCOLOR
					| SPRITEF_2D);
	Sprite_Draw(&Sprite);
	Sprite.Flags = (SPRITEF_2D
					| SPRITEF_DRAW
					| SPRITEF_SETUV
					| SPRITEF_SETXY);
	Sys_vsprintf(String, szFormat, (char*)&szFormat + sizeof(szFormat));
	float StringExtentX;
	Text_GetStringExtent(String, &StringExtentX);
	float ScaleX = (x1 - x0) / StringExtentX;
	float* CharCoords = &Fonts[pText->FontIndex].CharCoords[0][0];
	char* pString = String;
	for (int i=Sys_strlen(String); i>0; i--)
	{
		int CharIndex = *(pString++);
		float* uv = &CharCoords[CharIndex << 2];
		float DeltaU = uv[2] - uv[0];
		x1 = x0 + DeltaU * ScaleX;
		Sprite.u0 = uv[0];
		Sprite.v0 = uv[1];
		Sprite.u1 = uv[2];
		Sprite.v1 = uv[3];
		Sprite.x0 = x0;
		Sprite.y0 = y0;
		Sprite.x1 = x1;
		Sprite.y1 = y1;
		Sprite_Draw(&Sprite);
		x0 = x1;		
	}
	Sprite.Flags = (SPRITEF_RESETRENDERSTATE
					| SPRITEF_2D);
	Sprite_Draw(&Sprite);
}