////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
typedef float Vector3[3];
typedef float Matrix4x3[4][3];
typedef struct {
	float    sx;
    float    sy;
    float    sz;
    float    rhw;
    int      color;
    float    tu;
    float    tv;
} TLVERTEX;
typedef struct {
    float     x;
    float     y;
    float     z;
    int       color;
    float     tu;
    float     tv;
} LVERTEX;
typedef struct {
	char name[0x40];
	unsigned short triIndexMin;
	unsigned short triIndexMax;
} SubMeshDesc_t;
typedef struct {
	void* pTexture;
	int NumVertices;
} TriGroup_t;
typedef struct {
	Vector3 Normal;
	Vector3 Mins;
	Vector3 Maxs;
	LVERTEX* pVertices;
} TriangleDesc_t;
typedef struct Mesh_t{
	char szName[0x80];
	Mesh_t* pNext;
	int NumSubMeshes;
	SubMeshDesc_t* pSubMeshes;
	float Radius;
	Vector3 Mins;
	Vector3 Maxs;
	int NumTriangles;
	int NumTriGroups;
	TriangleDesc_t* pTriDesc;
	char* pTriangles;
/*	TriGroup_t triGroup01;
	LVERTEX v01;
	LVERTEX v02;
	LVERTEX v03;
		(...)
	LVERTEX v0[triGroup01.numVertices];
	TriGroup_t triGroup02;
	LVERTEX v01;
	LVERTEX v02;
	LVERTEX v03;
		(...)
	LVERTEX v0[triGroup02.numVertices];*/
} Mesh_t;
//////////////////////////////////////////////////////////////
const float F_PI = 3.14159265358979323846f;
extern Matrix4x3 MatrixIdentity;
void M_Randomize(int seed);
float M_Rand();
float M_fatan2(float n, float d);
float M_AngleMod(float Angle);
float M_fsqrt(float f);
float M_fcos(float angle);
float M_fsin(float angle);
float M_fabs(float f);
float M_fmod(float a, float b);
void M_AnglesVectorMod(Vector3 AnglesVector);
void M_BBoxAddPoint(Vector3 mins, Vector3 maxs, Vector3 point);
void M_BBoxGetCorners(Vector3* corners, Vector3 mins, Vector3 maxs);

void Matrix_GetAngles(Vector3 angles, Matrix4x3 matrix);
void Matrix_SetProjectionTransform(float* mat, float fFOV, float fAspect,
                                   float fNearPlane, float fFarPlane);
void Matrix_Set(Matrix4x3 mat, Vector3 translation, 
							   Vector3 rotation, 
							   Vector3 scaling);
void Matrix_MultiplyRotations(Matrix4x3 dest, Matrix4x3 a, Matrix4x3 b);
void Matrix_Rotate(Matrix4x3 Dest, Matrix4x3 Src, Vector3 Angles);
void Matrix_Transpose(Matrix4x3 dest, Matrix4x3 src);
void Matrix_Scale(Matrix4x3 dest, Matrix4x3 src, Vector3 scaling);
void Matrix_Copy(Matrix4x3 d, Matrix4x3 s);
void Matrix_Clear(Matrix4x3 mat);
void Matrix_SetIdentity(Matrix4x3 mat);

char* VectorToString(Vector3 v);
void VectorTransform(Matrix4x3 mat, Vector3 dest, Vector3 src);
void VectorInverseTransform(Matrix4x3 mat, Vector3 dest, Vector3 src);
void VectorRotate(Matrix4x3 mat, Vector3 dest, Vector3 src);
void VectorInverseRotate(Matrix4x3 mat, Vector3 dest, Vector3 src);
float VectorNormalize2(Vector3 v);
float VectorNormalize(Vector3 d, Vector3 s);
float VectorLength(Vector3 v);
float VectorSqrdLength(Vector3 v);
float VectorDistance(Vector3 a, Vector3 b);
float VectorSqrdDistance(Vector3 a, Vector3 b);
void CrossProduct(Vector3 d,Vector3 a, Vector3 b);
float DotProduct(Vector3 a, Vector3 b);
void VectorScale(Vector3 d, Vector3 s, float scalar);
void VectorScale2(Vector3 v, float scalar);
void VectorAdd(Vector3 d, Vector3 a, Vector3 b);
void VectorAdd2(Vector3 d, Vector3 s);
void VectorSub(Vector3 d, Vector3 a, Vector3 b);
void VectorSub2(Vector3 d, Vector3 s);
void VectorNegate(Vector3 d, Vector3 s);
void VectorNegate2(Vector3 v);
bool VectorIsNull(Vector3 v);
void VectorRandom(Vector3 v);
//////////////////////////////////////////////////////////////
inline void VectorClear(Vector3 v)
{
	v[0]=v[1]=v[2]=0;
}
inline void VectorCopy(Vector3 d, Vector3 s)
{
	d[0]=s[0];
	d[1]=s[1];
	d[2]=s[2];
}
inline void VectorSet(Vector3 v, float x, float y, float z)
{
	v[0] = x;
	v[1] = y;
	v[2] = z;
}
//////////////////////////////////////////////////////////////
inline void TLVERTEX_Set(TLVERTEX* v, float _sx, float _sy, float _sz, float _rhw, int _color, float _tu, float _tv)
{
		v->sx = _sx; v->sy = _sy; v->sz = _sz; v->rhw = _rhw;
	    v->color = _color;
		v->tu = _tu; v->tv = _tv;
}
inline void LVERTEX_Set(LVERTEX* v, float _x, float _y, float _z, int _color, float _tu, float _tv)
{
		v->x = _x; v->y = _y; v->z = _z;
	    v->color = _color;
		v->tu = _tu; v->tv = _tv;
}
typedef struct {
    int      dwSize;
    int      dwX;
    int      dwY;
    int      dwWidth;
    int      dwHeight;
    float    dvClipX;
    float    dvClipY;
    float    dvClipWidth;
    float    dvClipHeight;
    float    dvMinZ;
    float    dvMaxZ;
} D3D_VIEWPORT2;
#define SPRITEF_2D 1
#define SPRITEF_DRAW 2
#define SPRITEF_BILLBOARD 4
#define SPRITEF_INITRENDERSTATE 8
#define SPRITEF_RESETRENDERSTATE 0x10
#define SPRITEF_SETIDENTITYMATRIX 0x20
#define SPRITEF_SETDEFAULTZW 0x40
#define SPRITEF_SETDEFAULTUV 0x80
#define SPRITEF_SETDEFAULTCOLOR 0x100
#define SPRITEF_SETMATRIX 0x200
#define SPRITEF_SETTEXTURE 0x400
#define SPRITEF_SETXY 0x800
#define SPRITEF_SETUV 0x1000
#define SPRITEF_SETCOLOR 0x2000
#define SPRITEF_NOSCALEXY 0x4000
typedef struct {
	int		Flags;
	int		SrcBlend;
	int		DestBlend;
	int		Color;
	float	x0;
	float	y0;
	float	x1;
	float	y1;
	float	u0;
	float	v0;
	float	u1;
	float	v1;
	LVERTEX Vertices3d[4];
	TLVERTEX Vertices2d[4];	
	char*	Texture; 
	Vector3* Position;
	Matrix4x3* Matrix;
	float Width;
	float Height;
} Sprite_t;
//////////////////////////////////////////////////////////////
void D3D_Create(int hWnd, int doD3D);
void D3D_Release();
int D3D_SetTexture(int stage, void* lpTexture);
int D3D_SetTransform(int transformStateType, float* pMatrix);
int D3D_DrawPrimitive(int primitiveType, int vertexType, void* lpVertices, int vertexCount, int flags);
int D3D_SetRenderState(int renderStateType, int renderState);
int D3D_ViewportClear2(int count, int* pRectangles, int flags, int color, float z, int stencil);
int D3D_BeginScene();
int D3D_EndScene();
int D3D_Flip();
int D3D_SetTextureStageState(int stage, int state, int value);
D3D_VIEWPORT2* D3D_GetViewport2();
int MAKE_RGBA(float r, float g, float b, float a);
void* Texture_Get(char* Name);
void Texture_GetPalette(char* Name, int FirstIndex, int LastIndex, unsigned char* Palette);
void Texture_SetPalette(char* Name, int FirstIndex, int LastIndex, unsigned char* Palette);
void Texture_Load(char* Name, char* SrcData, char* Palette, int Width, int Height, int NumMipMapLevels);
int Texture_CalcMemRequired(int Width,int Height, int MipMapCount);
void Sprite_Draw(Sprite_t* Sprite);
void Mesh_Draw(Mesh_t* mesh, Matrix4x3 matrix, Vector3 scaling);
Mesh_t* Mesh_Get(char* name);
void Mesh_GetBBox(Mesh_t* mesh, Vector3 mins, Vector3 maxs, 
				Matrix4x3 matrix, Vector3 translation, Vector3 rotation, Vector3 scaling);
void Mesh_SetTrianglesDesc(Mesh_t* mesh);
//////////////////////////////////////////////////////////////
unsigned char		Keyboard[];
void Input_Create(int hWnd, int hInstance);
void Input_Release();
void Input_Update();
char* Input_GetKeyName(int Key);
//////////////////////////////////////////////////////////////
#define SOUND_3D 1
#define SOUND_LOOPED 2
void Sound_Create(int hWnd, int DoSound);
void Sound_Release();
void Sound_Load(char* Name, void* WavFormat, void* SamplesData, int DataSize);
void Sound_Play(char* Name, Vector3 Position, Vector3 Velocity, int* Instance, int Flags);
void Sound_Stop(char* Name, int Instance);
void Sound_UpdateAll(Vector3 MoveAll);
/////////////////////
void __cdecl Text_printf(float x0, float y0, float x1, float y1, char* szFormat,...);
void Text_Enable(int enable);
//////////////////////////////////////////////////////////////
void Resources_Create(char* szFileName);
/////////////////////
void Pak();
/////////////////////
#define SYSF_DOD3D 1
#define SYSF_DOSOUND 2
#define SYSF_DOPAK 4
void Sys_Init(int Flags);
int Sys_pumpMsg();
void Sys_Exit();
void init();
void run();
void release();
void __cdecl Error(char* szFormat,...);
int Sys_GetTickCount();
void Sys_memClear(void* lpDest, int size);
void Sys_memCopy(void* pDest, void* pSrc, int size);
void Sys_MemFree(void* lpData);
void* Sys_MemAlloc(int size);
void Sys_FileSeekBegin(int hFile, int offset);
int Sys_FileGetSize(int hFile);
void Sys_FileWrite(char* szFileName, int hFile, void* lpSrc, int size);
void Sys_FileRead(char* szFileName, int hFile, void* lpDest, int size);
void Sys_FileClose(int hFile);
int Sys_FileCreate(char* lpszFileName);
int Sys_FileOpen(char* lpszFileName);
void* Sys_FileLoad(char* szFileName,int* lpFileSize);
int Sys_FileExists(char* szFileName);
void* Sys_HeapAlloc(int size);
void* Sys_HeapAllocTemp(int size);
void Sys_HeapFreeTemp(void* data);
int Sys_strlen(char* string);
void Sys_strcat(char* dest, char* src);
void Sys_strcpy(char* dest, char* src);
void __cdecl Sys_sprintf(char* dest,char* szFormat,...);
void Sys_vsprintf(char* dest, char* szFormat, char* pArgList);
int Sys_strcmp(char* string1, char* string2);
int Sys_strncmp(char* string1, char* string2, int count);
char* Sys_strchr(char* string, int chr);
void Sys_StrToUpper(char* string);
int Sys_atoi(char* szSrc);
void Sys_logOpen(char* szLogFile);
void Sys_logClose();
void __cdecl Sys_logPrintf(char* szFormat,...);
//////////////////////////////////////////////////////////////
#ifndef D3D_INCLUDED
#define D3DRENDERSTATE_ZWRITEENABLE       14
#define D3DRENDERSTATE_ALPHATESTENABLE    15
#define D3DRENDERSTATE_SRCBLEND           19
#define D3DRENDERSTATE_DESTBLEND          20
#define D3DRENDERSTATE_CULLMODE           22
#define D3DRENDERSTATE_ZFUNC              23
#define D3DRENDERSTATE_ALPHAREF           24
#define D3DRENDERSTATE_ALPHAFUNC          25
#define D3DRENDERSTATE_DITHERENABLE       26
#define D3DRENDERSTATE_ALPHABLENDENABLE   27
#define D3DRENDERSTATE_FOGENABLE          28
#define D3DRENDERSTATE_FOGCOLOR           34
#define D3DRENDERSTATE_FOGTABLEMODE       35
#define D3DRENDERSTATE_FOGTABLESTART      36
#define D3DRENDERSTATE_FOGTABLEEND        37
#define D3DRENDERSTATE_FOGTABLEDENSITY    38
#define D3DRENDERSTATE_COLORKEYENABLE     41
#define D3DRENDERSTATE_ZBIAS              47
#define D3DCULL_NONE               1
#define D3DCULL_CW                 2
#define D3DCULL_CCW                3
#define D3DCMP_NEVER               1
#define D3DCMP_LESS                2
#define D3DCMP_EQUAL               3
#define D3DCMP_LESSEQUAL           4
#define D3DCMP_GREATER             5
#define D3DCMP_NOTEQUAL            6
#define D3DCMP_GREATEREQUAL        7
#define D3DCMP_ALWAYS              8
#define D3DTSS_COLOROP         1
#define D3DTSS_COLORARG1       2
#define D3DTSS_COLORARG2       3
#define D3DTSS_ALPHAOP         4
#define D3DTSS_ALPHAARG1       5
#define D3DTSS_ALPHAARG2       6
#define D3DTSS_ADDRESS        12
#define D3DTSS_MAGFILTER      16
#define D3DTSS_MINFILTER      17
#define D3DTSS_MIPFILTER      18
#define D3DTOP_SELECTARG1 2
#define D3DTOP_SELECTARG2 3
#define D3DTOP_MODULATE   4
#define D3DTA_DIFFUSE           0x00000000
#define D3DTA_TEXTURE           0x00000002
#define D3DTFG_POINT        1
#define D3DTFG_LINEAR       2
#define D3DTFN_POINT        1
#define D3DTFN_LINEAR       2
#define D3DTFP_POINT        2
#define D3DTFP_LINEAR       3
#define D3DTRANSFORMSTATE_WORLD           1
#define D3DTRANSFORMSTATE_VIEW            2
#define D3DTRANSFORMSTATE_PROJECTION      3
#define D3DPT_LINELIST       2
#define D3DPT_TRIANGLELIST   4
#define D3DPT_TRIANGLESTRIP  5
#define D3DFVF_XYZ              0x002
#define D3DFVF_XYZRHW           0x004
#define D3DFVF_DIFFUSE          0x040
#define D3DFVF_TEX1             0x100
#define D3DFVF_LVERTEX ( D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1)
#define D3DFVF_TLVERTEX ( D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_TEX1 )
#define D3DTADDRESS_WRAP    1
#define D3DTADDRESS_CLAMP   3
#define D3DBLEND_ZERO               1
#define D3DBLEND_ONE                2
#define D3DBLEND_SRCCOLOR           3
#define D3DBLEND_INVSRCCOLOR        4
#define D3DBLEND_SRCALPHA           5
#define D3DBLEND_INVSRCALPHA        6
#define D3DBLEND_DESTALPHA          7
#define D3DBLEND_INVDESTALPHA       8
#define D3DBLEND_DESTCOLOR          9
#define D3DBLEND_INVDESTCOLOR       10
#define D3DBLEND_SRCALPHASAT        11
#define D3DBLEND_BOTHSRCALPHA       12
#define D3DBLEND_BOTHINVSRCALPHA    13
#endif
//////////////////////////////////////////////////////////////
#ifndef DINPUT_INCLUDED
#define DIK_ESCAPE          0x01
#define DIK_1               0x02
#define DIK_2               0x03
#define DIK_3               0x04
#define DIK_4               0x05
#define DIK_5               0x06
#define DIK_6               0x07
#define DIK_7               0x08
#define DIK_8               0x09
#define DIK_9               0x0A
#define DIK_0               0x0B
#define DIK_MINUS           0x0C    /* - on main keyboard */
#define DIK_EQUALS          0x0D
#define DIK_BACK            0x0E    /* backspace */
#define DIK_TAB             0x0F
#define DIK_Q               0x10
#define DIK_W               0x11
#define DIK_E               0x12
#define DIK_R               0x13
#define DIK_T               0x14
#define DIK_Y               0x15
#define DIK_U               0x16
#define DIK_I               0x17
#define DIK_O               0x18
#define DIK_P               0x19
#define DIK_LBRACKET        0x1A
#define DIK_RBRACKET        0x1B
#define DIK_RETURN          0x1C    /* Enter on main keyboard */
#define DIK_LCONTROL        0x1D
#define DIK_A               0x1E
#define DIK_S               0x1F
#define DIK_D               0x20
#define DIK_F               0x21
#define DIK_G               0x22
#define DIK_H               0x23
#define DIK_J               0x24
#define DIK_K               0x25
#define DIK_L               0x26
#define DIK_SEMICOLON       0x27
#define DIK_APOSTROPHE      0x28
#define DIK_GRAVE           0x29    /* accent grave */
#define DIK_LSHIFT          0x2A
#define DIK_BACKSLASH       0x2B
#define DIK_Z               0x2C
#define DIK_X               0x2D
#define DIK_C               0x2E
#define DIK_V               0x2F
#define DIK_B               0x30
#define DIK_N               0x31
#define DIK_M               0x32
#define DIK_COMMA           0x33
#define DIK_PERIOD          0x34    /* . on main keyboard */
#define DIK_SLASH           0x35    /* / on main keyboard */
#define DIK_RSHIFT          0x36
#define DIK_MULTIPLY        0x37    /* * on numeric keypad */
#define DIK_LMENU           0x38    /* left Alt */
#define DIK_SPACE           0x39
#define DIK_CAPITAL         0x3A
#define DIK_F1              0x3B
#define DIK_F2              0x3C
#define DIK_F3              0x3D
#define DIK_F4              0x3E
#define DIK_F5              0x3F
#define DIK_F6              0x40
#define DIK_F7              0x41
#define DIK_F8              0x42
#define DIK_F9              0x43
#define DIK_F10             0x44
#define DIK_NUMLOCK         0x45
#define DIK_SCROLL          0x46    /* Scroll Lock */
#define DIK_NUMPAD7         0x47
#define DIK_NUMPAD8         0x48
#define DIK_NUMPAD9         0x49
#define DIK_SUBTRACT        0x4A    /* - on numeric keypad */
#define DIK_NUMPAD4         0x4B
#define DIK_NUMPAD5         0x4C
#define DIK_NUMPAD6         0x4D
#define DIK_ADD             0x4E    /* + on numeric keypad */
#define DIK_NUMPAD1         0x4F
#define DIK_NUMPAD2         0x50
#define DIK_NUMPAD3         0x51
#define DIK_NUMPAD0         0x52
#define DIK_DECIMAL         0x53    /* . on numeric keypad */
#define DIK_F11             0x57
#define DIK_F12             0x58
#define DIK_RCONTROL        0x9D
#define DIK_NUMPADCOMMA     0xB3    /* , on numeric keypad (NEC PC98) */
#define DIK_DIVIDE          0xB5    /* / on numeric keypad */
#define DIK_SYSRQ           0xB7
#define DIK_RMENU           0xB8    /* right Alt */
#define DIK_HOME            0xC7    /* Home on arrow keypad */
#define DIK_UP              0xC8    /* UpArrow on arrow keypad */
#define DIK_PRIOR           0xC9    /* PgUp on arrow keypad */
#define DIK_LEFT            0xCB    /* LeftArrow on arrow keypad */
#define DIK_RIGHT           0xCD    /* RightArrow on arrow keypad */
#define DIK_END             0xCF    /* End on arrow keypad */
#define DIK_DOWN            0xD0    /* DownArrow on arrow keypad */
#define DIK_NEXT            0xD1    /* PgDn on arrow keypad */
#define DIK_INSERT          0xD2    /* Insert on arrow keypad */
#define DIK_DELETE          0xD3    /* Delete on arrow keypad */
#define DIK_LWIN            0xDB    /* Left Windows key */
#define DIK_RWIN            0xDC    /* Right Windows key */
#define DIK_APPS            0xDD    /* AppMenu key */
#define DIK_BACKSPACE       DIK_BACK            /* backspace */
#define DIK_NUMPADSTAR      DIK_MULTIPLY        /* * on numeric keypad */
#define DIK_LALT            DIK_LMENU           /* left Alt */
#define DIK_CAPSLOCK        DIK_CAPITAL         /* CapsLock */
#define DIK_NUMPADMINUS     DIK_SUBTRACT        /* - on numeric keypad */
#define DIK_NUMPADPLUS      DIK_ADD             /* + on numeric keypad */
#define DIK_NUMPADPERIOD    DIK_DECIMAL         /* . on numeric keypad */
#define DIK_NUMPADSLASH     DIK_DIVIDE          /* / on numeric keypad */
#define DIK_RALT            DIK_RMENU           /* right Alt */
#define DIK_UPARROW         DIK_UP              /* UpArrow on arrow keypad */
#define DIK_PGUP            DIK_PRIOR           /* PgUp on arrow keypad */
#define DIK_LEFTARROW       DIK_LEFT            /* LeftArrow on arrow keypad */
#define DIK_RIGHTARROW      DIK_RIGHT           /* RightArrow on arrow keypad */
#define DIK_DOWNARROW       DIK_DOWN            /* DownArrow on arrow keypad */
#define DIK_PGDN            DIK_NEXT            /* PgDn on arrow keypad */
#endif