////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#define D3D_INCLUDED
#include "system.hpp"
#include <dsound.h> 
#define MAX_SOUNDS 20
#define MAX_SOUND_INSTANCES 10
#define SOUNDF_INUSE 1
#define SOUNDINSTANCEF_PLAYING 1
#define SOUNDINSTANCEF_WANTTOPLAY 2
#define SOUNDINSTANCEF_WANTTOSTOP 4
#define SOUNDINSTANCEF_3D 8
#define SOUNDINSTANCEF_LOOPED 0x10
typedef struct {
	int Flags;
	Vector3 Position;
	Vector3 Velocity;
	IDirectSoundBuffer* Buffer;
	IDirectSound3DBuffer* Buffer3D;
} SoundInstance_t;
typedef struct {
	char Name[0x80];
	int Flags;
	int NumInstances;
	SoundInstance_t Instances[MAX_SOUND_INSTANCES];
} Sound_t;
typedef struct {
	int DoSound;
	int NumPlayingBuffers, MaxPlayingBuffers;
	IDirectSound* DSound;
	IDirectSoundBuffer* DSBPrimary;
	IDirectSound3DListener* Listener;
	Sound_t Sounds[MAX_SOUNDS];
} SoundData_t;
SoundData_t* SoundData;
void Sound_Create(int hWnd, int DoSound)
{
	DS3DLISTENER ds3dlistener;
	DSBUFFERDESC dsbdesc;
	WAVEFORMATEX wfx;
	SoundData = (SoundData_t*)Sys_HeapAlloc(sizeof(*SoundData));
	SoundData->DoSound = DoSound;
	if (!SoundData->DoSound)
		return;
	if (DirectSoundCreate(0, &SoundData->DSound, 0))
		Error("DirectSoundCreate()");
	if (SoundData->DSound->SetCooperativeLevel((HWND)hWnd, DSSCL_PRIORITY))
		Error("DSound->SetCooperativeLevel()");
	Sys_memClear(&dsbdesc, sizeof(dsbdesc));
	dsbdesc.dwSize = sizeof(dsbdesc);
	dsbdesc.dwFlags = (DSBCAPS_PRIMARYBUFFER | DSBCAPS_CTRL3D);
	if (SoundData->DSound->CreateSoundBuffer(&dsbdesc, &SoundData->DSBPrimary, 0))
		Error("CreateSoundBuffer(Primary)");
	Sys_memClear(&wfx, sizeof(wfx));
	wfx.wFormatTag = WAVE_FORMAT_PCM;
	wfx.nChannels = 2;
	wfx.nSamplesPerSec = 44100;
	wfx.wBitsPerSample = 16;
	wfx.nBlockAlign = (wfx.wBitsPerSample >> 3) * wfx.nChannels;
	wfx.nAvgBytesPerSec = wfx.nSamplesPerSec * wfx.nBlockAlign;
	if (SoundData->DSBPrimary->SetFormat(&wfx))
		Error("DSBPrimary->SetFormat()");
	if (SoundData->DSBPrimary->QueryInterface(IID_IDirectSound3DListener, (void**)&SoundData->Listener))
		Error("QueryInterface(3dSound Listener");
	ds3dlistener.dwSize = sizeof(ds3dlistener);
	SoundData->Listener->GetAllParameters(&ds3dlistener);
	VectorClear((float*)&ds3dlistener.vPosition);
	VectorClear((float*)&ds3dlistener.vVelocity);
	ds3dlistener.flRolloffFactor = 0.01f;
	ds3dlistener.flDistanceFactor = 0.1f;
	ds3dlistener.flDopplerFactor = 1.0f;
	SoundData->Listener->SetAllParameters(&ds3dlistener, DS3D_DEFERRED);
}
void Sound_Load(char* Name, void* WavFormat, void* SamplesData, int DataSize)
{
	unsigned long i, AudioSize1, AudioSize2;
	void* pAudio1, *pAudio2;
	DS3DBUFFER ds3dbufferDesc;
	Sound_t* Sound = &SoundData->Sounds[0];
	WAVEFORMATEX* wfx = (WAVEFORMATEX*)WavFormat;
	DSBUFFERDESC dsbdesc;
	if (!SoundData->DoSound)
		return;
	for (i=0; i<MAX_SOUNDS; i++, Sound++)
		if (!(Sound->Flags & SOUNDF_INUSE))
			break;
	if (i == MAX_SOUNDS)
		goto failure;
	Sound->Flags = SOUNDF_INUSE;
	Sound->NumInstances = 1;
	Sys_strcpy(Sound->Name, Name);
	Sys_memClear(&dsbdesc, sizeof(dsbdesc));
	dsbdesc.dwSize = sizeof(dsbdesc);
	dsbdesc.dwFlags = (DSBCAPS_CTRL3D|DSBCAPS_MUTE3DATMAXDISTANCE);
	dsbdesc.dwBufferBytes = DataSize;
	dsbdesc.lpwfxFormat = wfx;
	if (SoundData->DSound->CreateSoundBuffer(&dsbdesc, &Sound->Instances[0].Buffer, 0))
		goto failure;
	if (Sound->Instances[0].Buffer->QueryInterface(IID_IDirectSound3DBuffer, 
						(void**)&Sound->Instances[0].Buffer3D))
		goto failure;
	if (Sound->Instances[0].Buffer->Lock(0, 0, &pAudio1, &AudioSize1, &pAudio2, &AudioSize2, DSBLOCK_ENTIREBUFFER))
		goto failure;
	Sys_memCopy(pAudio1, SamplesData, AudioSize1);
	if (pAudio2)
		Sys_memCopy(pAudio2, ((char*)SamplesData)+AudioSize1, AudioSize2);
	if (Sound->Instances[0].Buffer->Unlock(pAudio1, AudioSize1, pAudio2, AudioSize2))
		goto failure;
	ds3dbufferDesc.dwSize = sizeof(ds3dbufferDesc);
	Sound->Instances[0].Buffer3D->GetAllParameters(&ds3dbufferDesc);
	ds3dbufferDesc.dwMode = DS3DMODE_NORMAL;
	ds3dbufferDesc.flMinDistance = 0.0f;
//	ds3dbufferDesc.flMaxDistance = 1000000.0f;
	Sound->Instances[0].Buffer3D->SetAllParameters(&ds3dbufferDesc, DS3D_DEFERRED);
	return;
	failure:
	{
		Error("Sound_Load(%s)", Name);
	}
}
void Sound_Release()
{
	if (!SoundData)
		return;
	if (SoundData->DSound)
		SoundData->DSound->Release();
	Sys_logPrintf("max playing buffers : %i", SoundData->MaxPlayingBuffers);
}
Sound_t* Sound_Get(char* Name)
{
	Sound_t* Sound = &SoundData->Sounds[0];
	for (int i=0; i<MAX_SOUNDS; i++, Sound++)
		if (Sys_strcmp(Sound->Name, Name))
			break;
	if (i == MAX_SOUNDS)
		Error("Sound_Get(%s)", Name);
	return Sound;
}
void Sound_Play(char* Name, Vector3 Position, Vector3 Velocity, int* Instance, int Flags)
{
	int i;
	if (!SoundData->DoSound)
		return;
	Sound_t* Sound = Sound_Get(Name);
	SoundInstance_t* SoundInstance = &Sound->Instances[0];
	for (i=0; i<MAX_SOUND_INSTANCES; i++, SoundInstance++)
		if (!(SoundInstance->Flags & SOUNDINSTANCEF_PLAYING))
			break;
	if (i == MAX_SOUND_INSTANCES)
		Error("Plus de %i instances de %s", MAX_SOUND_INSTANCES, Name);
	if (Instance)
		*Instance = i;
	if (!SoundInstance->Buffer)
		Sound->NumInstances++;
	SoundInstance->Flags = (SOUNDINSTANCEF_WANTTOPLAY | SOUNDINSTANCEF_PLAYING);
	if (Flags & SOUND_3D)
	{
		SoundInstance->Flags |= SOUNDINSTANCEF_3D;
		VectorClear(SoundInstance->Position);
		VectorClear(SoundInstance->Velocity);
		if (Position)
			VectorCopy(SoundInstance->Position, Position);
		if (Velocity)
			VectorCopy(SoundInstance->Velocity, Velocity);
	}
	if (Flags & SOUND_LOOPED)
		SoundInstance->Flags |= SOUNDINSTANCEF_LOOPED;
}
void Sound_Stop(char* Name, int Instance)
{
	if (!SoundData->DoSound)
		return;
	Sound_t* Sound = Sound_Get(Name);
	SoundInstance_t* SoundInstance = &Sound->Instances[0];
	for (int i=0; i<Instance; i++)
		SoundInstance++;
	SoundInstance->Flags |= SOUNDINSTANCEF_WANTTOSTOP;
}
void Sound_UpdateAll(Vector3 MoveAll)
{
	int i, j;
	unsigned long Status;
	Sound_t* Sound;
	SoundInstance_t* SoundInstance;
	if (!SoundData->DoSound)
		return;
	Sound = &SoundData->Sounds[0];
	for (i=0; i<MAX_SOUNDS; i++, Sound++)
	{
		if (!(Sound->Flags & SOUNDF_INUSE))
			continue;
		SoundInstance = &Sound->Instances[0];
		for (j=0; j<Sound->NumInstances; j++, SoundInstance++)
		{
			if (!(SoundInstance->Flags & SOUNDINSTANCEF_PLAYING))
				continue;
			if (!SoundInstance->Buffer)
			{
				if (SoundData->DSound->DuplicateSoundBuffer(Sound->Instances[0].Buffer,
															&SoundInstance->Buffer))
					Error("DuplicateSoundBuffer(%s)", Sound->Name);	
				if (SoundInstance->Buffer->QueryInterface(IID_IDirectSound3DBuffer, 
						(void**)&SoundInstance->Buffer3D))
					Error("QueryInterface(buffer3d), %s", Sound->Name);
			}
			if (SoundInstance->Flags & SOUNDINSTANCEF_3D)
			{
				VectorAdd2(SoundInstance->Position, MoveAll);
				SoundInstance->Buffer3D->SetPosition(SoundInstance->Position[0],
													SoundInstance->Position[1],		
													SoundInstance->Position[2],
													DS3D_DEFERRED);
				SoundInstance->Buffer3D->SetVelocity(SoundInstance->Velocity[0],
													SoundInstance->Velocity[1],
													SoundInstance->Velocity[2],
													DS3D_DEFERRED);
			}
			if (SoundInstance->Flags & SOUNDINSTANCEF_WANTTOSTOP)
			{
				SoundInstance->Flags &= ~(SOUNDINSTANCEF_WANTTOSTOP | SOUNDINSTANCEF_PLAYING);
				SoundInstance->Buffer->Stop();
				SoundData->NumPlayingBuffers--;
			}
			else if (SoundInstance->Flags & SOUNDINSTANCEF_WANTTOPLAY)
			{
				SoundInstance->Flags &= ~(SOUNDINSTANCEF_WANTTOPLAY);
				SoundInstance->Buffer3D->SetMode(
					(SoundInstance->Flags & SOUNDINSTANCEF_3D)?DS3DMODE_NORMAL:DS3DMODE_DISABLE,
					DS3D_DEFERRED);
				SoundInstance->Buffer->Play(0, 0, 
						(SoundInstance->Flags & SOUNDINSTANCEF_LOOPED)?DSBPLAY_LOOPING:0);
				SoundData->NumPlayingBuffers++;
				if (SoundData->NumPlayingBuffers > SoundData->MaxPlayingBuffers)
					SoundData->MaxPlayingBuffers = SoundData->NumPlayingBuffers;
			}
			else 
			{
				SoundInstance->Buffer->GetStatus(&Status);
				if (!(Status & DSBSTATUS_PLAYING))
				{
					SoundInstance->Flags &= ~(SOUNDINSTANCEF_PLAYING);
					SoundData->NumPlayingBuffers--;
				}
			}				
		}
	}
	SoundData->Listener->CommitDeferredSettings();
}
