////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "game.hpp"
ItemType_t ItemTypes[MAX_ITEM_TYPES] = {
{"Wall Destroyer", DIK_1, 1},
{"Invulnerability", DIK_2, 10},
{"Invulnerability", DIK_3, 10},
{"Invulnerability", DIK_4, 10},
{"Invulnerability", DIK_5, 10},
{"Invulnerability", DIK_6, 10},
{"Invulnerability", DIK_7, 10},
{"Invulnerability", DIK_8, 10},
{"Invulnerability", DIK_9, 10},
{"Invulnerability", DIK_0, 10}
};

#define SHOPF_INUSE 1
#define SHOPF_DRAW 2
#define SHOPF_HIGHLIGHT_INCREASING 4

static const float HIGHLIGHT_MOVE_DEBOUNCE_TIME = 0.1f;
static const float HIGHLIGHT_SPEED_FACTOR = 2.0f;

void Shop_Update()
{
	Shop_t* Shop = &gs->Shop;
	if (Keyboard[DIK_S])
		Shop_Begin();
	if (!(Shop->Flags & SHOPF_INUSE))
		return;
	for (int i=0; i<MAX_BLOCKWALLS; i++)
		if (gs->BlockWalls[i].Z > 0.0f)
			return;
	Shop->Flags |= SHOPF_DRAW;
	gs->Flags |= (GAMEF_NOCREATELASERS | GAMEF_NODRAWSCORE);
	if ((gs->Fps.GameTime - Shop->LastHighlightMoveTime) > HIGHLIGHT_MOVE_DEBOUNCE_TIME)
	{
		Shop->LastHighlightMoveTime = gs->Fps.GameTime;
		if (Keyboard[DIK_UP])
		{
			Shop->HighlightedIndex--;
			Sound_Play("1.WAV", 0, 0, 0, 0);
		}
		else if (Keyboard[DIK_DOWN])
		{
			Shop->HighlightedIndex++;
			Sound_Play("1.WAV", 0, 0, 0, 0);
		}
		else if ((Shop->HighlightedIndex == MAX_ITEM_TYPES)
				&& (Keyboard[DIK_RETURN]))
			Shop_End();	
		else if (Keyboard[DIK_RETURN])
			Player_AddItem(Shop->HighlightedIndex);
		else
			Shop->LastHighlightMoveTime = 0.0f;
	}
	if (Shop->HighlightedIndex < 0)
		Shop->HighlightedIndex = MAX_ITEM_TYPES;
	if (Shop->HighlightedIndex > MAX_ITEM_TYPES)
		Shop->HighlightedIndex = 0;
	if (Shop->Flags & SHOPF_HIGHLIGHT_INCREASING)
	{
		Shop->HighlightIntensity += (HIGHLIGHT_SPEED_FACTOR * gs->Fps.FrameTime);
		if (Shop->HighlightIntensity > 1.0f)
		{
			Shop->HighlightIntensity = 1.0f;
			Shop->Flags &= ~SHOPF_HIGHLIGHT_INCREASING;
		}
	}
	else
	{
		Shop->HighlightIntensity -= (HIGHLIGHT_SPEED_FACTOR * gs->Fps.FrameTime);
		if (Shop->HighlightIntensity < 0.0f)
		{
			Shop->HighlightIntensity = 0.0f;
			Shop->Flags |= SHOPF_HIGHLIGHT_INCREASING;
		}
	}	
}

static const float DELTAY = 0.7f / (MAX_ITEM_TYPES+1);

void Shop_DrawHighlight()
{
	Shop_t* Shop = &gs->Shop;
	Sprite_t Sprite;
	Sprite.SrcBlend = D3DBLEND_SRCALPHA;
	Sprite.DestBlend = D3DBLEND_INVSRCALPHA;
	Sprite.Texture = "White.gif";
	Sprite.Color = 0xff0000 | (((unsigned char)(Shop->HighlightIntensity * 255.0f)) << 0x18);
	Sprite.x0 = 0.0f;
	Sprite.x1 = 1.0f;
	Sprite.y0 = 0.3f + (0.7f * ((float)Shop->HighlightedIndex) / (MAX_ITEM_TYPES+1));
	Sprite.y1 = Sprite.y0 + DELTAY;
	Sprite.Flags = (SPRITEF_INITRENDERSTATE
					| SPRITEF_RESETRENDERSTATE
					| SPRITEF_DRAW
					| SPRITEF_2D
					| SPRITEF_SETDEFAULTUV
					| SPRITEF_SETXY
					| SPRITEF_SETCOLOR
					| SPRITEF_SETDEFAULTZW
					| SPRITEF_SETTEXTURE);
	Sprite_Draw(&Sprite);
}
void Shop_Draw()
{
	Shop_t* Shop = &gs->Shop;
	if (!(Shop->Flags & SHOPF_DRAW))
		return;
	Player_t* Player = &gs->Player;
	Text_printf(0.2f, 0.0f, 0.8f, 0.1f, "Credits available : $%i", Player->Score);
	Text_printf(0.0f, 0.12f, 1.0f, 0.2f, "Press Enter To Buy");
	Text_printf(0.1f, 0.22f, 0.3f, 0.28f, "Item");
	Text_printf(0.47f, 0.22f, 0.55f, 0.28f, "Key");
	Text_printf(0.6f, 0.22f, 0.7f, 0.28f, "Cost");
	Text_printf(0.8f, 0.22f, 1.0f, 0.28f, "You have:");
	Shop_DrawHighlight();
	float  y0, y1; 
	ItemType_t* ItemType = &ItemTypes[0];
	y0 = 0.3f;
	for (int i=0; i<MAX_ITEM_TYPES; i++)
	{
		y1 = y0 + DELTAY;
		Text_printf(0.0f, y0, 0.48f, y1, ItemType->Name);
		Text_printf(0.5f, y0, 0.55f, y1, "(%s)", Input_GetKeyName(ItemType->Key));
		Text_printf(0.6f, y0, 0.8f, y1, "$%i", ItemType->Cost);
		Text_printf(0.9f, y0, 1.0f, y1, "x%i", Player->ItemCounts[i]);
		y0 = y1;
		ItemType++;
	}
	y1 = y0 + DELTAY;
	Text_printf(0.0f, y0, 1.0f, y1, "$$$ Quit the Shop $$$");
}
void Shop_Begin()
{
	Shop_t* Shop = &gs->Shop;
	if (Shop->Flags & SHOPF_INUSE)
		return;
	Shop->Flags |= SHOPF_INUSE;
	gs->Flags |= GAMEF_NOCREATEBLOCKWALLS;
}
void Shop_End()
{
	Shop_t* Shop = &gs->Shop;
	if (!(Shop->Flags & SHOPF_INUSE))
		return;
	Shop->Flags &= ~(SHOPF_INUSE | SHOPF_DRAW);
	gs->Flags &= ~(GAMEF_NOCREATEBLOCKWALLS | GAMEF_NOCREATELASERS | GAMEF_NODRAWSCORE);
	Sound_Play("MENUSEL.WAV", 0, 0, 0, 0);
	BlockWalls_InitAll();
}
