////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "game.hpp"

void ScreenBlend_Update()
{
	ScreenBlend_t* SBlend = &gs->ScreenBlend;
	int i;
	float* Argb, *NewArgb;
	Argb = &SBlend->Argb[0];
	NewArgb = &SBlend->NewArgb[0];
	for (i=0; i<4; i++)
	{
		if (*Argb < *NewArgb)
			*Argb += 6.0f * gs->Fps.FrameTime;
		else if (*Argb > *NewArgb)
			*Argb -= 0.6f * gs->Fps.FrameTime;
		if (*Argb < 0.0f)
			*Argb = 0.0f;
		else if (*Argb > 1.0f)
			*Argb = 1.0f;
		Argb++;
		NewArgb++;
	}
	NewArgb = &SBlend->NewArgb[0];
	for (i=0; i<4; i++)
	{
		*NewArgb-= 0.5f * gs->Fps.FrameTime;
		if (*NewArgb < 0.0f)
			*NewArgb = 0.0f;
		NewArgb++;
	}
}
void ScreenBlend_Draw()
{
	ScreenBlend_t* SBlend = &gs->ScreenBlend;
	Sprite_t Sprite;
	Sprite.Color = MAKE_RGBA(SBlend->Argb[1], SBlend->Argb[2], SBlend->Argb[3], SBlend->Argb[0]);
	if (!Sprite.Color)
		return;
	Sprite.Texture = "White.gif";
	Sprite.SrcBlend = D3DBLEND_SRCALPHA;
	Sprite.DestBlend = D3DBLEND_INVSRCALPHA;
	Sprite.Flags = (SPRITEF_INITRENDERSTATE
					| SPRITEF_RESETRENDERSTATE
					| SPRITEF_SETDEFAULTUV
					| SPRITEF_SETDEFAULTZW
					| SPRITEF_SETXY
					| SPRITEF_SETTEXTURE
					| SPRITEF_SETCOLOR
					| SPRITEF_DRAW
					| SPRITEF_2D);
	Sprite.x0 = 0.0f;
	Sprite.y0 = 0.0f;
	Sprite.x1 = 1.0f;
	Sprite.y1 = 1.0f;
	Sprite_Draw(&Sprite);
}
void ScreenBlend_Add(float a, float r, float g, float b)
{
	ScreenBlend_t* SBlend = &gs->ScreenBlend;
	SBlend->NewArgb[0] = a;
	SBlend->NewArgb[1] = r;
	SBlend->NewArgb[2] = g;
	SBlend->NewArgb[3] = b;
}
