////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "game.hpp"
#define RICOCHETF_INUSE 1
void Ricochet_Release(Ricochet_t* Ricochet)
{
	Sys_memClear(Ricochet, sizeof(*Ricochet));
}
void Ricochets_UpdateAll()
{
	Ricochet_t* Ricochet = gs->Ricochets;
	Vector3 DeltaPosition, Gravity;
	float Friction = 0.99f ;//* gs->Fps.FrameTime;
	VectorSet(Gravity, 0.0f, -100.0f*gs->Fps.FrameTime, 0.0f);
	for (int i=0; i<MAX_RICOCHETS; i++, Ricochet++)
	{
		if (!(Ricochet->Flags & RICOCHETF_INUSE))
			continue;
		VectorAdd2(Ricochet->Velocity, Gravity);
		VectorScale2(Ricochet->Velocity, Friction);
		VectorScale(DeltaPosition, Ricochet->Velocity, gs->Fps.FrameTime);
		DeltaPosition[2] -= (gs->Speed * gs->Fps.FrameTime);
		VectorAdd2(Ricochet->Position, DeltaPosition);	
		if (((gs->Fps.GameTime - Ricochet->StartTime) > 5.0f)
			|| (Ricochet->Position[2] < 0.0f))
			Ricochet_Release(Ricochet);
	}
}
void Ricochets_DrawAll()
{
	Ricochet_t* Ricochet = gs->Ricochets;
	Vector3 Position2;
	LVERTEX Vertices3d[2];
	D3D_SetTransform(D3DTRANSFORMSTATE_WORLD, (float*)MatrixIdentity);
	D3D_SetTexture(0, Texture_Get("White.gif"));
	for (int i=0; i<MAX_RICOCHETS; i++, Ricochet++)
	{
		if (!(Ricochet->Flags & RICOCHETF_INUSE))
			continue;
		VectorScale(Position2, Ricochet->Velocity, 10.0F * gs->Fps.FrameTime);
		VectorAdd2(Position2, Ricochet->Position);
		LVERTEX_Set(&Vertices3d[0], Ricochet->Position[0], 
											Ricochet->Position[1],
											Ricochet->Position[2],
											Ricochet->StartColor,
											0.0f, 0.0f);
		LVERTEX_Set(&Vertices3d[1], Position2[0],
											Position2[1],
											Position2[2],
											Ricochet->EndColor,
											1.0f, 1.0f);
		D3D_DrawPrimitive(D3DPT_LINELIST, D3DFVF_LVERTEX, Vertices3d, 2, 0);
	}
}
void Ricochet_Create(Vector3 Position)
{
	Ricochet_t* Ricochet = gs->Ricochets;
	int i, j;
	if (Position[2] > 300.0f)
		return;
	for (i=j=0; i<10; i++)
	{
		for ( ; j<MAX_RICOCHETS; j++, Ricochet++)
			if (!(Ricochet->Flags & RICOCHETF_INUSE))
				break;
		if (j == MAX_RICOCHETS)
			Error("Ricochet_Create()");
		Ricochet->Flags |= RICOCHETF_INUSE; 
		VectorCopy(Ricochet->Position, Position);
		for (int k=0; k<2; k++)
		{
			Ricochet->Velocity[k] = 30.0f + 30.0f * M_Rand();
			if (M_Rand() > 0.5f)
				Ricochet->Velocity[k] =- Ricochet->Velocity[k];
		}
		Ricochet->Velocity[2] = -0.5f - M_Rand();
		Ricochet->StartTime = gs->Fps.GameTime;
		Ricochet->StartColor = 0xffffffff;
		Ricochet->EndColor = 0xff0000ff;
	}
}