#include "game.hpp"
#define PROXIMITYBOMBF_INUSE 1
#define PROXIMITYBOMBF_ADVANCING 2
void ProximityBomb_Release(ProximityBomb_t* ProxBomb)
{
	Sys_memClear(ProxBomb, sizeof(*ProxBomb));
}
ProximityBomb_t* ProximityBombs_CheckCollision(Vector3 Position)
{
	int i;
	Vector3 Mins, Maxs;
	ProximityBomb_t* ProxBomb = gs->ProximityBombs;
	for (i=0; i<MAX_PROXIMITY_BOMBS; i++, ProxBomb++)
	{
		if (!(ProxBomb->Flags & PROXIMITYBOMBF_INUSE))
			continue;
		Mesh_GetBBox(Mesh_Get(ProxBomb->Mesh), Mins, Maxs, 
					 ProxBomb->Matrix, 0, 0, ProxBomb->Scaling);
		if (W_CollidePoint2BBox(Position, Mins, Maxs))
			return ProxBomb;
	}
	return 0;
}
void ProximityBombs_UpdateAll()
{
	ProximityBomb_t* ProxBomb = gs->ProximityBombs;
	int i;
	Matrix4x3 Mat;
	Vector3 v;
	for (i=0; i<MAX_PROXIMITY_BOMBS; i++, ProxBomb++)
	{
		if (!(ProxBomb->Flags & PROXIMITYBOMBF_INUSE))
			continue;
		VectorScale(v, ProxBomb->AngularVelocity, gs->Fps.FrameTime);
		Matrix_Set(Mat, 0, v, 0);
		Matrix_MultiplyRotations(ProxBomb->Matrix, Mat, ProxBomb->Matrix);
		ProxBomb->Matrix[3][2] -= (gs->Speed * gs->Fps.FrameTime);
		float DeltaZ = (ProxBomb->ZSpeed * gs->Fps.FrameTime);
		if (ProxBomb->Flags & PROXIMITYBOMBF_ADVANCING)
			ProxBomb->Matrix[3][2] -= DeltaZ;
		else
			ProxBomb->Matrix[3][2] += DeltaZ;
		ProxBomb->ZTravelled += DeltaZ;
		if (ProxBomb->ZTravelled > ProxBomb->ZMaxTravelled)
		{
			ProxBomb->ZTravelled = 0.0f;
			ProxBomb->Flags ^= PROXIMITYBOMBF_ADVANCING;
		}
		if (ProxBomb->Matrix[3][2] < -10.0f)
		{	
			ProximityBomb_Release(ProxBomb);
			continue;
		}
		Light_Add(ProxBomb->Matrix[3], 0xff0000ff);
	}
}
void ProximityBombs_DrawAll()
{
	ProximityBomb_t* ProxBomb = gs->ProximityBombs;
	int i;
	for (i=0; i<MAX_PROXIMITY_BOMBS; i++, ProxBomb++)
	{
		if (!(ProxBomb->Flags & PROXIMITYBOMBF_INUSE))
			continue;
		Mesh_Draw(Mesh_Get(ProxBomb->Mesh), ProxBomb->Matrix, ProxBomb->Scaling);
	}
}
ProximityBomb_t* ProximityBomb_Create()
{
	ProximityBomb_t* ProxBomb = gs->ProximityBombs;
	int i;
	for (i=0; i<MAX_PROXIMITY_BOMBS; i++)
		if (!(ProxBomb->Flags & PROXIMITYBOMBF_INUSE))
			break;
		else
			ProxBomb++;
	if (i == MAX_PROXIMITY_BOMBS)
		Error("ProximityBomb_Create()");
	ProxBomb->Flags = PROXIMITYBOMBF_INUSE;
	Matrix_SetIdentity(ProxBomb->Matrix);
	ProxBomb->Mesh =  "ProximityBomb01.OBJ";
	VectorSet(ProxBomb->Scaling, 1.0f, 1.0f, 1.0f);
	VectorClear(ProxBomb->AngularVelocity);
	if (M_Rand() > 0.5f)
		ProxBomb->Flags |= PROXIMITYBOMBF_ADVANCING;
	ProxBomb->ZSpeed = 80.0f + (20.0f * M_Rand());
	ProxBomb->ZMaxTravelled = 40.0f + (20.0f * M_Rand());
	return ProxBomb;
}
