////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "game.hpp"
#define PLAYERF_COLLIDEWALL 1
#define PLAYERF_ISINVULNERABLE 2
#define PLAYERF_DESTROYINGBLOCKWALL 4

void Player_DestroyBlockWall()
{
	Player_t* Player = &gs->Player;
	BlockWall_t* BlockWall = gs->BlockWalls;
	for (int i=0; i<MAX_BLOCKWALLS; i++, BlockWall++)
		if (!BlockWall_IsBlank(BlockWall))
			break;
	if (i < MAX_BLOCKWALLS)
		if (((BlockWall->Z < 290.0f)
			&& (M_Rand() < 0.01f))
			|| (BlockWall->Z < 100.0f))
			BlockWall_Explode(BlockWall);
	if ((gs->Fps.GameTime - Player->ItemLastTimeUsed[ITEM_WALL_DESTROYER]) > 4.0f)
	{
		Sound_Stop("ELECBOLT.WAV", 0);
		Player->Flags &= ~PLAYERF_DESTROYINGBLOCKWALL;
	}
	else
	{
		Vector3 StartPosition, EndPosition;
		VectorCopy(StartPosition, Player->Position);
		StartPosition[1] -= 10.0f;
		VectorScale(EndPosition, gs->Camera[2], 200.0f);
		VectorAdd2(EndPosition, Player->Position);
		EndPosition[1] += 30.0f;
		ThunderBolt_Add(StartPosition, EndPosition);
	}
}
void Player_BeginDestroyBlockWall()
{
	Player_t* Player = &gs->Player;
	if (!Player->ItemCounts[ITEM_WALL_DESTROYER])
		return;
	if (Player->Flags & PLAYERF_DESTROYINGBLOCKWALL)
		return;
	Sound_Play("ELECTRO.WAV", 0, 0, 0, 0);
	Sound_Play("ELECBOLT.WAV", 0, 0, 0, SOUND_LOOPED);
	Player->ItemLastTimeUsed[ITEM_WALL_DESTROYER] = gs->Fps.GameTime;
	Player->ItemCounts[ITEM_WALL_DESTROYER]--;
	Player->Flags |= PLAYERF_DESTROYINGBLOCKWALL;
}
void Player_BeginInvulnerability()
{
	Player_t* Player = &gs->Player;
	if (Player->Flags & PLAYERF_ISINVULNERABLE)
		return;
	if (!Player->ItemCounts[ITEM_INVULNERABILITY])
		return;
	Player->Flags |= PLAYERF_ISINVULNERABLE;
	Player->ItemLastTimeUsed[ITEM_INVULNERABILITY] = gs->Fps.GameTime;
	Player->ItemCounts[ITEM_INVULNERABILITY]--;
}
void Player_AddItem(int ItemNumber)
{
	Player_t* Player = &gs->Player;
	ItemType_t* ItemType = &ItemTypes[ItemNumber];
	if (Player->Score < ItemType->Cost)
	{
		Sound_Play("ChatAction.wav", 0, 0, 0, 0);
		return ;
	}
	Sound_Play("MENUSEL.WAV", 0, 0, 0, 0);
	Player->Score -= ItemType->Cost;
	Player->ItemCounts[ItemNumber]++;
}
void Player_AddToScore(int DeltaScore)
{
	Player_t* Player = &gs->Player;
	Player->Score += DeltaScore;
}
void Player_Update()
{
	Player_t* Player = &gs->Player;
	ProximityBomb_t* ProxBomb;
	PowerUp_t* PowerUp;
	Vector3 Thrust;
	int CollideWall;
	VectorClear(Thrust);
	if (Keyboard[DIK_LEFT])
		Thrust[0] = -50.0f;
	if (Keyboard[DIK_RIGHT])
		Thrust[0] = 50.0f;
	if (Keyboard[DIK_DOWN])
		Thrust[1] = -50.0f;
	if (Keyboard[DIK_UP])
		Thrust[1] = 50.0f;
	VectorScale2(Thrust, gs->Fps.FrameTime);
	VectorAdd2(Player->Position, Thrust);
	Tunnel_ClipPosition(Player->Position);
	if ((Keyboard[DIK_LCONTROL])
		&& ((gs->Fps.GameTime - Player->LastLaserFireTime) > 0.2f)
		&& (!(gs->Flags & GAMEF_NOCREATELASERS)))
	{
		Sound_Play("bfire.wav", 0, 0, 0, 0);
		Player->LastLaserFireTime = gs->Fps.GameTime;
		Laser_t* Laser = Laser_Create();
		VectorCopy(Laser->Position, Player->Position);
		VectorSet(Laser->Velocity, 0.0f, 0.0f, 300.0f);
		Laser->Width = 10.0f;
		Laser->Height = 10.0f;
	}
	if ((BlockWalls_CheckCollision(Player->Position))
		&& (!(Player->Flags & PLAYERF_ISINVULNERABLE)))
	{
		ScreenBlend_Add(0.6f, 1.0f, 0.0f, 0.0f);
		CollideWall = true;
	}
	else
		CollideWall = false;
	if ((CollideWall) & (!(Player->Flags & PLAYERF_COLLIDEWALL)))
	{
		Player->Flags |= PLAYERF_COLLIDEWALL;
		Player_AddToScore(-20);
		Sound_Play("SCRAPE.WAV", 0, 0, 0, SOUND_LOOPED);
	}
	else if ((!CollideWall) & (Player->Flags & PLAYERF_COLLIDEWALL))
	{
		Player->Flags &= ~PLAYERF_COLLIDEWALL;
		Sound_Stop("SCRAPE.WAV", 0);
	}
	if ((ProxBomb = ProximityBombs_CheckCollision(Player->Position))
		&& (!(Player->Flags & PLAYERF_ISINVULNERABLE)))
	{
		ScreenBlend_Add(0.6f, 1.0f, 0.3f, 0.3f);
		Player_AddToScore(-30);
		ProximityBomb_Release(ProxBomb);
		char* HurtSound;
		float Chance = M_Rand();
		if (Chance > 0.5f)
			HurtSound = "hurt1.wav";
		else HurtSound = "hurt2.wav";
		Sound_Play(HurtSound, 0, 0, 0, 0);
	}
	if (PowerUp = PowerUps_CheckCollision(Player->Position))
	{
		Player_AddToScore(+30);
		Sound_Play("3.WAV",0,0,0,0);
		PowerUp_Release(PowerUp);
	}
	if ((Player->Flags & PLAYERF_ISINVULNERABLE)
		&& ((gs->Fps.GameTime - Player->ItemLastTimeUsed[ITEM_INVULNERABILITY]) > 4.0f))
		Player->Flags &= ~PLAYERF_ISINVULNERABLE;
	if (Keyboard[ItemTypes[ITEM_WALL_DESTROYER].Key])
		Player_BeginDestroyBlockWall();
	if (Keyboard[ItemTypes[ITEM_INVULNERABILITY].Key])
		Player_BeginInvulnerability();
	if (Player->Flags & PLAYERF_DESTROYINGBLOCKWALL)
		Player_DestroyBlockWall();
}
void Player_DrawScore()
{
	Player_t* Player = &gs->Player;
	if (gs->Flags & GAMEF_NODRAWSCORE)
		return;
	Text_printf(0.0f, 0.1f, 0.2f, 0.2f, "%i", Player->Score);
}
void Player_Init()
{
	Player_t* Player = &gs->Player;
	VectorSet(Player->Position, 0, 0, 0);
	Player->Score = 100;
	Player->ItemCounts[ITEM_WALL_DESTROYER] = 100;
}
