////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "system.hpp"
#include "pak.hpp"

int AddSoundFile(int hOutputFile, char* szSrcFile)
{
	int SrcSize, BlockType, BlockLength;
	SoundHeader_t SoundHeader;
	unsigned int * pSrcDw, *pSrcBase, *pAudioData;
	int IsFormatBlockOk, IsDataBlockOk;
	pSrcDw = pSrcBase = (unsigned int*)Sys_FileLoad(szSrcFile, &SrcSize);
	if (*(pSrcDw++) != MAKE_CODE('R', 'I', 'F', 'F'))
		goto Invalid;
	pSrcDw++;
	if (*(pSrcDw++) != MAKE_CODE('W', 'A', 'V', 'E'))
		goto Invalid;
	IsFormatBlockOk = IsDataBlockOk = false;
	while (!(IsFormatBlockOk & IsDataBlockOk))
	{
		BlockType = *(pSrcDw++);
		BlockLength = *(pSrcDw++);
		switch (BlockType)
		{
			case MAKE_CODE('f', 'm', 't', ' '):
				IsFormatBlockOk = true;
				Sys_memCopy(&SoundHeader.wFormatTag, pSrcDw, 18);
				break;
			case MAKE_CODE('d', 'a', 't', 'a'):
				IsDataBlockOk = true;
				SoundHeader.DataSize = BlockLength;
				pAudioData = pSrcDw;
				break;
		}
		pSrcDw = (unsigned int*)((char*)pSrcDw + ((BlockLength+1)&~1));
	}
	SoundHeader.Signature = WAV_SIGNATURE;
	Sys_FileWrite(szSrcFile, hOutputFile, &SoundHeader, sizeof(SoundHeader));
	Sys_FileWrite(szSrcFile, hOutputFile, pAudioData, SoundHeader.DataSize);
	Sys_MemFree(pSrcBase);
	return (sizeof(SoundHeader) + SoundHeader.DataSize);
	Invalid:
	{
		Error("%s n'est pas un *.WAV valide", szSrcFile);
		return 0;
	}
}
