////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "system.hpp"
#include "pak.hpp"

void GIF_decode(char* lpDestBase, char* lpSrcBase)
{
	char* lpSrc, *lpDest, *lpStack;
	int codeSize, freeCode, maxCode, lastChar, lastCode, currCode;
	int numSrcBitsLeft, srcDword, numBlockLeft;
#define CODE_CLEAR	        0x100
#define CODE_EOI 	        0x101
#define MAX_CODE_SIZE       0xc
#define STACK_SIZE	  0x10000
typedef struct {
	int father;
	int character;
} AlphDecode_t;
	_asm {
	pushad
	call	WWinit
	WW1000:
	mov	[codeSize], 9
	mov	[maxCode], 0200h
	mov	[freeCode], (CODE_EOI + 1)
	call	WWgetCode
	cmp	eax, CODE_EOI
	je	WW9000
	cmp	eax, CODE_CLEAR
	je	WW1000
	mov	[lastChar], eax
	mov	[lastCode], eax
	call	WWsetChar
	WW2000:
	call	WWgetCode
	cmp	eax, CODE_EOI
	je	WW9000
	cmp	eax, CODE_CLEAR
	je	WW1000
	mov	[currCode], eax
	mov	edx, [lpStack]
	cmp	eax, [freeCode]
	jnb	WW8000
	WW3000:
	cmp	eax, CODE_EOI
	jb	WW4000
	mov	ecx, [ebx.character + eax * (size AlphDecode_t)]
	mov	eax, [ebx.father + eax * (size AlphDecode_t)]
	mov	[edx], cl
	inc	edx
	jmp	WW3000
	WW4000:
	dec	edx
	mov	ecx, [lpStack]
	mov	[lastChar], eax
	call	WWsetChar
	cmp	edx, ecx
	jb	WW5000
	WW4100:
	mov	al, [edx]
	dec	edx
	call	WWsetChar
	cmp	edx, ecx
	jnb	WW4100
	WW5000:
	mov	edx, [freeCode]
	mov	ecx, [maxCode]
	dec	ecx
	cmp	edx, ecx
	jnb	WW6000
	mov	eax, [lastCode]
	mov	ecx, [lastChar]
	mov	[ebx.father + edx * (size AlphDecode_t)], eax
	mov	[ebx.character + edx * (size AlphDecode_t)], ecx
	mov	eax, [currCode]
	inc	edx
	mov	[lastCode], eax
	mov	[freeCode], edx
	jmp	WW2000
	WW6000:
	cmp	[codeSize], MAX_CODE_SIZE
	je	WW2000
	inc	[codeSize]
	shl	[maxCode], 1
	jmp	WW5000
	WW8000:
	mov	eax, [lastChar]
	mov	[edx], al
	inc	edx
	mov	eax, [lastCode]
	jmp	WW3000
	WW9000:
	call	WWcleanUp
	jmp		WWfinish

	WWinit:
	mov	eax, [lpSrcBase]
	mov	[lpSrc], eax
	mov	eax, [lpDestBase]
	mov	[lpDest], eax
	push (((1 shl MAX_CODE_SIZE) * (size AlphDecode_t)) + STACK_SIZE)
	call	Sys_MemAlloc
//	add		esp, 4
	mov	[lpStack], eax
	lea	ebx, [eax + STACK_SIZE]
	xor	eax, eax
	mov	[numSrcBitsLeft], eax
	mov	[numBlockLeft], eax
	retn

	WWcleanUp:
	push	[lpStack]
	call	Sys_MemFree
//	add		esp, 4
	retn

	WWgetCode:
	push	ebx
	push	ecx
	push	edx
	push	esi
	push	edi
	xor	eax, eax
	mov	ebx, [codeSize]
	xor	ecx, ecx
	mov	edx, [numSrcBitsLeft]
	mov	esi, [srcDword]
	xor	edi, edi
	WW10000:
	dec	edx
	js	WW11000
	mov	[numSrcBitsLeft], edx
	mov	edx, esi
	shr	esi, 1
	and	edx, 1
	shl	edx, cl
	inc	ecx
	or	eax, edx
	mov	edx, [numSrcBitsLeft]
	dec	ebx
	jnz	WW10000
	mov	[srcDword], esi
	pop	edi
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	retn
	WW11000:
	push	eax
	push	ecx
	mov	esi, [lpSrc]
	mov	edx, [numBlockLeft]
	mov	ecx, 4
	WW11100:
	dec	edx
	js	WW12000
	mov	al, [esi]
	inc	esi
	ror	eax, 8
	dec	ecx
	jnz	WW11100
	mov	[numBlockLeft], edx
	mov	[lpSrc], esi
	mov	esi, eax
	pop	ecx
	pop	eax
	mov	edx, 020h
	jmp	WW10000
	WW12000:
	movzx	edx, byte ptr [esi]
	inc	esi
	jmp	WW11100
	WWsetChar:
	push	edx
	mov	edx, [lpDest]
	mov	[edx], al
	inc	edx
	mov	[lpDest], edx
	pop	edx
	retn
	WWfinish:
	popad
	}
}
char* GIF_load(BitmapHeader_t* pBmpHeader, char* szSrcFile)
{
	int inputFileSize, i;
	char* lpInputFile, *pSrc, *pDestPalette, *pDestImageData;
	char* pInputPalette = 0;
	pSrc = lpInputFile = (char*)Sys_FileLoad(szSrcFile,&inputFileSize);
	if ((!Sys_strncmp(pSrc,"GIF87a",6)) && (!Sys_strncmp(pSrc,"GIF89a",6)))
		Error("%s n'est pas un fichier *.GIF valide", szSrcFile);
	pSrc += 10;
	if ((*pSrc) & 0x80)
	{
		pSrc += 3;
		pInputPalette = pSrc;
		pSrc += (0x100 * 3 * sizeof(char));
	}
	else	
		pSrc += 3;
	while ((*(pSrc++)) == '!')
		pSrc += (*(++pSrc)) + 1;
	pSrc += 4;
	pBmpHeader->width = (*((int*)pSrc)) & 0xffff;
	pSrc += 2;
	pBmpHeader->height = (*((int*)pSrc)) & 0xffff;
	pSrc += 2;
	if ((*(pSrc++)) & 0x80)
	{
		pInputPalette = pSrc;
		pSrc += (0x100 * 3 * sizeof(char));
	}
	pSrc++;
	if (!pInputPalette)
		Error("%s 'nest pas un fichier *.GIF valide", szSrcFile);
	pDestPalette = (char*)pBmpHeader->palette;
	for (i=0; i<0x100; i++)
	{
		*(pDestPalette++) = *(pInputPalette++);
		*(pDestPalette++) = *(pInputPalette++);
		*(pDestPalette++) = *(pInputPalette++);
		*(pDestPalette++) = (char)0xff;
	}
	pDestImageData = (char*)Sys_HeapAllocTemp(pBmpHeader->width * pBmpHeader->height);
	GIF_decode(pDestImageData, pSrc);
	Sys_MemFree(lpInputFile);
	return pDestImageData;
}
unsigned char* PCX_decode(unsigned char* pDest, unsigned char* pSrc, int Size)
{
	while (Size > 0)
	{
		int InputByte = *(pSrc++);
		if (InputByte < 0xc0)
		{
			*(pDest++) = InputByte;
			Size--;
		}
		else
		{
			InputByte &= 0x3f;
			while (InputByte > 0)
			{
				*(pDest++) = *pSrc;
				InputByte--;
				Size--;
			}
			pSrc++;
		}
	}
	if (Size != 0)
		Error("Erreur de decodage RLE PCX");
	return pSrc;
}
char* PCX_load(BitmapHeader_t* pBmpHeader, char* szSrcFile)
{
	int inputFileSize;
	unsigned char* lpInputFile, *pSrc;
	pSrc = lpInputFile = (unsigned char*)Sys_FileLoad(szSrcFile,&inputFileSize);
	if (*pSrc != 0xa)
		Error("%s n'est pas un fichier PCX valide", szSrcFile);
	pSrc+= 2;
	int IsRLEcompressed = *(pSrc++);
	if (*pSrc != 8)
		Error("%s n'est pas un fichier PCX valide", szSrcFile);
	pSrc += 9;
	pBmpHeader->width = (*((int*)pSrc)) & 0xffff;
	pSrc += 2;
	pBmpHeader->height = (*((int*)pSrc)) & 0xffff;
	pSrc += 114;
	int BitmapSize = pBmpHeader->width * pBmpHeader->height;
	unsigned char* pDestImageData = (unsigned char*)Sys_HeapAllocTemp(BitmapSize);
	if (IsRLEcompressed)
		pSrc = PCX_decode(pDestImageData, pSrc, BitmapSize);
	else
	{
		Sys_memCopy(pDestImageData, pSrc, BitmapSize);
		pSrc += BitmapSize;
	}
	if (*(pSrc++) != 0xc)
		Error("%s n'est pas un fichier PCX valide", szSrcFile);
	unsigned char* pDestPalette = (unsigned char*)pBmpHeader->palette;
	for (int i=0; i<0x100; i++)
	{
		*(pDestPalette++) = *(pSrc++);
		*(pDestPalette++) = *(pSrc++);
		*(pDestPalette++) = *(pSrc++);
		*(pDestPalette++) = 0xff;
	}
	Sys_MemFree(lpInputFile);
	return (char*)pDestImageData;
}

int AddBitmapFile(int hOutputFile, char* szSrcFile)
{
	#define IMAGETYPE_GIF 0
	#define IMAGETYPE_PCX 1
	char* pDestImageData;
	int ImageType;
	int outputSize = sizeof(BitmapHeader_t);
	char* pFileExtension = &szSrcFile[Sys_strlen(szSrcFile)-3];
	Sys_StrToUpper(pFileExtension);
	if (Sys_strcmp(pFileExtension, "GIF"))
		ImageType = IMAGETYPE_GIF;
	else if (Sys_strcmp(pFileExtension, "PCX"))
		ImageType = IMAGETYPE_PCX;
	else
		Error("%s est dans 1 format non support", szSrcFile);
	BitmapHeader_t* pBmpHeader = (BitmapHeader_t*)Sys_HeapAllocTemp(sizeof(BitmapHeader_t));
	pBmpHeader->id = BMP_SIGNATURE;
	pBmpHeader->mipMapCount = 1;
	char* pMipMapName = (char*)Sys_HeapAllocTemp(0x100);
	switch (ImageType)
	{
		case IMAGETYPE_GIF:
			pDestImageData = GIF_load(pBmpHeader, szSrcFile);
			break;
		case IMAGETYPE_PCX:
			pDestImageData = PCX_load(pBmpHeader, szSrcFile);
			break;
	}
	Sys_strcpy(pMipMapName, szSrcFile);
	int size = Sys_strlen(pMipMapName);
	(*(int*)(pMipMapName + size - 2)) = (*(int*)(pMipMapName + size - 4));
	pMipMapName[size + 2] = 0;
	pMipMapName[size - 4] = '_';
	pMipMapName[size - 3] = '1';
	while (Sys_FileExists(pMipMapName))
	{
		pMipMapName[size - 3]++;
		pBmpHeader->mipMapCount++;
	}	
	char* pDestPalette;
	int length = Sys_strlen(szSrcFile);
	char* szPalName = (char*)Sys_HeapAllocTemp(length+1);
	Sys_strcpy(szPalName, szSrcFile);
	szPalName[length-3] = 'p';
	szPalName[length-2] = 'a';
	szPalName[length-1] = 'l';
	if (Sys_FileExists(szPalName))
	{
		Sys_logPrintf("  %s",szPalName);
		int palFileSize;
		char* pPalFileBase, *pPalFile;
		pPalFileBase = pPalFile = (char*)Sys_FileLoad(szPalName, &palFileSize);
		unsigned int* pPalFile32 = (unsigned int*) pPalFile;
		if ((*pPalFile32 != MAKE_CODE('R','I','F','F'))
			|| (*(pPalFile32+2) != MAKE_CODE('P','A','L',' '))
			|| (*(pPalFile32+3) != MAKE_CODE('d','a','t','a')))
			Error("%s n'est pas un fichier *.PAL valide", szPalName	);
		pPalFile += 0x18;
		pDestPalette = ((char*)pBmpHeader->palette) + 3;
		for (int i=0; i<0x100; i++)
		{
			*pDestPalette = (char)(((*(pPalFile++)) + (*(pPalFile++)) + (*(pPalFile++)))/3);
			pPalFile++;
			pDestPalette += 4;
		}
		Sys_MemFree(pPalFileBase);
	}	
	Sys_HeapFreeTemp(szPalName);
	Sys_FileWrite("", hOutputFile, pBmpHeader, sizeof(BitmapHeader_t));
	int i = 0;
	pMipMapName[size - 3] = '0';
	while (1) {
		Sys_logPrintf("     %d * %d",pBmpHeader->width,pBmpHeader->height);
		outputSize += pBmpHeader->width * pBmpHeader->height;
		Sys_FileWrite("", hOutputFile,pDestImageData,pBmpHeader->width * pBmpHeader->height);
		Sys_HeapFreeTemp(pDestImageData);
		pMipMapName[size - 3]++;
		if (!Sys_FileExists(pMipMapName))
			break;
		switch (ImageType)
		{
			case IMAGETYPE_GIF:
				pDestImageData = GIF_load(pBmpHeader, pMipMapName);
				break;
			case IMAGETYPE_PCX:
				pDestImageData = PCX_load(pBmpHeader, pMipMapName);
				break;
		}
	}	
	Sys_HeapFreeTemp(pBmpHeader);
	Sys_HeapFreeTemp(pMipMapName);
	return outputSize;
}
