////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "game.hpp"
void Lights_DrawAll()
{
	BlockWall_t* BlockWall;
	Tunnel_t* Tunnel = &gs->Tunnel;
	LVERTEX Mesh[4];
	float x0, x1, y0, y1, z0, z1, u0, u1, v0, v1, Size, BlockWidth, BlockHeight;
	int i, j, k, n, Color;
	D3D_SetTexture(0, Texture_Get("flare1.gif"));
	D3D_SetTransform(D3DTRANSFORMSTATE_WORLD, (float*)MatrixIdentity);
	D3D_SetRenderState(D3DRENDERSTATE_ZWRITEENABLE, false);
	D3D_SetTextureStageState(0, D3DTSS_ADDRESS, D3DTADDRESS_CLAMP);
	D3D_SetRenderState(D3DRENDERSTATE_ALPHABLENDENABLE, true);
	D3D_SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_ONE);
	D3D_SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_ONE);
	BlockWidth = (2.0f * Tunnel->Width / (float)BLOCKS_NUM_X);
	BlockHeight = (2.0f * Tunnel->Height / (float)BLOCKS_NUM_Y);
	Light_t* Light = gs->Lights;
	for (i=0; i<MAX_LIGHTS; i++, Light++)
	{
		if (!Light->Color)
			continue;
		D3D_SetRenderState(D3DRENDERSTATE_ZFUNC, D3DCMP_EQUAL);
		Color = Light->Color;
		/////////////////////////////////
		BlockWall = gs->BlockWalls;
		if (Light->Position[2] < (BlockWall[0].Z - BlockWall[0].Depth))
			;
		else if ((Light->Position[2] > (BlockWall[0].Z + BlockWall[0].Depth))
				&& (Light->Position[2] < (BlockWall[1].Z - BlockWall[1].Depth)))
			BlockWall = &BlockWall[1];
		else
			BlockWall = 0;
		Size = 0.0f;
		if (BlockWall)
		{
			Size = 120.0f * (1.0f - ((BlockWall->Z - Light->Position[2])/250.0f));
			x0 = Light->Position[0] - Size;
			x1 = Light->Position[0] + Size;
			y0 = Light->Position[1] + Size;
			y1 = Light->Position[1] - Size;
			z0 = BlockWall->Z - BlockWall->Depth;
			LVERTEX_Set(&Mesh[0], x0, y0, z0, Color, 0.0f, 0.0f);
			LVERTEX_Set(&Mesh[1], x0, y1, z0, Color, 0.0f, 1.0f);
			LVERTEX_Set(&Mesh[2], x1, y0, z0, Color, 1.0f, 0.0f);
			LVERTEX_Set(&Mesh[3], x1, y1, z0, Color, 1.0f, 1.0f);
			D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Mesh, 4, 0);	
		}
		/////////////////////////////////
		D3D_SetRenderState(D3DRENDERSTATE_ZFUNC, D3DCMP_LESSEQUAL);

		BlockWall = gs->BlockWalls;
		z0 = Light->Position[2];
		if (z0 < (BlockWall->Z - BlockWall->Depth - 30.0f))
			BlockWall = 0;
		else if (z0 < (BlockWall->Z + BlockWall->Depth + 30.0f))
			;
		else
		{
			BlockWall++;
			if ((z0 < (BlockWall->Z - BlockWall->Depth - 30.0f))
				|| (z0 > (BlockWall->Z + BlockWall->Depth + 30.0f)))
				BlockWall = 0;
		}

		if ((BlockWall) && (!BlockWall_IsBlank(BlockWall)))
		{
			BlockWall_XY_2_IJ(&j, &k, Light->Position[0], Light->Position[1]);
			x0 = (BlockWidth * (float)k) - Tunnel->Width;
			x1 = x0 + BlockWidth;
			y1 = Tunnel->Height - (BlockHeight * (float)j);
			y0 = y1 - BlockHeight;
			z0 = BlockWall->Z - BlockWall->Depth;
			z1 = BlockWall->Z + BlockWall->Depth;
		
			for (n=j; (n != 0) && (BlockWall->Structure[n-1][k] == 0); n--)
				y1 += BlockHeight;
			for (n=j; (n != (BLOCKS_NUM_Y-1)) && (BlockWall->Structure[n+1][k] == 0); n++)
				y0 -= BlockHeight;
			for (n=k; (n != 0) && (BlockWall->Structure[j][n-1] == 0); n--)
				x0 -= BlockWidth;
			for (n=k; (n != (BLOCKS_NUM_X-1)) && (BlockWall->Structure[j][n+1] == 0); n++)
				x1 += BlockWidth;
			
			x0 += 0.1f;
			x1 -= 0.1f;
			y1 -= 0.1f;
			y0 += 0.1f;

			v1 = 0.9f - 1.8f*((Light->Position[2] - z0) / (z1 - z0));
			v0 = v1 + 1.8f;
			u0 = 0.5f - ((Light->Position[0] - x0) / BlockWidth);
			u1 = u0 + 1.0f;
//			if ((j != 0) && (BlockWall->Structure[j-1][k] != 0))
			{
				LVERTEX_Set(&Mesh[0], x0, y1, z0, Color, u0, v1);
				LVERTEX_Set(&Mesh[1], x0, y1, z1, Color, u0, v0);
				LVERTEX_Set(&Mesh[2], x1, y1, z0, Color, u1, v1);
				LVERTEX_Set(&Mesh[3], x1, y1, z1, Color, u1, v0);
				D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Mesh, 4, 0);	
			}
//			if ((j != (BLOCKS_NUM_Y-1)) && (BlockWall->Structure[j+1][k] != 0))
			{
				LVERTEX_Set(&Mesh[0], x0, y0, z1, Color, u0, v0);
				LVERTEX_Set(&Mesh[1], x0, y0, z0, Color, u0, v1);
				LVERTEX_Set(&Mesh[2], x1, y0, z1, Color, u1, v0);
				LVERTEX_Set(&Mesh[3], x1, y0, z0, Color, u1, v1);
				D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Mesh, 4, 0);	
			}
			u1 = 0.5f - ((Light->Position[1] - y0) / BlockHeight);
			u0 = u1 + 1.0f;
//			if ((k != 0) && (BlockWall->Structure[j][k-1] != 0))
			{
				LVERTEX_Set(&Mesh[0], x0, y1, z1, Color, u0, v0);
				LVERTEX_Set(&Mesh[1], x0, y1, z0, Color, u0, v1);
				LVERTEX_Set(&Mesh[2], x0, y0, z1, Color, u1, v0);
				LVERTEX_Set(&Mesh[3], x0, y0, z0, Color, u1, v1);
				D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Mesh, 4, 0);
			}
//			if ((k != BLOCKS_NUM_X) && (BlockWall->Structure[j][k+1] != 0))
			{
				LVERTEX_Set(&Mesh[0], x1, y1, z0, Color, u0, v1);
				LVERTEX_Set(&Mesh[1], x1, y1, z1, Color, u0, v0);
				LVERTEX_Set(&Mesh[2], x1, y0, z0, Color, u1, v1);
				LVERTEX_Set(&Mesh[3], x1, y0, z1, Color, u1, v0);
				D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Mesh, 4, 0);
			}
		}
		else
		{
			Size = 50.0f;
	
			x0 = Light->Position[0] - Size;
			x1 = Light->Position[0] + Size;
			z0 = Light->Position[2] + Size;
			z1 = Light->Position[2] - Size;
			y0 = -Tunnel->Height + 0.1f;
			LVERTEX_Set(&Mesh[0], x0, y0, z0, Color, 0.0f, 0.0f);
			LVERTEX_Set(&Mesh[1], x0, y0, z1, Color, 0.0f, 1.0f);
			LVERTEX_Set(&Mesh[2], x1, y0, z0, Color, 1.0f, 0.0f);
			LVERTEX_Set(&Mesh[3], x1, y0, z1, Color, 1.0f, 1.0f);
			D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Mesh, 4, 0);	

			x0 = Light->Position[0] - Size;
			x1 = Light->Position[0] + Size;
			z0 = Light->Position[2] - Size;
			z1 = Light->Position[2] + Size;
			y1 = Tunnel->Height - 0.1f;
			LVERTEX_Set(&Mesh[0], x0, y1, z0, Color, 0.0f, 0.0f);
			LVERTEX_Set(&Mesh[1], x0, y1, z1, Color, 0.0f, 1.0f);
			LVERTEX_Set(&Mesh[2], x1, y1, z0, Color, 1.0f, 0.0f);
			LVERTEX_Set(&Mesh[3], x1, y1, z1, Color, 1.0f, 1.0f);
			D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Mesh, 4, 0);	

			y0 = Light->Position[1] - Size;
			y1 = Light->Position[1] + Size;
			z0 = Light->Position[2] - Size;
			z1 = Light->Position[2] + Size;
			x0 = -Tunnel->Width + 0.1f;
			LVERTEX_Set(&Mesh[0], x0, y0, z0, Color, 0.0f, 0.0f);
			LVERTEX_Set(&Mesh[1], x0, y0, z1, Color, 0.0f, 1.0f);
			LVERTEX_Set(&Mesh[2], x0, y1, z0, Color, 1.0f, 0.0f);
			LVERTEX_Set(&Mesh[3], x0, y1, z1, Color, 1.0f, 1.0f);
			D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Mesh, 4, 0);	

			y0 = Light->Position[1] + Size;
			y1 = Light->Position[1] - Size;
			z0 = Light->Position[2] - Size;
			z1 = Light->Position[2] + Size;
			x1 = Tunnel->Width - 0.1f;
			LVERTEX_Set(&Mesh[0], x1, y0, z0, Color, 0.0f, 0.0f);
			LVERTEX_Set(&Mesh[1], x1, y0, z1, Color, 0.0f, 1.0f);
			LVERTEX_Set(&Mesh[2], x1, y1, z0, Color, 1.0f, 0.0f);
			LVERTEX_Set(&Mesh[3], x1, y1, z1, Color, 1.0f, 1.0f);
			D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Mesh, 4, 0);	
		}
		/////////////////////////////////
	}
	D3D_SetRenderState(D3DRENDERSTATE_ALPHABLENDENABLE, false);
	D3D_SetTextureStageState(0, D3DTSS_ADDRESS, D3DTADDRESS_WRAP);
	D3D_SetRenderState(D3DRENDERSTATE_ZWRITEENABLE, true);
}
void Light_Add(Vector3 Position, int Color)
{
	Light_t* Light = gs->Lights;
	for (int i=0; i<MAX_LIGHTS; i++, Light++)
		if (!Light->Color)
			break;
	if (i == MAX_LIGHTS)
		Error("Light_Add()");
	VectorCopy(Light->Position, Position);
	Light->Color = Color;
}
void Lights_UpdateAll()
{
	Sys_memClear(gs->Lights, sizeof(gs->Lights[0])*MAX_LIGHTS);
}