////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "system.hpp"
#include "pak.hpp"

char* LZW_decode(char* szSrcFile)
{
	char* lpSrcBase, *lpSrc, *lpDestBase, *lpDest, *lpStack;
	int codeSize, freeCode, maxCode, lastChar, lastCode, currCode;
	int numSrcBitsLeft, srcDword ;
#define CODE_EOI      0x100
#define MAX_CODE_SIZE   0xc
#define STACK_SIZE	0x10000
typedef struct {
	int character;
	int father;
} AlphCode_t;
	_asm {
	pushad
	call	WWinit
	WW1000:
	mov	[codeSize], 9
	mov	[maxCode], 0200h
	mov	[freeCode], (CODE_EOI + 1)
	call	WWgetCode
	cmp	eax, CODE_EOI
	je	WW9000
	mov	[lastChar], eax
	mov	[lastCode], eax
	call	WWsetChar
	WW2000:
	call	WWgetCode
	cmp	eax, CODE_EOI
	je	WW9000
	mov	[currCode], eax
	mov	edx, [lpStack]
	cmp	eax, [freeCode]
	jnb	WW8000
	WW3000:
	cmp	eax, CODE_EOI
	jb	WW4000
	mov	ecx, [ebx.character + eax * (size AlphCode_t)]
	mov	eax, [ebx.father + eax * (size AlphCode_t)]
	mov	[edx], cl
	inc	edx
	jmp	WW3000
	WW4000:
	dec	edx
	mov	ecx, [lpStack]
	mov	[lastChar], eax
	call	WWsetChar
	cmp	edx, ecx
	jb	WW5000
	WW4100:
	mov	al, [edx]
	dec	edx
	call	WWsetChar
	cmp	edx, ecx
	jnb	WW4100
	WW5000:
	mov	edx, [freeCode]
	mov	ecx, [maxCode]
	dec	ecx
	cmp	edx, ecx
	jnb	WW6000
	mov	eax, [lastCode]
	mov	ecx, [lastChar]
	mov	[ebx.father + edx * (size AlphCode_t)], eax
	mov	[ebx.character + edx * (size AlphCode_t)], ecx
	mov	eax, [currCode]
	inc	edx
	mov	[lastCode], eax
	mov	[freeCode], edx
	jmp	WW2000
	WW6000:
	cmp	[codeSize], MAX_CODE_SIZE
	je	WW6500
	inc	[codeSize]
	shl	[maxCode], 1
	jmp	WW5000
	WW6500:
	call	WWgetCode
	call	WWsetChar
	jmp	WW1000
	WW8000:
	mov	eax, [lastChar]
	mov	[edx], al
	inc	edx
	mov	eax, [lastCode]
	jmp	WW3000

	WWinit:
	lea	eax, [lpSrcBase]
	push	eax
	push	[szSrcFile]
	call	Sys_FileLoad
//	add		esp, 8
	mov	[lpSrcBase], eax
	mov	edx, [eax]
	add	eax, 4
	mov	[lpSrc], eax
	push	edx
	call	Sys_MemAlloc
//	add		esp, 4
	mov	[lpDestBase], eax
	mov	[lpDest], eax
	push	(((1 shl MAX_CODE_SIZE) * (size AlphCode_t)) + STACK_SIZE)
	call	Sys_MemAlloc
//	add		esp, 4
	mov	[lpStack], eax
	lea	ebx, [eax + STACK_SIZE]
	and	[numSrcBitsLeft], 0
	retn
	
	WWcleanUp:
	push	[lpSrcBase]
	call	Sys_MemFree
//	add		esp, 4
	push	[lpStack]
	call	Sys_MemFree
//	add		esp, 4
	retn

	WWgetCode:
	push	ebx
	push	ecx
	push	edx
	push	esi
	push	edi
	xor	eax, eax
	mov	ebx, [codeSize]
	xor	ecx, ecx
	mov	edx, [numSrcBitsLeft]
	mov	esi, [srcDword]
	xor	edi, edi
	WW10000:
	dec	edx
	js	WW11000
	mov	[numSrcBitsLeft], edx
	mov	edx, esi
	shr	esi, 1
	and	edx, 1
	shl	edx, cl
	inc	ecx
	or	eax, edx
	mov	edx, [numSrcBitsLeft]
	dec	ebx
	jnz	WW10000
	mov	[srcDword], esi
	pop	edi
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	retn
	WW11000:
	mov	edx, [lpSrc]


	mov	esi, [edx]
	add	edx, 4
	mov	[lpSrc], edx
	mov	edx, 020h
	jmp	WW10000

	WWsetChar:
	push	edx
	mov	edx, [lpDest]
	mov	[edx], al
	inc	edx
	mov	[lpDest], edx
	pop	edx
	retn

	WW9000:
	call	WWcleanUp
	popad
	}
	return lpDestBase;	
}
