////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#define DINPUT_INCLUDED
#include <dinput.h>
#include "system.hpp"

IDirectInput*       pDInput   = NULL;
IDirectInputDevice* pKeyboard = NULL;
unsigned char		Keyboard[0x100];

char* Input_KeyNames[0x100] = {
0,
"Escape",//#define DIK_ESCAPE          0x01
"1",//#define DIK_1               0x02
"2",//#define DIK_2               0x03
"3",//#define DIK_3               0x04
"4",//#define DIK_4               0x05
"5",//#define DIK_5               0x06
"6",//#define DIK_6               0x07
"7",//#define DIK_7               0x08
"8",//#define DIK_8               0x09
"9",//#define DIK_9               0x0A
"0",//#define DIK_0               0x0B
"Minus",//#define DIK_MINUS           0x0C    /* - on main keyboard */
"Equals",//#define DIK_EQUALS          0x0D
"Backspace",//#define DIK_BACK            0x0E    /* backspace */
"Tab",//#define DIK_TAB             0x0F
"Q",//#define DIK_Q               0x10
"W",//#define DIK_W               0x11
"E",//#define DIK_E               0x12
"R",//#define DIK_R               0x13
"T",//#define DIK_T               0x14
"Y",//#define DIK_Y               0x15
"U",//#define DIK_U               0x16
"I",//#define DIK_I               0x17
"O",//#define DIK_O               0x18
"P",//#define DIK_P               0x19
"LBracket",//#define DIK_LBRACKET        0x1A
"RBracket",//#define DIK_RBRACKET        0x1B
"Enter",//#define DIK_RETURN          0x1C    /* Enter on main keyboard */
"LControl",//#define DIK_LCONTROL        0x1D
"A",//#define DIK_A               0x1E
"S",//#define DIK_S               0x1F
"D",//#define DIK_D               0x20
"F",//#define DIK_F               0x21
"G",//#define DIK_G               0x22
"H",//#define DIK_H               0x23
"J",//#define DIK_J               0x24
"K",//#define DIK_K               0x25
"L",//#define DIK_L               0x26
"SemiColon",//#define DIK_SEMICOLON       0x27
"Apostrophe",//#define DIK_APOSTROPHE      0x28
"Accent Grave",//#define DIK_GRAVE           0x29    /* accent grave */
"LShift",//#define DIK_LSHIFT          0x2A
"BackSlash",//#define DIK_BACKSLASH       0x2B
"Z",//#define DIK_Z               0x2C
"X",//#define DIK_X               0x2D
"C",//#define DIK_C               0x2E
"V",//#define DIK_V               0x2F
"B",//#define DIK_B               0x30
"N",//#define DIK_N               0x31
"M",//#define DIK_M               0x32
"Comma",//#define DIK_COMMA           0x33
"Period",//#define DIK_PERIOD          0x34    /* . on main keyboard */
"Slash",//#define DIK_SLASH           0x35    /* / on main keyboard */
"RShift",//#define DIK_RSHIFT          0x36
"Multiply",//#define DIK_MULTIPLY        0x37    /* * on numeric keypad */
"LMenu",//#define DIK_LMENU           0x38    /* left Alt */
"Space",//#define DIK_SPACE           0x39
"Capital",//#define DIK_CAPITAL         0x3A
"F1",//#define DIK_F1              0x3B
"F2",//#define DIK_F2              0x3C
"F3",//#define DIK_F3              0x3D
"F4",//#define DIK_F4              0x3E
"F5",//#define DIK_F5              0x3F
"F6",//#define DIK_F6              0x40
"F7",//#define DIK_F7              0x41
"F8",//#define DIK_F8              0x42
"F9",//#define DIK_F9              0x43
"F10",//#define DIK_F10             0x44
"NumLock",//#define DIK_NUMLOCK         0x45
"Scroll",//#define DIK_SCROLL          0x46    /* Scroll Lock */
"NumPad7",//#define DIK_NUMPAD7         0x47
"NumPad8",//#define DIK_NUMPAD8         0x48
"NumPad9",//#define DIK_NUMPAD9         0x49
"Substract",//#define DIK_SUBTRACT        0x4A    /* - on numeric keypad */
"NumPad4",//#define DIK_NUMPAD4         0x4B
"NumPad5",//#define DIK_NUMPAD5         0x4C
"NumPad6",//#define DIK_NUMPAD6         0x4D
"Add",//#define DIK_ADD             0x4E    /* + on numeric keypad */
"NumPad1",//#define DIK_NUMPAD1         0x4F
"NumPad2",//#define DIK_NUMPAD2         0x50
"NumPad3",//#define DIK_NUMPAD3         0x51
"NumPad0",//#define DIK_NUMPAD0         0x52
"Decimal",//#define DIK_DECIMAL         0x53    /* . on numeric keypad */
0,//0x54
0,//0x55
0,//0x56
"F11",//#define DIK_F11             0x57
"F12",//#define DIK_F12             0x58
0,//0x59
0,//0x5A
0,//0x5B
0,//0x5C
0,//0x5D
0,//0x5E
0,//0x5F
0,//0x60
0,//0x61
0,//0x62
0,//0x63
0,//0x64
0,//0x65
0,//0x66
0,//0x67
0,//0x68
0,//0x69
0,//0x6A
0,//0x6B
0,//0x6C
0,//0x6D
0,//0x6E
0,//0x6F
0,//0x70
0,//0x71
0,//0x72
0,//0x73
0,//0x74
0,//0x75
0,//0x76
0,//0x77
0,//0x78
0,//0x79
0,//0x7A
0,//0x7B
0,//0x7C
0,//0x7D
0,//0x7E
0,//0x7F
0,//0x80
0,//0x81
0,//0x82
0,//0x83
0,//0x84
0,//0x85
0,//0x86
0,//0x87
0,//0x88
0,//0x89
0,//0x8A
0,//0x8B
0,//0x8C
0,//0x8D
0,//0x8E
0,//0x8F
0,//0x90
0,//0x91
0,//0x92
0,//0x93
0,//0x94
0,//0x95
0,//0x96
0,//0x97
0,//0x98
0,//0x99
0,//0x9A
0,//0x9B
0,//0x9C
"RControl",//#define DIK_RCONTROL        0x9D
0,//9E
0,//9F
0,//A0
0,//A1
0,//A2
0,//A3
0,//A4
0,//A5
0,//A6
0,//A7
0,//A8
0,//A9
0,//AA
0,//AB
0,//AC
0,//AD
0,//AE
0,//AF
0,//B0
0,//B1
0,//B2
"NumPadComma",//#define DIK_NUMPADCOMMA     0xB3    /* , on numeric keypad (NEC PC98) */
0,//B4
"Divide",//#define DIK_DIVIDE          0xB5    /* / on numeric keypad */
0,//B6
"SysRequest",//#define DIK_SYSRQ           0xB7
"Right Alt",//#define DIK_RMENU           0xB8    /* right Alt */
0,//B9
0,//BA
0,//BB
0,//BC
0,//BD
0,//BE
0,//BF
0,//C0
0,//C1
0,//C2
0,//C3
0,//C4
0,//C5
0,//C6
"Home",//#define DIK_HOME            0xC7    /* Home on arrow keypad */
"UpArrow",//#define DIK_UP              0xC8    /* UpArrow on arrow keypad */
"PgUp",//#define DIK_PRIOR           0xC9    /* PgUp on arrow keypad */
0,//CA
"LeftArrow",//#define DIK_LEFT            0xCB    /* LeftArrow on arrow keypad */
0,//CC
"RightArrow",//#define DIK_RIGHT           0xCD    /* RightArrow on arrow keypad */
0,//CE
"End",//#define DIK_END             0xCF    /* End on arrow keypad */
"DownArrow",//#define DIK_DOWN            0xD0    /* DownArrow on arrow keypad */
"PgDn",//#define DIK_NEXT            0xD1    /* PgDn on arrow keypad */
"Insert",//#define DIK_INSERT          0xD2    /* Insert on arrow keypad */
"Delete",//#define DIK_DELETE          0xD3    /* Delete on arrow keypad */
0,//D4
0,//D5
0,//D6
0,//D7
0,//D8
0,//D9
0,//DA
"Left Windows",//#define DIK_LWIN            0xDB    /* Left Windows key */
"Right Windows",//#define DIK_RWIN            0xDC    /* Right Windows key */
"AppMenu",//#define DIK_APPS            0xDD    /* AppMenu key */
};

void Input_Create(int hWnd, int hInstance)
{
    if (DirectInputCreate((HINSTANCE)hInstance,DIRECTINPUT_VERSION,&pDInput,NULL))
		Error("DirectInputCreate()");
    if (pDInput->CreateDevice(GUID_SysKeyboard,&pKeyboard,NULL))
		Error("IDirectInput_CreateDevice(keyboard)");
    if (pKeyboard->SetDataFormat(&c_dfDIKeyboard))
		Error("IDirectInputDevice_SetDataFormat(keyboard)");
    if (pKeyboard->SetCooperativeLevel((HWND)hWnd, 
                               DISCL_NONEXCLUSIVE | DISCL_BACKGROUND))
		Error("IDirectInputDevice_SetCooperativeLevel(keyboard)");
    if (pKeyboard->Acquire())
		Error("IDirectInputDevice_Acquire(keyboard)");
}
void Input_Update()
{
    if (pKeyboard->GetDeviceState( sizeof(Keyboard),&Keyboard))
		Error("IDirectInputDevice_GetDeviceState(keyboard)");
}
void Input_Release()
{
    if (pKeyboard)
    {
        pKeyboard->Unacquire();
        pKeyboard->Release();
        pKeyboard = NULL;
    }
    if (pDInput)
    {
        pDInput->Release();
        pDInput = NULL;
    }
}
char* Input_GetKeyName(int Key)
{
	return Input_KeyNames[Key];
}
