////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "system.hpp"

#define	OBJECTTYPE_NONE 0

#define MAX_BLOCKWALLS 3
#define MAX_PROXIMITY_BOMBS 20
#define MAX_POWERUPS 20
#define MAX_VCLIPS 50
#define MAX_LASERS 20
#define MAX_DEBRIS 200
#define MAX_LIGHTS 30
#define MAX_ITEM_TYPES 10
#define MAX_RICOCHETS 200
#define MAX_THUNDERBOLTS 5

#define BLOCKS_NUM_X 5
#define BLOCKS_NUM_Y 4

#define NUM_POWERUP_FLARES 3

#define GAMEF_NOCREATEBLOCKWALLS 1
#define GAMEF_NOCREATELASERS 2
#define GAMEF_NODRAWSCORE 4
#define GAMEF_DRAWHELP 8
#define GAMEF_SOUND_ONE 0x10
#define GAMEF_SOUND_TWO 0x20
#define GAMEF_SOUND_THREE 0x40
#define GAMEF_SOUND_CROWD 0x80

#define ITEM_WALL_DESTROYER 0
#define ITEM_INVULNERABILITY 1

typedef struct {
	int Flags;
	Vector3 Position;
	int Score;
	float LastLaserFireTime;
	int	ItemCounts[MAX_ITEM_TYPES];
	float ItemLastTimeUsed[MAX_ITEM_TYPES];
} Player_t;
typedef struct {
	int Flags;
	Vector3 Position;
	Vector3 Velocity;
	float Width;
	float Height;
} Laser_t;
typedef struct {
	float Width;
	float Height;
	LVERTEX Walls[10];
	LVERTEX HorizonFront[4];
	LVERTEX HorizonBack[4];
} Tunnel_t;
typedef struct {
	float Z;
	float Depth;
	int Structure[BLOCKS_NUM_Y][BLOCKS_NUM_X];
} BlockWall_t;
typedef struct {
	int FrameCount;
	float FrameTime;
	float GameTime;
	float StartTime;
	float Fps;
	float LastSampledTime;
	int NumSampledFrames;
} FPS_t;
typedef struct {
	int Flags;
	Matrix4x3 Matrix;
	char* Mesh;
	Vector3 Scaling;
	Vector3 AngularVelocity;
	float ZSpeed;
	float ZMaxTravelled;
	float ZTravelled;
} ProximityBomb_t;
typedef struct {
	Vector3 Position;
	int Color;
	Vector3 Angles;
	Vector3 AngularVelocity;
} PowerUpFlare_t;
typedef struct {
	int Flags;
	Matrix4x3 Matrix;
	char* Mesh;
	Vector3 Scaling;
	Vector3 AngularVelocity;
	PowerUpFlare_t Flares[NUM_POWERUP_FLARES];
} PowerUp_t;
typedef struct {
	char* Name;
	int Key;
	int Cost;
} ItemType_t;
typedef struct {
	float Argb[4];
	float NewArgb[4];
} ScreenBlend_t;
typedef struct {
	int Flags;
	Vector3 Position;
	float Width;
	float Height;
	int Color;
	char** BaseTextureName;
	char** CurrTextureName;
	float TotalFrameTime;
	float CurrFrameTime;
} VClip_t;
typedef struct {
	int Flags;
	void* Texture;
	LVERTEX Mesh[3];
	Vector3 Velocity;
	Vector3 AngularVelocity;
} Debris_t;
typedef struct {
	int Flags;
	Vector3 Position;
	Vector3 Velocity;
	int StartColor;
	int EndColor;
	float StartTime;
} Ricochet_t;
typedef struct {
	int Flags;
	Vector3 StartPosition;
	Vector3 EndPosition;
} ThunderBolt_t;
typedef struct {
	Vector3 Position;
	int Color;
} Light_t;
typedef struct {
	int Flags;
	float LastHighlightMoveTime;
	float HighlightIntensity;
	int HighlightedIndex;
} Shop_t;
typedef struct {
	int Flags;
	float Speed;
	Matrix4x3 Camera;
	FPS_t Fps;
	Player_t Player;
	Tunnel_t Tunnel;
	BlockWall_t BlockWalls[MAX_BLOCKWALLS];
	LVERTEX BlockWallsMesh[BLOCKS_NUM_Y][BLOCKS_NUM_X][5][4];
	ProximityBomb_t ProximityBombs[MAX_PROXIMITY_BOMBS];
	PowerUp_t PowerUps[MAX_POWERUPS];
	VClip_t VClips[MAX_VCLIPS];
	Laser_t Lasers[MAX_LASERS];
	Light_t Lights[MAX_LIGHTS];
	Debris_t Debris[MAX_DEBRIS];
	Ricochet_t Ricochets[MAX_RICOCHETS];
	ThunderBolt_t ThunderBolts[MAX_THUNDERBOLTS];
	Shop_t Shop;
	ScreenBlend_t ScreenBlend;
} GameState_t;
typedef struct {
	int CheckObjectTypes;
	Vector3 StartPosition;
	Vector3 EndPosition;
	float Radius;
	int HitObject;
	void* pHitObject;
	float HitFraction;
	Vector3 HitPoint;
	Vector3 HitNormal;
	Vector3 HitTriangle[3];
} CollideInfo_t;
/////////////////////////////////////////////////
void W_CheckCollision(CollideInfo_t* collideInfo);
bool W_CollidePoint2BBox(Vector3 position, Vector3 mins, Vector3 maxs);
/////////////////////////////////////////////////
extern GameState_t* gs;
/////////////////////////////////////////////////
void FPS_Init();
void FPS_Update();
void FPS_Draw();
/////////////////////////////////////////////////
void Camera_Init();
void Camera_Update();
/////////////////////////////////////////////////
void Player_Init();
void Player_Update();
void Player_AddToScore(int DeltaScore);
void Player_AddItem(int ItemNumber);
void Player_DrawScore();
/////////////////////////////////////////////////
void Tunnel_Init();
void Tunnel_Draw();
void Tunnel_ClipPosition(Vector3 Position);
/////////////////////////////////////////////////
void BlockWalls_UpdateAll();
void BlockWalls_DrawAll();
void BlockWalls_InitAll();
bool BlockWalls_CheckCollision(Vector3 Position);
void BlockWall_XY_2_IJ(int* i, int* j, float x, float y);
void BlockWall_Init(int BlockWallIndex, float Z);
bool BlockWall_IsBlank(BlockWall_t* BlockWall);
void BlockWall_Explode(BlockWall_t* BlockWall);
/////////////////////////////////////////////////
void ProximityBombs_UpdateAll();
void ProximityBombs_DrawAll();
ProximityBomb_t* ProximityBombs_CheckCollision(Vector3 Position);
ProximityBomb_t* ProximityBomb_Create();
void ProximityBomb_Release(ProximityBomb_t* ProxBomb);
/////////////////////////////////////////////////
void PowerUps_UpdateAll();
void PowerUps_DrawAll();
PowerUp_t* PowerUps_CheckCollision(Vector3 Position);
PowerUp_t* PowerUp_Create();
void PowerUp_Release(PowerUp_t* PowerUp);
/////////////////////////////////////////////////
void ScreenBlend_Update();
void ScreenBlend_Draw();
void ScreenBlend_Add(float a, float r, float g, float b);
/////////////////////////////////////////////////
void VClips_UpdateAll();
void VClips_DrawAll();
VClip_t* VClip_Create(Vector3 Position, float Width, float Height, 
					 float TotalPlayTime, char** BaseTextureName, int IsLooped);
extern char* VClip_Explosion01[];
extern char* VClip_Explosion02[];
extern char* VClip_Smoke1[];
extern char* VClip_Smoke2[];
extern char* VClip_Smoke3[];
extern char* VClip_Smoke4[];
/////////////////////////////////////////////////
void Lasers_UpdateAll();
void Lasers_DrawAll();
Laser_t* Laser_Create();
/////////////////////////////////////////////////
Debris_t* Debris_Create();
void Debris_CreateFromMesh(char* MeshName, Matrix4x3 Matrix, Vector3 Scaling);
void Debris_UpdateAll();
void Debris_DrawAll();
/////////////////////////////////////////////////
void Lights_UpdateAll();
void Lights_DrawAll();
void Light_Add(Vector3 Position, int Color);
/////////////////////////////////////////////////
extern ItemType_t ItemTypes[MAX_ITEM_TYPES];
void Shop_Update();
void Shop_Draw();
void Shop_Begin();
void Shop_End();
/////////////////////////////////////////////////
void Ricochets_UpdateAll();
void Ricochets_DrawAll();
void Ricochet_Create(Vector3 Position);
/////////////////////////////////////////////////
void ThunderBolts_UpdateAll();
void ThunderBolts_DrawAll();
void ThunderBolt_Add(Vector3 StartPosition, Vector3 EndPosition);
/////////////////////////////////////////////////
void Help_Draw();
/////////////////////////////////////////////////
