////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "game.hpp"

typedef struct {
	Vector3 MoveDelta;
	float MoveRadius;
	Vector3 MoveMins, MoveMaxs;
	Vector3 MoveCorners[8];
	CollideInfo_t* pCollideInfo;
} CollisionDataPriv_t;

CollisionDataPriv_t* collData = 0;
void W_CheckInit()
{
	if (!collData)
		collData = (CollisionDataPriv_t*)Sys_HeapAlloc(sizeof(*collData));
}
bool W_CollideSphere2Sphere(Vector3 position1, float radius1, Vector3 position2, float radius2)
{
	return (VectorSqrdDistance(position1, position2) <= ((radius1 + radius2)*(radius1 + radius2)));
}
bool W_CollidePoint2BBox(Vector3 position, Vector3 mins, Vector3 maxs)
{
	return ((position[0] >= mins[0]) && (position[0] <= maxs[0])
			&& (position[1] >= mins[1]) && (position[1] <= maxs[1])
			&& (position[2] >= mins[2]) && (position[2] <= maxs[2]));
}
bool W_CollideBBox2BBox(Vector3 mins1, Vector3 maxs1, Vector3 mins2,Vector3 maxs2)
{
	for (int i=0; i<3; i++)
		if ((mins1[i] > maxs2[i]) || (maxs1[i] < mins2[i]))
			return false;
	return true;
}
bool W_CheckCollisionWithMesh(Mesh_t* mesh, Vector3 mins, Vector3 maxs, float radius,
							  Matrix4x3 matrix, Vector3 scaling)
{
	static const int ProjectionPlanes[3][2] = {{1,2},{2,0},{0,1}};
	int i, j, k, LargestComponent, Index1, Index2;
	int HasHit = false;
	float TotalDistance, RelDistance, NewHitFraction, BestDot, NewDot;
	Vector3 LocalMins, LocalMaxs, InverseScaling, StartPosition, EndPosition,
		    vDelta, vToPlane, NewHitPoint, AbsNormal, vEdge;
	Matrix4x3 ScaledMatrix;
	Vector3* pWorldSpaceCorner, ObjectSpaceCorner;
	LVERTEX* pVertices;
	CollideInfo_t* CollideInfo = collData->pCollideInfo;
	TriangleDesc_t* TriangleDesc, *HitTriangleDesc;
	if ((mins) && (maxs))
		if (!W_CollideBBox2BBox(collData->MoveMins, collData->MoveMaxs,
							mins, maxs))
			return false;
	if (radius)
		if (!W_CollideSphere2Sphere(matrix[3], radius, 
								    CollideInfo->StartPosition, CollideInfo->Radius))
			return false;
	if (scaling)
		for (i=0; i<3; i++)
			InverseScaling[i] = 1.0f / scaling[i];
	else
		VectorSet(InverseScaling,1.0f, 1.0f, 1.0f);
	pWorldSpaceCorner = &collData->MoveCorners[0];
	for (i=0; i<8; i++)
	{
		VectorInverseTransform(matrix, ObjectSpaceCorner, *pWorldSpaceCorner);
		for (j=0; j<3; j++)
			ObjectSpaceCorner[j] *= InverseScaling[j];
		if (i == 0)
		{
			VectorCopy(LocalMins, ObjectSpaceCorner);
			VectorCopy(LocalMaxs, ObjectSpaceCorner);
		}
		else
			M_BBoxAddPoint(LocalMins, LocalMaxs, ObjectSpaceCorner);
		pWorldSpaceCorner++;
	}
	VectorInverseTransform(matrix, StartPosition, CollideInfo->StartPosition);
	VectorInverseTransform(matrix, EndPosition, CollideInfo->EndPosition);
	for (i=0; i<3; i++)
	{
		StartPosition[i] *= InverseScaling[i];
		EndPosition[i] *= InverseScaling[i];
	}
	VectorSub(vDelta, EndPosition, StartPosition);
	TriangleDesc = mesh->pTriDesc;
	for (i=0; i<mesh->NumTriangles; i++, TriangleDesc++)
	{
		if (!W_CollideBBox2BBox(TriangleDesc->Mins,TriangleDesc->Maxs,LocalMins,LocalMaxs))
			continue;
		pVertices = TriangleDesc->pVertices;
		VectorSub(vToPlane, &pVertices[0].x, StartPosition);
		RelDistance = DotProduct(vToPlane, TriangleDesc->Normal);
		TotalDistance = DotProduct(vDelta, TriangleDesc->Normal);
		if ((RelDistance > 0) || (TotalDistance > 0) || (RelDistance < TotalDistance))
			continue;
	// TODO : cas special : TotalDistance == 0
		NewHitFraction = RelDistance / TotalDistance;
		VectorScale(vToPlane, vDelta, NewHitFraction);
		VectorAdd(NewHitPoint, StartPosition, vToPlane);
		for (j=0; j<3; j++)
			AbsNormal[j] = M_fabs(TriangleDesc->Normal[j]);
		if (AbsNormal[0] > AbsNormal[1])
			if (AbsNormal[0] > AbsNormal[2])
				LargestComponent = 0;
			else
				LargestComponent = 2;
		else	
			if (AbsNormal[1] > AbsNormal[2])
				LargestComponent = 1;
			else
				LargestComponent = 2;
		Index1 = ProjectionPlanes[LargestComponent][0];
		Index2 = ProjectionPlanes[LargestComponent][1];
		if (TriangleDesc->Normal[LargestComponent] < 0.0f)
		{
			k = Index1; 
			Index1 = Index2;
			Index2 = k;
		}
		for (j=0; j<3; j++)
		{
			k = (j == 2)?0:(j+1);
			VectorSub(vEdge, &pVertices[k].x, &pVertices[j].x);
			VectorSub(vToPlane, NewHitPoint, &pVertices[j].x);
			if (vEdge[Index1]*vToPlane[Index2] > vEdge[Index2]*vToPlane[Index1])
				break;
		}
		if (j < 3)
			continue;

		NewDot = DotProduct(vDelta, TriangleDesc->Normal);
		if ((HasHit) && (NewDot > BestDot))
			continue;
		else BestDot = NewDot;
#if 1
		HasHit = true;
		HitTriangleDesc = TriangleDesc;
		CollideInfo->HitFraction = NewHitFraction;
		VectorCopy(CollideInfo->HitPoint, NewHitPoint);
//		break;
#endif
	}
	if (!HasHit)
		return false;
	else
	{
		if (scaling)
			Matrix_Scale(ScaledMatrix, matrix, scaling);
		else
			Matrix_Copy(ScaledMatrix, matrix);
		VectorTransform(ScaledMatrix, CollideInfo->HitPoint, CollideInfo->HitPoint);
		VectorRotate(matrix, CollideInfo->HitNormal, HitTriangleDesc->Normal);
		pVertices = HitTriangleDesc->pVertices;
		for (i=0; i<3; i++)
			VectorTransform(ScaledMatrix, CollideInfo->HitTriangle[i], &pVertices[i].x);
		return true;
	}
}
/*bool W_CheckCollisionWithBuildings()
{
	Building_t* building = gs->Buildings;
	CollideInfo_t* collideInfo = collData->pCollideInfo;
	for (int i=0; i<MAX_NUM_BUILDINGS; i++, building++)
		if ((building->Flags & BUILDINGF_INUSE)
		    && (W_CheckCollisionWithMesh(building->Mesh, building->Mins, building->Maxs,0,
										  building->Matrix, building->Scaling)))
		{
			collideInfo->HitObject = OBJECTTYPE_BUILDING;
			collideInfo->pHitObject = building;
			return true;
		}
	return false;
}*/
void W_CheckCollision(CollideInfo_t* collideInfo)
{
	W_CheckInit();
	collideInfo->HitObject = OBJECTTYPE_NONE;
	VectorSub(collData->MoveDelta, collideInfo->EndPosition, collideInfo->StartPosition);
	collData->MoveRadius = VectorLength(collData->MoveDelta) + collideInfo->Radius;
	VectorCopy(collData->MoveMins, collideInfo->StartPosition);
	VectorCopy(collData->MoveMaxs, collideInfo->StartPosition);
	M_BBoxAddPoint(collData->MoveMins, collData->MoveMaxs, collideInfo->EndPosition);
	collData->MoveMins[0] -= collideInfo->Radius;
	collData->MoveMins[1] -= collideInfo->Radius;
	collData->MoveMins[2] -= collideInfo->Radius;
	collData->MoveMaxs[0] += collideInfo->Radius;
	collData->MoveMaxs[1] += collideInfo->Radius;
	collData->MoveMaxs[2] += collideInfo->Radius;
	M_BBoxGetCorners(collData->MoveCorners, collData->MoveMins, collData->MoveMaxs);
	collData->pCollideInfo = collideInfo;
//	if (collideInfo->CheckObjectTypes & OBJECTTYPE_BUILDING)
//		if (W_CheckCollisionWithBuildings())
//			return;	
}
