////////////////////////////////////////////////////////////////////////////
//	write your comments to : loadall@hotmail.com
//  chat with the author (loadall) on IRCNet, channel #coders
////////////////////////////////////////////////////////////////////////////
#include "game.hpp"
#define BLOCKSIDE_LEFT 0
#define BLOCKSIDE_RIGHT 1
#define BLOCKSIDE_UP 2
#define BLOCKSIDE_DOWN 3
#define BLOCKSIDE_FRONT 4
#define BLOCK_NUM_DRAWN_SIDES 5
const float BLOCK_DEPTH = 50.0F;
const float BLOCKWALLS_ZRANGE = 700.0f;

char BLOCKWALL_TEXTURE[] = "Wall.pcx";

bool BlockWall_IsBlank(BlockWall_t* BlockWall)
{
	int* Structure = &BlockWall->Structure[0][0];
	for (int i=0; i<(BLOCKS_NUM_X*BLOCKS_NUM_Y); i++, Structure++)
		if (*Structure)
			return false;
	return true;
}
void BlockWall_AddDebris(BlockWall_t* BlockWall, LVERTEX* Vertices)
{
	for (int i=0; i<2; i++)
	{
		Debris_t* Debris = Debris_Create();
		Debris->Texture = Texture_Get(BLOCKWALL_TEXTURE);
		Sys_memCopy(Debris->Mesh, Vertices + i, sizeof(*Vertices)*3);
		for (int j=0; j<3; j++)
			Debris->Mesh[j].z += BlockWall->Z;
	}
}
void BlockWall_Explode(BlockWall_t* BlockWall)
{
	LVERTEX* Vertex = &gs->BlockWallsMesh[0][0][0][0];
	Vector3 Position;
	VectorSet(Position, 0, 0, BlockWall->Z);
	Sound_Play("EXPLOSION.WAV", Position, 0, 0, SOUND_3D);
	for (int i=0; i<BLOCKS_NUM_Y; i++)
		for (int j=0; j<BLOCKS_NUM_X; j++)
		{
			if (BlockWall->Structure[i][j])
			{
				BlockWall_AddDebris(BlockWall, &Vertex[BLOCKSIDE_FRONT*4]);
				if ((j > 0) && (!BlockWall->Structure[i][j-1]))
					BlockWall_AddDebris(BlockWall, &Vertex[BLOCKSIDE_LEFT*4]);
				if ((j < (BLOCKS_NUM_X - 1)) && (!BlockWall->Structure[i][j+1]))
					BlockWall_AddDebris(BlockWall, &Vertex[BLOCKSIDE_RIGHT*4]);
				if ((i > 0) && (!BlockWall->Structure[i-1][j]))
					BlockWall_AddDebris(BlockWall, &Vertex[BLOCKSIDE_UP*4]);
				if ((i < (BLOCKS_NUM_Y - 1)) && (!BlockWall->Structure[i+1][j]))
					BlockWall_AddDebris(BlockWall, &Vertex[BLOCKSIDE_DOWN*4]);
			}
			Vertex+=(BLOCK_NUM_DRAWN_SIDES*4);
		}
	Sys_memClear(BlockWall->Structure, sizeof(BlockWall->Structure));
}
void BlockWalls_InitMesh()
{
	Tunnel_t* Tunnel = &gs->Tunnel;
	LVERTEX* pVertex = &gs->BlockWallsMesh[0][0][0][0];
	int i, j;
	float x0, y0, x1, y1, BlockWidth, BlockHeight;
	int Color = 0xffb0b0b0;
	BlockHeight = 2.0f * Tunnel->Height / BLOCKS_NUM_Y;
	BlockWidth = 2.0f * Tunnel->Width / BLOCKS_NUM_X;
	y0 = Tunnel->Height;
	for (i=0; i<BLOCKS_NUM_Y; i++)
	{
		y1 = y0 - BlockHeight;
		x0 = -Tunnel->Width;
		for (j=0; j<BLOCKS_NUM_X; j++)
			{
				x1 = x0 + BlockWidth;
				LVERTEX_Set(&pVertex[BLOCKSIDE_FRONT*4 + 0], x0, y0, -BLOCK_DEPTH, Color, 0.0f, 0.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_FRONT*4 + 1], x0, y1, -BLOCK_DEPTH, Color, 0.0f, 1.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_FRONT*4 + 2], x1, y0, -BLOCK_DEPTH, Color, 1.0f, 0.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_FRONT*4 + 3], x1, y1, -BLOCK_DEPTH, Color, 1.0f, 1.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_LEFT*4 + 0], x0, y0, BLOCK_DEPTH, Color, 0.0f, 0.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_LEFT*4 + 1], x0, y1, BLOCK_DEPTH, Color, 0.0f, 1.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_LEFT*4 + 2], x0, y0, -BLOCK_DEPTH, Color, 1.0f, 0.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_LEFT*4 + 3], x0, y1, -BLOCK_DEPTH, Color, 1.0f, 1.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_RIGHT*4 + 0], x1, y0, -BLOCK_DEPTH, Color, 0.0f, 0.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_RIGHT*4 + 1], x1, y1, -BLOCK_DEPTH, Color, 0.0f, 1.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_RIGHT*4 + 2], x1, y0, BLOCK_DEPTH, Color, 1.0f, 0.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_RIGHT*4 + 3], x1, y1, BLOCK_DEPTH, Color, 1.0f, 1.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_DOWN*4 + 0], x0, y1, -BLOCK_DEPTH, Color, 0.0f, 0.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_DOWN*4 + 1], x0, y1, BLOCK_DEPTH, Color, 0.0f, 1.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_DOWN*4 + 2], x1, y1, -BLOCK_DEPTH, Color, 1.0f, 0.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_DOWN*4 + 3], x1, y1, BLOCK_DEPTH, Color, 1.0f, 1.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_UP*4 + 0], x0, y0, BLOCK_DEPTH, Color, 0.0f, 0.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_UP*4 + 1], x0, y0, -BLOCK_DEPTH, Color, 0.0f, 1.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_UP*4 + 2], x1, y0, BLOCK_DEPTH, Color, 1.0f, 0.0f);
				LVERTEX_Set(&pVertex[BLOCKSIDE_UP*4 + 3], x1, y0, -BLOCK_DEPTH, Color, 1.0f, 1.0f);
				pVertex+=(BLOCK_NUM_DRAWN_SIDES*4);
				x0 = x1;
			}
		y0 = y1;
	}
}
void BlockWall_Init(int BlockWallIndex, float Z)
{
	BlockWall_t* BlockWall = &gs->BlockWalls[BlockWallIndex];
	BlockWall->Depth = BLOCK_DEPTH;
	BlockWall->Z = Z;
	int i, j;
	for (i=0; i<BLOCKS_NUM_Y; i++)
	{
		for (j=0; j<BLOCKS_NUM_X; j++)
			BlockWall->Structure[i][j] = true;
		if (i == (BLOCKS_NUM_Y - 2))
			continue;
		j = (int)(M_Rand() * BLOCKS_NUM_X);
		BlockWall->Structure[i][j] = false;
		if (i < (BLOCKS_NUM_Y - 2))
		{
			ProximityBomb_t* ProxBomb = ProximityBomb_Create();
			VectorAdd(ProxBomb->Matrix[3], 
					(float*)(&gs->BlockWallsMesh[i][j][BLOCKSIDE_FRONT][0].x),
					(float*)(&gs->BlockWallsMesh[i][j][BLOCKSIDE_FRONT][3].x));
			VectorScale2(ProxBomb->Matrix[3], 0.5f);
			ProxBomb->Matrix[3][2] = BlockWall->Z;
			VectorRandom(ProxBomb->AngularVelocity);
			VectorScale2(ProxBomb->AngularVelocity, 2.0f);
			continue;
		}
		else if (M_Rand() > 0.5f)
		{
			PowerUp_t* PowerUp = PowerUp_Create();
			VectorAdd(PowerUp->Matrix[3], 
					(float*)(&gs->BlockWallsMesh[i][j][BLOCKSIDE_FRONT][0].x),
					(float*)(&gs->BlockWallsMesh[i][j][BLOCKSIDE_FRONT][3].x));
			VectorScale2(PowerUp->Matrix[3], 0.5f);
			PowerUp->Matrix[3][2] = BlockWall->Z;
			VectorRandom(PowerUp->AngularVelocity);
			VectorScale2(PowerUp->AngularVelocity, 2.0f);
		}
		else 
			BlockWall->Structure[i][j] = true;
	}
}
void BlockWalls_InitAll()
{
	float Z;
	BlockWalls_InitMesh();
	Z = BLOCKWALLS_ZRANGE;
	for (int i=0; i<MAX_BLOCKWALLS; i++, Z+= (BLOCKWALLS_ZRANGE/MAX_BLOCKWALLS))
		BlockWall_Init(i, Z);
}
void BlockWall_XY_2_IJ(int* i, int* j, float x, float y)
{
	Tunnel_t* Tunnel = &gs->Tunnel;
	int ni = (int)(((Tunnel->Height - y) / (2.0f * Tunnel->Height)) * BLOCKS_NUM_Y);
	if (ni > BLOCKS_NUM_Y)
		ni = BLOCKS_NUM_Y;
	else if (ni < 0)
		ni = 0;
	if (i)
		*i = ni;
	int nj = (int)(((x + Tunnel->Width) / (2.0f * Tunnel->Width)) * BLOCKS_NUM_X);
	if (nj > BLOCKS_NUM_X)
		nj = BLOCKS_NUM_X;
	else if (nj < 0)
		nj = 0;
	if (j)
		*j = nj;
}
bool BlockWalls_CheckCollision(Vector3 Position)
{
	BlockWall_t* BlockWall = &gs->BlockWalls[0];
	int j, k;
	for (int i=0; i<MAX_BLOCKWALLS; i++, BlockWall++)
	{
		if (((BlockWall->Z - BLOCK_DEPTH) > Position[2]) || 
			((BlockWall->Z + BLOCK_DEPTH) < Position[2]))
			continue;
		Player_t* Player = &gs->Player;
		BlockWall_XY_2_IJ(&j, &k, Position[0], Position[1]);
		if (!BlockWall->Structure[j][k])
			continue;
		return true;
	}
	return false;
}
void BlockWalls_UpdateAll()
{
	BlockWall_t* BlockWall;
	int i;
	float Z;
	BlockWall = &gs->BlockWalls[0];
	for (i=0; i<3; i++)
	{
		BlockWall->Z -= (gs->Speed * gs->Fps.FrameTime);
		BlockWall++;
	}
	BlockWall = &gs->BlockWalls[0];
	if ((BlockWall->Z < -BLOCK_DEPTH)
		&& (!(gs->Flags & GAMEF_NOCREATEBLOCKWALLS)))
	{
		for (i=0; i<(MAX_BLOCKWALLS-1); i++)
		{
			Sys_memCopy(BlockWall, BlockWall+1, sizeof(*BlockWall));
			BlockWall++;
		}
		Z = BLOCKWALLS_ZRANGE;
		BlockWall_Init(MAX_BLOCKWALLS-1, Z);
	}
}
void BlockWalls_DrawAll()
{
	BlockWall_t* BlockWall = &gs->BlockWalls[0];
	LVERTEX* pVertex;
	Matrix4x3 Matrix;
	int i, j, k;
	D3D_SetTexture(0, Texture_Get(BLOCKWALL_TEXTURE));
	for (i=0; i<MAX_BLOCKWALLS; i++)
	{
		Matrix_SetIdentity(Matrix);
		Matrix[3][2] = BlockWall->Z;
		D3D_SetTransform(D3DTRANSFORMSTATE_WORLD, (float*)&Matrix);
		pVertex = &gs->BlockWallsMesh[0][0][0][0];
		for (j=0; j<BLOCKS_NUM_Y; j++)
			for (k=0; k<BLOCKS_NUM_X; k++)
			{
				if (BlockWall->Structure[j][k])
				{
					D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, &pVertex[BLOCKSIDE_FRONT*4], 4, 0);
					if ((k > 0) && (!BlockWall->Structure[j][k-1]))
						D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, &pVertex[BLOCKSIDE_LEFT*4], 4, 0);
					if ((k < (BLOCKS_NUM_X - 1)) && (!BlockWall->Structure[j][k+1]))
						D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, &pVertex[BLOCKSIDE_RIGHT*4], 4, 0);
					if ((j > 0) && (!BlockWall->Structure[j-1][k]))
						D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, &pVertex[BLOCKSIDE_UP*4], 4, 0);
					if ((j < (BLOCKS_NUM_Y - 1)) && (!BlockWall->Structure[j+1][k]))
						D3D_DrawPrimitive(D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, &pVertex[BLOCKSIDE_DOWN*4], 4, 0);
				}
				pVertex+=(BLOCK_NUM_DRAWN_SIDES*4);
			}
		BlockWall++;
	}
}
