# yet another prebot irc front-end v1.0a by phillie/ppx 2003
#
# front end for pocis c prebot
#
# commands:
#
# !pre <releasename>               - pre <rlsname>
# !pre -f <releasename>            - force pre even if sites are down
#
#
# config:

# group acronym
set pfe(group) "PPX"

# group chan
set pfe(chan) "#ppx"

# location to prebot executable
set pfe(path) "/glftpd/sitebot/scripts/pre"

# blowfish support [1/0]
set pfe(blow) 0

# blowfish key
set pfe(key) "perplexisgood"

########################################################################

set pfe(ver) "V1.0"
set pfe(f) "\[\002[string toupper $pfe(group)]\002-\002PRE\002\]"

bind pub - !pre pfepre
bind pub - +OK pfeencryptedincominghandler

proc readpre {fp} {
	global pfe
	while {[gets $fp line]!=-1} {
		if {$pfe(blow)==0} {
			putserv "PRIVMSG $pfe(chan) :[string map {\t {    }} $line]"
		} else {
			pfeputblow "PRIVMSG $pfe(chan) :[string map {\t {    }} $line]"
		}
	}
	if {[eof $fp]} {close $fp}
}


proc pfepre {nick host hand chan arg} {
	global pfe
	if {[string tolower $chan] != [string tolower $pfe(chan)]} {return}
	if {![file exist $pfe(path)]} {
		if {$pfe(blow) == 0} {
			putserv "PRIVMSG $chan :$pfe(f) prebot executable not found, check your config."
			return
		} else {
			pfeputblow "PRIVMSG $chan :$pfe(f) prebot executable not found, check your config."
			return
	}	}
	if {$arg == ""} {
		if {$pfe(blow) == 0} {
			putserv "PRIVMSG $chan :$pfe(f)"
			putserv "PRIVMSG $chan :$pfe(f) no releasename given"
			putserv "PRIVMSG $chan :$pfe(f) syntax: !pre <releasename>"
		} else {
			pfeputblow "PRIVMSG $chan :$pfe(f) no releasename given"
			pfeputblow "PRIVMSG $chan :$pfe(f) syntax: !pre <releasename>"
		}
	} else {
		set oldpwd [pwd]
		cd [join [lrange [split $pfe(path) /] 0 end-1] /]
		set fp [open "|$pfe(path) $arg"]
		fconfigure $fp -buffering line
		fconfigure $fp -blocking 0
		fileevent $fp readable [list readpre $fp]
		cd $oldpwd
}	}

# blowcrypt code by poci

proc pfeputblow {text {option ""}} {
	global pfe
	if {$option==""} {
		if {[lindex $text 0]=="PRIVMSG" && [info exists pfe(key)]} {
			putserv "PRIVMSG [lindex $text 1] :+OK [encrypt $pfe(key) [string trimleft [join [lrange $text 2 end]] :]]"
		} else {
			putserv $text
		}
	} else {
	  	if {[lindex $text 0]=="PRIVMSG" && [info exists slblowkey([string tolower [lindex $text 1]])]} {
			putserv "PRIVMSG [lindex $text 1] :+OK [encrypt $pfe(key) [string trimleft [join [lrange $text 2 end]] :]]" $option
		} else {
			putserv $text $option
		}
	}
}

proc pfeencryptedincominghandler {nick host hand chan arg} {
	global pfe
	if {![info exists pfe(key)]} {return}
	set tmp [decrypt $pfe(key) $arg]
	foreach item [binds pub] {
		if {[lindex $item 2]=="+OK"} {continue}
		if {[lindex $item 1]!="-|-"} {
			if {![matchattr $hand [lindex $item 1] $chan]} {continue}
		}
		if {[lindex $item 2]==[lindex $tmp 0]} {[lindex $item 4] $nick $host $hand $chan [lrange $tmp 1 end]}
	 }
}

putlog "YET ANOTHER PREBOT IRC FRONT-END $pfe(ver) LOADED - CODE BY PHILLIE/PPX 2003"
