#!/usr/bin/tclsh
#
# ispblocks.tcl v1.1 by phillie/ppx 2004
#
# check netblocks for isp ownage
# max. range supported is a 1.1.1.1/18 subnet
#
# changelog:
#
# v1.0 - initial release
# v1.1 - added grep matchings for another type of whois replies
#        like the rwth aachen or xlink are using.
#
# todo:
#
# - logfile creation
#
# config:

# start ip
set startip "127.0.0.1"

# end ip (last value has to be 255, e.g. 127.0.0.255)
set endip "127.0.11.255"

# isp name
set isp "telekom"

# verbose/debug mode [0/1]
set debug 0

######################################################

set start "[clock seconds] [clock format [clock seconds] -format "%a, %b %Y %T %Z"]"

puts "ISPBLOCKS.TCL V1.1 BY PHILLIE/PPX 2004"
puts ""
puts "script started at [lrange $start 1 end]."
puts "-------------------------------------"

set count1 0
set count2 0
proc fetchip {ip} {
	global debug count1
	puts "getting whois-server information for $ip ..."
	catch {exec whois --verbose -H $ip > $ip.temp}
	incr count1
	if {$debug == 1} { puts "whois-server information for $ip saved to $ip.temp." }
}

proc delip {ip} {
	global debug
	if {$debug == 1} { puts "deleting whois-server information for $ip ..." }
	catch {exec rm -f $ip.temp}
}

proc testisp {ip} {
	global debug isp
	set status 0
	set fp [open $ip.temp r]
	while {![eof $fp]} {
		gets $fp line
		if {[string match -nocase *$isp* $line]} {set status 1}
	}
	close $fp
	if {$status == 1} {
		return 1
	} else {
		return 0
	}
}

proc getinfo {ip} {
	global isp debug count2
	if {[testisp $ip]} {
		incr count2
		catch {set inetnum [lrange [exec cat $ip.temp | grep inetnum:] 1 end]}
		catch {set netname [lindex [exec cat $ip.temp | grep netname:] end]}
		catch {set route [lindex [exec cat $ip.temp | grep route:] end]}
		catch {set mnt [lindex [exec cat $ip.temp | grep mnt-by:] end]}
		catch {set inetnum [lrange [exec cat $ip.temp | grep NetRange:] 1 end]}
		catch {set netname [lindex [exec cat $ip.temp | grep NetName:] end]}
		catch {set route [lindex [exec cat $ip.temp | grep CIDR:] end]}
		catch {set mnt [lindex [exec cat $ip.temp | grep OrgName:] end]}
		puts "$ip -> $inetnum $route $netname $mnt"
		puts "$ip"
	} else {
		puts "$ip is not matching to isp $isp."
		catch {set inetnum [lrange [exec cat $ip.temp | grep inetnum:] 1 end]}
		catch {set netname [lindex [exec cat $ip.temp | grep netname:] end]}
		catch {set route [lindex [exec cat $ip.temp | grep route:] end]}
		catch {set mnt [lindex [exec cat $ip.temp | grep mnt-by:] end]}
		catch {set inetnum [lrange [exec cat $ip.temp | grep NetRange:] 1 end]}
		catch {set netname [lindex [exec cat $ip.temp | grep NetName:] end]}
		catch {set route [lindex [exec cat $ip.temp | grep CIDR:] end]}
		catch {set mnt [lindex [exec cat $ip.temp | grep OrgName:] end]}
		puts "$ip -> $inetnum $route $netname $mnt"
	}
	return "$inetnum $route $netname $mnt"
}

set actual $startip

while {$actual != $endip} {
	fetchip $actual
	set ipinfo [getinfo $actual]
	delip $actual
	if {[lindex [split [lindex $ipinfo 2] "."] 3] != 255} {
		set actual "[lindex [split [lindex $ipinfo 2] "."] 0].[lindex [split [lindex $ipinfo 2] "."] 1].[lindex [split [lindex $ipinfo 2] "."] 2].[expr [lindex [split [lindex $ipinfo 2] "."] 3] +1]"
	} else {
		set actual "[lindex [split [lindex $ipinfo 2] "."] 0].[lindex [split [lindex $ipinfo 2] "."] 1].[expr [lindex [split [lindex $ipinfo 2] "."] 2] + 1].0"
	}
	if {[lindex [split [lindex $ipinfo 2] "."] 2] >= [lindex [split $endip "."] 2] && [lindex [split [lindex $ipinfo 2] "."] 3] >= [lindex [split $endip "."] 3]} {
		puts ""
		puts "WARNING: whois-server replied [lindex $ipinfo 2] as inetnum, i cant determine the next subnet."
		puts "stopping script."
		puts ""
		break
	}
	if {[lindex [split [lindex $ipinfo 2] "."] 2] == [lindex [split $endip "."] 2] && [lindex [split [lindex $ipinfo 2] "."] 3] >= [lindex [split $endip "."] 3]} {
		puts ""
		puts "WARNING: whois-server replied [lindex $ipinfo 2] as inetnum, i cant determine the next subnet."
		puts "stopping script."
		puts ""
		break
	}
}

set end "[clock seconds] [clock format [clock seconds] -format "%a, %b %Y %T %Z"]"

puts "ispblocks.tcl finished."
puts ""
puts "------------ statistics -------------"
puts "x01 = Script started at [lrange $start 1 end]"
puts "x02 = Script finished at [lrange $end 1 end]"
puts "x03 = Script was running for [clock format [expr ([lindex $end 0] - [lindex $start 0]) - 3600] -format "%T"]"
puts "x04 = Whois-Server queried $count1 time(s)."
puts "x05 = $count2 matched netblock(s) found."
puts ""

exit
