/*
	demo1.c - TriBBS API Demo Program
	Copyright (c) 1994 By TriSoft
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <share.h>
#include "tbapi.h"

void main(int argc, char **argv)
{
	SHORT i, j, conferencenumber, compressionflag, numberofmessages;
	USHORT l, inbufferlength;
	unsigned char *inbuffer, *outbuffer, *workbuffer;

	/* Display opening screen */
	printf("TBAPI Demo Program No. 1 1.0\n");
	printf("Copyright (c) 1994 By TriSoft\n\n");

	if (argc < 2) {
		printf("Use as:\n\n");
		printf("DEMO1 conferencenumber\n\n");
		printf("Where:\n\n");
		printf("conferencenumber    is the number of the message conference.\n");
		exit(1);
	}
	conferencenumber = atoi(argv[1]);
	
	/* Open SYSDAT2.DAT and point the API to Node 1's main directory */
	TBReadSYSDAT2DAT();
	strcpy(Node1sMainDirectory, SysDat2Data.Node1sMainDirectory);

	/* Initialize the TriBBS API */
	TBInitialize();

	/* Allocate the buffers need to perform compression */
	inbuffer = (unsigned char *)malloc(40000U);
	outbuffer = (unsigned char *)malloc(40000U);
	workbuffer = (unsigned char *)malloc(40000U);

	/* Get the conference's MCONF.DAT record */
	TBOpenMCONFDAT();
	TBReadMCONFDAT(conferencenumber);
	fclose(MConfFile);
	printf("Reading Conference: %s\n\n", MConfData.ConferenceName);

	TBOpenMnnnnPTR(conferencenumber);
	numberofmessages = TBNumberInMnnnnPTR();
	TBOpenMnnnnTXT(conferencenumber);
	for (i = 0; i < numberofmessages; i++) {
		fsread(&inbufferlength, sizeof(USHORT), 1, MTxtFile);
		fsread(&compressionflag, sizeof(SHORT), 1, MTxtFile);
		fsread(inbuffer, inbufferlength, 1, MTxtFile);
		if (compressionflag)
			l = TBUncompress(inbuffer, inbufferlength, outbuffer, workbuffer);
		else {
			memmove(outbuffer, inbuffer, inbufferlength);
			l = inbufferlength;
		}
		printf("Message %d of %d\n", i + 1, numberofmessages);
		for (j = 0; j < l; j++) {
			if (outbuffer[j])
				putch(outbuffer[j]);
			else
				printf("\n");
		}
		printf("\n\n");
		while (!kbhit()) ;
		switch (getch()) {
			case 0:
				getch();
				break;
			case 27:
				fclose(MTxtFile);
				fclose(MPtrFile);
				exit(0);
		}
	}
	fclose(MTxtFile);
	fclose(MPtrFile);
	exit(0);
}
