'+--------------------------[ PCB-ATCH Ver 1.00 ]----------------------------+
'|  Written By Gary Meeker 07/11/94                        Updated   /  /    |
'|  SYSOP: SHARP Technical Support Line BBS               Lawrenceville, GA  |
'|         (404) 962-1788                          300-28800 Baud. 24 Hours  |
'+---------------------------------------------------------------------------+
'V1.00  07/11/94 - Initial Release

DEFINT A-Z

'   PDQ Declarations
DECLARE FUNCTION PDQExist% (FileSpec$)
DECLARE FUNCTION PDQParse$ (Work$)
DECLARE FUNCTION PDQValI% (Number$)
DECLARE FUNCTION PDQValL& (Number$)
DECLARE SUB SetDelimitChar (Char)
DECLARE SUB CritErrOff ()
DECLARE SUB CritErrOn ()

'   QuickPack Declarations
DECLARE FUNCTION QPStrI$ (IntValue%)
DECLARE SUB FCopy (Source$, Dest$, Buffer$, ErrCode%)

' PROBAS Declarations

' Myown Declarations
DECLARE FUNCTION EndString(Temp$, EndCh$)
DECLARE FUNCTION FindLastCh(St$, BYVAL Ch)
DECLARE SUB INC ALIAS "_inc" (IntVar%)
DECLARE SUB INC2 ALIAS "_incL" (LongVar&)
DECLARE SUB IncStepL(LongVar&, StepVar%)

' Local Declarations
DECLARE FUNCTION EndChar$(St$, EndCh$)
DECLARE FUNCTION MakeExt$(St$, Ext$)
DECLARE SUB ProcessFile(Num)
DECLARE SUB ModifyName(ConfNum, MsgNum&, NewName$)

TYPE QWKMsgRecord
   Status AS STRING * 1          'Status Flag (*+-`~ or blank)                   1
   Number AS STRING * 7          'Message Number                                 2
   MDate AS STRING * 8           'Date of Message (in mm-dd-yy format)           9
   MTime AS STRING * 5           'Time of Message (in hh:mm format)             17
   ToWho AS STRING * 25          'Who the Message is For                        22
   From AS STRING * 25           'Who the Message is From                       47
   Subject AS STRING * 25        'Subject of the Message                        72
   Password AS STRING * 12       'Message Password (if any or ^^)               97
   Reference AS STRING * 8       'Reference Message Number                     109
   Blocks AS STRING * 6          'Number of 128 byte blocks in Message         117
   Deleted AS STRING * 1         'Flag for Message Status (#225 or #226)       123
   ConfNum AS INTEGER            'Conference number (unsigned word)            124
   MsgNum AS INTEGER             'Logical message number in the current packet 126
   NetTag AS STRING * 1          '                                             128
END TYPE                                                                      '129

PRINT "PCB-Attach Ver 1.00 - Copyright 1994 Gary Meeker"

DIM SHARED QwkMsg AS QWKMsgRecord, B AS STRING * 72, WorkDir$, AttachDir$
DIM SHARED Conf(100), MsgNum&(100), FileName$(100), DupName$(100)

'   Get the Command Line
C$ = UCASE$(COMMAND$)

SetDelimitChar 32
CritErrOff                     ' Stop nasty DOS/SHARE Errors

WorkDir$   = EndChar$(PDQParse$(C$), "\")
AttachDir$ = EndChar$(PDQParse$(C$), "\")

AttachFile$ = WorkDir$ + "ATTACHED.LST"
MsgFile$    = WorkDir$ + "MESSAGES.DAT"

IF PDQExist(AttachFile$) THEN
   PRINT "Reading "; AttachFile$; " ";
   OPEN MsgFile$ FOR BINARY AS #1
      OPEN AttachFile$ FOR INPUT AS #2
         WHILE NOT EOF(2)
            INC X
            INPUT #2, Conf(X), MsgNum&(X), FileName$(X), DupName$(X)
            PRINT ".";
         WEND
      CLOSE #2
      PRINT
      FOR N = 1 TO X
         IF PDQExist(WorkDir$ + FileName$(N)) THEN ProcessFile N
      NEXT N
   CLOSE #1
   PRINT "Done."
ELSE
   PRINT "No "; AttachFile$; " present."
END IF

PRINT
CritErron                       ' Restore nasty error handler
END

FUNCTION EndChar$(St$, EndCh$) STATIC
   Temp$ = RTRIM$(ST$)
   IF (LEN(Temp$) = 0) OR EndString(Temp$, EndCh$) THEN
      EndChar$ = Temp$
   ELSE
      EndChar$ = Temp$ + EndCh$
   END IF
END FUNCTION

FUNCTION MakeExt$(St$, Ext$) STATIC
   ExtPos = FindLastCh(St$, 46)
   IF ExtPos THEN
      MakeExt$ = LEFT$(St$, ExtPos) + Ext$
   ELSE
      MakeExt$ = RTRIM$(St$) + "." + Ext$
   END IF
END FUNCTION

SUB ProcessFile(Num)  ' Find a unique attachment filename
   FOR T = 0 TO 999
      Temp$ = MakeExt$(FileName$(Num), RIGHT$("000" + QPStrI$(T), 3))
      IF NOT PDQExist(AttachDir$ + Temp$) THEN
         PRINT "Copying "; WorkDir$ + FileName$(Num); " to "; AttachDir$ + Temp$
         FCopy WorkDir$ + FileName$(Num), AttachDir$ + Temp$, SPACE$(4096), ErCd
         ModifyName Conf(Num), MsgNum&(Num), Temp$
         EXIT FOR
      END IF
   NEXT T
END SUB

SUB ModifyName(ConfNum, MsgNum&, NewName$)  ' Update the MESSAGES.DAT file
   Expanded$ = CHR$(255) + "@"
   Attach$ = Expanded$ + "ATTACH :"
   Recs& = LOF(1) \ 128
   Rec& = 2
   WHILE Rec& < Recs&
      Offset& = (Rec& - 1&) * 128 + 1&
      GET #1, Offset&, QwkMsg
      Blocks = PDQValI(QwkMsg.Blocks$)
      IF Blocks = 0 THEN
         INC2 Rec&
      ELSEIF QwkMsg.ConfNum = ConfNum AND PDQValL&(QwkMsg.Number$) = MsgNum& THEN
         INC2 Rec&
         Offset& = (Rec& - 1&) * 128 + 1&
         DO
            GET #1, Offset&, B$
            IF LEFT$(B$, 10) = Attach$ THEN
               MID$(B$, INSTR(B$, ")")+2) = NewName$
               PUT #1, Offset&, B$
               EXIT DO
            ELSEIF LEFT$(B$, 2) <> Expanded$ THEN
               BEEP
               PRINT "Unable to locate @ATTACH statement!"
               EXIT DO
            END IF
            IncStepL Offset&, 72
         LOOP
         EXIT SUB
      ELSE
         IncStepL Rec&, Blocks
      END IF
   WEND
END SUB

'This file was last compiled with:
'BC PCB-ATCH.BAS  /o /s;
'LINK PCB-ATCH+
'     C:\QB\LIB\_NOERROR C:\QB\LIB\_NOFIELD C:\QB\LIB\_NOREAD C:\QB\LIB\_NOVAL+
'     /ex /nod /noe /packcode /far
'
'     nul
'     C:\QB\LIB\SCREEN C:\QB\LIB\MYOWN C:\QB\LIB\QPPRO C:\QB\LIB\PDQFP
'
