/*************************************************************************
* dRUNkENmBjOiN v.1.0 for DayDream/UN*X
* modded by esc to work with message bases
* Developing environment : ubuntu 10.04, DayDream 2.14.9
* Not guaranteed to work for you, though it works for me.
* 
* Code by Rezine
* Updated messagebase code by esc
* Artwork\\Design by Threaz
*
* Greetings to all those ppl of the DayDream development staff. You did 
* and do great things, men. 
*
* DayDream ownz.
*
* This source code is released under the DPL, the Drunken Public License.
*
* You know the deal : Learn from my code, laugh 'bout my code but
*                     NEVER EVER EVER rip my credz off my code!
*
* Btw, this time i tried to comment this thing somehow......
**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include "mydd.h" // Some own routines for ddlib
#include "parseme.h" // This is my very own parsing routine =)

// Some function prototypes

int get_bases(void);
int checkinput(char *check);
void display_MsgBases(void);
void lightBar(char *str, int num);
int join_MsgBase(int msgbase);
void ReadConfig(void);
int KeyMode(int key);
void StatusBar(char *str,int,int);

struct dif *d;

struct MsgBases // This is a struct taking all the needed stuff for bases.
{
    int num;
    char name[40];
}base[256]; // Place for 256 bases..

int bases=0;
int creds=1;
int keymode=0;

// Some configuration variables follow.

int cfg_StartLine=10; //How many lines has your header + 1 ? :)
int cfg_BasesPage=10; // Maximum number of bases on one page

int cfg_StatX=1;
int cfg_StatY=2;
int cfg_StatLen=10;

int cfg_LightBarX=1;
int cfg_LightBarY=11;
int cfg_LightBarLen=80;

char cfg_StatNormal[1024];
char cfg_StatKeymode[1024];
char cfg_StatEmpty[1024];

char bar_hl[1024];
char bar_nl[1024];

/**************************************************************************
* End of configuration variables ;).
**************************************************************************/


void die(void) // What to do before door drops back to DD?
{
    if(creds) // Display creds? DON'T RIP man!!
    {
        dd_sendstring(d,"\e[35m[\e[44m \e[36mdRUNkENmBjOiN 1.0 -BETA- \e[0m\e[35m]\e[32m Type \e[35mm ?\e[32m to get help on all features!\e[0m\n\n");
    }
    dd_close(d); // Close the door handler
}


int main(int argc, char *argv[]) // Main routine of the door
{
char buf[1024];

    if (argc==1) // Check if there's a cmdline arg
    {
	printf("Uhmm this won't do mate! =[\n");
	exit(-1);
    }
    
    if(!(d = dd_initdoor(argv[1]))) // Check if the cmdline arg is valid node
    {
	printf("Couldn't find socket, bye\n");
	exit(-1);
    }

    atexit(die); // Register the handler for program exitus

    ReadConfig(); // Suck in programm configuration
    
    if(!get_bases()) // Read in DD conference data.
    {
        dd_sendstring(d,"Couldn't read out conference data... strange =\\\n"); // Oi, didn't happen to work...
        exit(0);
    }
    
    dd_getstrval(d,buf,DOOR_PARAMS); // Getting a cmdline param that might be there
        
    if(!strcasecmp(buf,"h") || !strcasecmp(buf,"?")) // Look if user wants help...
    {
        dd_typefile(d,"mbjoinhelp",TYPE_MAKE|TYPE_WARN);
        creds=0;
        exit(0);
    }
    
    if(strcmp(buf,"")) // If there is, we consider it being a msgbase number ;)
    {
        if(checkinput(buf)) 
        {
            if(atoi(buf) < bases && atoi(buf) > 0)
            {
                cfg_StatX=0; // Put the door in "linemode" :)
                cfg_StatY=0;
                if(join_MsgBase(atoi(buf)))
                {
                    exit(0);
                }
                else
                {
                    //dd_sendstring(d,"Couldn't join that msgbase!\n");
                    exit(0);
                }
            }
        }
    }
    
    display_MsgBases(); // Let this function do the rest ;)

    exit(0); // ... and finally theres the end.
}

/************************************************************************
* Yes, this code is 99% taken from libdd.doc =) 
* Damn, consider me lame or lazy... :)
************************************************************************/
int get_bases(void)
{
    struct DayDream_Conference *cd;
    struct DayDream_MsgBase *bd;
    int bcnt;

    cd=(struct DayDream_Conference *)dd_getconf(dd_getintval(d, USER_JOINCONFERENCE));

    if(!cd) return(0);

	bcnt=cd->CONF_MSGBASES;
	bd = (struct DayDream_Conference *) (cd+1);
	for (bcnt=cd->CONF_MSGBASES;bcnt;bcnt--,bd++) {

        /********************************************************
        * Now filling our "own" array of conference data
        ********************************************************/
            bases++;
            base[bases].num=bd->MSGBASE_NUMBER;
            strcpy(base[bases].name,bd->MSGBASE_NAME);
	    }
    return(1);
}


int checkinput(char *check) // Check if the string only contains "numeric" characters (0-9)
{
int i;
    for(i=0;i<=strlen(check)-1;i++)
    {
        if (!isdigit(check[i])) return(0); // If we found just ONE single non-numeric, report failure
    }
    return(1); // Else report success
}

void display_MsgBases(void) // This is the "main" display function
{
int act;
int page=0;
int pages;
int i;
int key;
int quit=0;
int lpage=255;
int ftrdisp=0;
int changed=1;
int stat_changed=1;
int last_hl=-1;
int km;
char buf[1024];
char buff[10];


    pages=(bases/cfg_BasesPage); // How many pages a 10 bases do we have?
        act=dd_getintval(d,SYS_MSGBASE); // In which msgbase are we atm?
        for(i=1;i<=bases;i++)
        {
            if(base[i].num==dd_getintval(d,SYS_MSGBASE))
            {
                act=i;
                break;
            }
        }

    dd_ansipos(d,1,1); // Home cursor
    dd_typefile(d,"mbjoinhdr",TYPE_MAKE); // Display the header
    
    while(!quit) // Our main loop
    {
        page=((act-1)/cfg_BasesPage); // Which page is the current page?    
        
        if(lpage!=page) // Did the page change lately?
        {
            // If yes, do some cleanup stuff.
            last_hl=-1; // No last highlighted bar...
            for(i=1;i<=cfg_BasesPage;i++) // Clean up the page
            {
                dd_ansipos(d,cfg_LightBarX,i+cfg_LightBarY);
                lightBar("",0);
            }
            lpage=page; // And we just changed the page...
            stat_changed=1;
        }
        
        if(changed) // Has there been an event that needs screenrefreshing?
        {
            for(i=1;i<=cfg_BasesPage;i++) // Display the msgbases now
            {
                if(i+(page*cfg_BasesPage) > bases) break; // If we reached the max. msgbase, break out of for()

                if(act==i+(page*cfg_BasesPage)) //To highlight or not to highlight, that is here the question =)
                {
                    dd_ansipos(d,cfg_LightBarX,i+cfg_LightBarY);
                    lightBar(bar_hl,i+(page*cfg_BasesPage));
                }
                else 
                {
                    if(last_hl==i+(page*cfg_BasesPage) || last_hl==-1)
                    {
                        dd_ansipos(d,cfg_LightBarX,i+cfg_LightBarY);
                        lightBar(bar_nl,i+(page*cfg_BasesPage));
                    }
                }
            }
            changed=0; //Lets say nothing has changed now ;)
        }
        
        if(!ftrdisp) // Did we display the footer yet...?
        {
            dd_ansipos(d,1,20);
            dd_typefile(d,"mbjoinftr",TYPE_MAKE); // We don't "warn" about footer not there, because we can have "fullscreen" mode as well :)
            ftrdisp=1; // ... yes we did! =)
        }

        if (stat_changed && cfg_StatX && cfg_StatY)
        {
            if(stat_changed==1)
            {
                StatusBar(cfg_StatNormal,page+1,pages+1);
            }
            stat_changed=0;
        }

        
        key=0; // Init the variable that stores our keypresses.

        while(!key) // Until a key was pressed ......
        {
            key=dd_hotkey(d,HOT_CURSOR);
        }

        switch(key)
        {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            case 8:
                // This might have be done better, but well :
                // it works =P
                km=KeyMode(key);
                if(!km)
                {
                    stat_changed=1;
                }
                else
                {
                    if(!keymode)
                    {
                        
                        last_hl=act;
                        act=km;
                        stat_changed=1;
                        changed=1;
                        break;
                    }
                    else
                    {
                        stat_changed=0;
                    }
                }
                break;
                
            case 250:        // Key up
                if (act-1 >= 1)
                {
                    last_hl=act;
                    changed=1;
                    act--;
                }
                if(keymode)
                {
                    keymode=0;
                    stat_changed=1;
                }
                break;
                
            case 251:        // Key down
                if (act+1 <= bases)
                {
                    last_hl=act;
                    changed=1;
                    act++;
                }
                if(keymode)
                {
                    keymode=0;
                    stat_changed=1;
                }
                break;
                
            case 'q':
            case 'Q':
                dd_ansipos(d,1,dd_getintval(d,USER_SCREENLENGTH));
                quit=1;
                break;    

            case 'j':
            case 'J':
            case 13:
                if(join_MsgBase(act))
                {
                    exit(0);
                }
                stat_changed=1;
                break;
            
            // Don't ask me, its different PGUP's and PGDN's ;)
            // (local and remote, i tested, maybe there are more different keycodes for that?)
            case 86:
            case 73:
                if (act - cfg_BasesPage >= 1)
                {
                    last_hl=act;
                    act=act-cfg_BasesPage;
                    changed=1;
                }
                else
                {
                    last_hl=act;
                    act=1;
                    changed=1;
                }
                if(keymode)
                {
                    keymode=0;
                    stat_changed=1;
                }
                break;
                
            case 85:
            case 71:
                if (act + cfg_BasesPage <= bases)
                {
                    last_hl=act;
                    act = act + cfg_BasesPage;
                    changed=1;
                }
                else
                {
                    last_hl=act;
                    act = bases;
                    changed=1;
                }
                if(keymode)
                {
                    keymode=0;
                    stat_changed=1;
                }
                break;
                
            default:
                break;
        }
    }
    // We should now be at an end =)
}

// This is my lousy function for number key lightbar positioning
// Hmm could need some optimization... :)
int KeyMode(int key)
{
static char buf[10];

    if(key==8 && keymode==1)
    {
        keymode=0;
        return(0);
    }
    
    if(!keymode && key!=8)
    {
        keymode=1;
        dd_ansipos(d,cfg_StatX,cfg_StatY);
        dd_sendstring(d,cfg_StatEmpty);
        dd_ansipos(d,cfg_StatX,cfg_StatY);
        dd_sendstring(d,cfg_StatKeymode);
        sprintf(buf,"%c",key);
        dd_sendstring(d,buf);
        return(1);
    }
    else if(keymode==1 && key!=8)
    {
        keymode=2;
        dd_ansipos(d,cfg_StatX,cfg_StatY);
        dd_sendstring(d,cfg_StatEmpty);
        dd_ansipos(d,cfg_StatX,cfg_StatY);
        dd_sendstring(d,cfg_StatKeymode);
        sprintf(buf,"%s%c",buf,key);
        dd_sendstring(d,buf);
        keymode=0;
        if(atoi(buf) > 0 && atoi(buf) <= bases)
            return(atoi(buf));
        else
            keymode=0;
        
            return(0);
    }
    return(0);
}


void lightBar(char *str, int num) // Construct the msgbase string and display it
{
char buf[1024];
char buff[10];
int i;

    if(num==0)
    {
        strcpy(buf,"");
        for(i=1;i<=cfg_LightBarLen;i++)
        {
            strcat(buf," ");
        }
        dd_sendstring(d,buf);
        return;
    }

    sprintf(buff,"%i",num); // Integer-To-Ascii ;)

    // Yeah, here comes my "real" feature =]. We parse the lightbar strings
    // for "tags" and replace them dynamically... for more information see
    // parseme.c included with this release or check README.parser...

    strcpy(buf,parse_string(str,"BASENR",buff,"0"));
    strcpy(buf,parse_string(buf,"BASENAME",base[num].name," "));

    dd_sendstring(d,buf);
}

void StatusBar(char *str,int page, int pages) // Statusbar parsing.. don't ask why i put that in an own function :)
{
char buf[1024];
char buff[10];

    dd_ansipos(d,cfg_StatX,cfg_StatY);
    sprintf(buff,"%i",page);
    strcpy(buf,parse_string(str,"PAGEOF",buff,"0"));
    sprintf(buff,"%i",pages);
    strcpy(buf,parse_string(buf,"PAGES",buff,"0"));
    dd_sendstring(d,buf);
            
}


int join_MsgBase(int msgbase) // Returns 1 on success, 0 on failure
{
char buf[1024];

    if(base[msgbase].num == dd_getintval(d,SYS_MSGBASE)) // If users "joins" the msgbase he is just in, we return success just to not confuse the calling routine ;)
    {
        if(cfg_StatX && cfg_StatY)
        {
            dd_ansipos(d,1,dd_getintval(d,USER_SCREENLENGTH));
        }
        else
        {
            dd_sendstring(d,"\n");
        }
        creds=0; // We don't want to display any credits if users joins his actual base, don't ask why ;)
        return(1);
    }


        dd_ansipos(d,1,dd_getintval(d,USER_SCREENLENGTH));
        dd_sendstring(d,"\n");
        return(dd_changemsgbase(d,base[msgbase].num,MC_QUICK));
}


void ReadConfig(void) // Suck in configuration file and set variables
{
/*
This still might be some unoptimized shit for reading out # commented
config files hehe ;)
*/
FILE *f;
char buf[1024];
int i;

    sprintf(buf,"%s/configs/mbjoin.cfg",getenv("DAYDREAM"));
    f=fopen(buf,"r");
    
    if(!f)
    {
        dd_sendstring(d,"FAILURE!\n");
        dd_pause(d);    
    }

    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            strcpy(bar_nl,stripcrlf(buf));
            break;
        }
    }    
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            strcpy(bar_hl,stripcrlf(buf));
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            strcpy(cfg_StatNormal,stripcrlf(buf));
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            strcpy(cfg_StatKeymode,stripcrlf(buf));
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_StatX=atoi(buf);
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_StatY=atoi(buf);
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_StatLen=atoi(buf);
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_LightBarX=atoi(buf);
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_LightBarY=atoi(buf);
            break;
        }
    }
    
    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_LightBarLen=atoi(buf);
            break;
        }
    }
    
    strcpy(cfg_StatEmpty,"");

    for(i=1;i<=cfg_StatLen;i++)
    {
        strcat(cfg_StatEmpty," ");
    }

    while(1 || !feof(f))
    {
        fgets(buf,1024,f);
        if(buf[0]!='#' && strlen(buf) > 1)
        {
            cfg_BasesPage=atoi(buf);
            break;
        }
    }

    fclose(f);
}


/* <EOC> <EOF> */
