/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lzma.sdk.lzma.Decoder;
import org.cservenak.streams.Coder;
import org.cservenak.streams.CoderInputStream;

public final class PackedInputStream
extends CoderInputStream {
    protected PackedInputStream(byte[] packedData) throws IOException {
        super((InputStream)new ByteArrayInputStream(packedData), (Coder)new CustomWrapper(packedData.length));
    }

    private static class CustomWrapper
    implements Coder {
        private final Decoder d = new Decoder();
        private final int len;

        public CustomWrapper(int packedLength) {
            this.len = packedLength;
        }

        public void code(InputStream in, OutputStream out) throws IOException {
            byte[] properties = new byte[5];
            if (in.read(properties) != 5) {
                throw new IOException("LZMA file has no header!");
            }
            if (!this.d.setDecoderProperties(properties)) {
                throw new IOException("Decoder properties cannot be set!");
            }
            if (!this.d.code(in, out, (long)this.len)) {
                throw new IOException("Decoding unsuccessful!");
            }
        }
    }
}

