/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.compression;

import darwin.jopenctm.compression.CommonAlgorithms;
import darwin.jopenctm.compression.MG1Encoder;
import darwin.jopenctm.compression.MG2Decoder;
import darwin.jopenctm.compression.MeshDecoder;
import darwin.jopenctm.data.AttributeData;
import darwin.jopenctm.data.Grid;
import darwin.jopenctm.data.Mesh;
import darwin.jopenctm.data.SortableVertex;
import darwin.jopenctm.io.CtmOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class MG2Encoder
extends MG1Encoder {
    public static final float STANDARD_NORMAL_PRECISION = 0.00390625f;
    public static final float STANDARD_VERTEX_PRECISION = 9.765625E-4f;
    private final float vertexPrecision;
    private final float normalPrecision;

    public MG2Encoder(float vertexPrecision, float normalPrecision) {
        this.vertexPrecision = vertexPrecision;
        this.normalPrecision = normalPrecision;
    }

    public MG2Encoder() {
        this(9.765625E-4f, 0.00390625f);
    }

    @Override
    public int getTag() {
        return MG2Decoder.MG2_Tag;
    }

    @Override
    public void encode(Mesh m, CtmOutputStream out) throws IOException {
        int[] deltas;
        Grid grid = this.setupGrid(m.vertices);
        SortableVertex[] sorted = this.sortVertices(grid, m.vertices);
        int[] vdeltas = this.makeVertexDeltas(m.vertices, sorted, grid);
        int[] gridIndicies = new int[m.getVertexCount()];
        gridIndicies[0] = sorted[0].gridIndex;
        for (int i = 1; i < m.getVertexCount(); ++i) {
            gridIndicies[i] = sorted[i].gridIndex - sorted[i - 1].gridIndex;
        }
        out.writeLittleInt(MG2Decoder.MG2_HEADER_TAG);
        out.writeLittleFloat(this.vertexPrecision);
        out.writeLittleFloat(this.normalPrecision);
        grid.writeToStream(out);
        out.writeLittleInt(MeshDecoder.VERT);
        out.writePackedInts(vdeltas, m.getVertexCount(), 3, false);
        out.writeLittleInt(MG2Decoder.GIDX);
        out.writePackedInts(gridIndicies, m.getVertexCount(), 1, false);
        out.writeLittleInt(MeshDecoder.INDX);
        int[] indices = this.reIndexIndices(sorted, m.indices);
        this.rearrangeTriangles(indices);
        this.makeIndexDeltas(indices);
        out.writePackedInts(indices, m.getTriangleCount(), 3, false);
        if (m.hasNormals()) {
            for (int i = 1; i < m.getVertexCount(); ++i) {
                int n = i;
                gridIndicies[n] = gridIndicies[n] + gridIndicies[i - 1];
            }
            float[] restoredv = CommonAlgorithms.restoreVertices(vdeltas, gridIndicies, grid, this.vertexPrecision);
            out.writeLittleInt(MeshDecoder.NORM);
            int[] intNormals = this.makeNormalDeltas(restoredv, m.normals, indices, sorted);
            out.writePackedInts(intNormals, m.getVertexCount(), 3, false);
        }
        for (AttributeData ad : m.texcoordinates) {
            out.writeLittleInt(MeshDecoder.TEXC);
            out.writeString(ad.name);
            out.writeString(ad.materialName);
            out.writeLittleFloat(ad.precision);
            deltas = this.makeUVCoordDeltas(ad, sorted);
            out.writePackedInts(deltas, m.getVertexCount(), 2, true);
        }
        for (AttributeData ad : m.attributs) {
            out.writeLittleInt(MeshDecoder.ATTR);
            out.writeString(ad.name);
            out.writeLittleFloat(ad.precision);
            deltas = this.makeAttribDeltas(ad, sorted);
            out.writePackedInts(deltas, m.getVertexCount(), 4, true);
        }
    }

    private Grid setupGrid(float[] vertices) {
        int i;
        int vc = vertices.length / 3;
        float[] min = new float[3];
        float[] max = new float[3];
        int[] division = new int[3];
        for (i = 0; i < 3; ++i) {
            min[i] = max[i] = vertices[i];
        }
        for (i = 1; i < vc; ++i) {
            for (int j = 0; j < 3; ++j) {
                min[j] = Math.min(min[j], vertices[i * 3 + j]);
                max[j] = Math.max(max[j], vertices[i * 3 + j]);
            }
        }
        float[] factor = new float[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            factor[i2] = max[i2] - min[i2];
        }
        float sum = factor[0] + factor[1] + factor[2];
        if (sum > 1.0E-30f) {
            sum = 1.0f / sum;
            int i3 = 0;
            while (i3 < 3) {
                int n = i3++;
                factor[n] = factor[n] * sum;
            }
            double wantedGrids = Math.pow(100.0f * (float)vc, 0.3333333432674408);
            for (int i4 = 0; i4 < 3; ++i4) {
                division[i4] = (int)Math.ceil(wantedGrids * (double)factor[i4]);
                if (division[i4] >= 1) continue;
                division[i4] = 1;
            }
        } else {
            division[0] = 4;
            division[1] = 4;
            division[2] = 4;
        }
        return new Grid(min, max, division);
    }

    private int pointToGridIdx(Grid grid, float ... point) {
        int[] idx = new int[3];
        float[] size = grid.getSize();
        for (int i = 0; i < 3; ++i) {
            idx[i] = (int)Math.floor((point[i] - grid.getMin()[i]) / size[i]);
            if (idx[i] < grid.getDivision()[i]) continue;
            idx[i] = grid.getDivision()[i] - 1;
        }
        return idx[0] + grid.getDivision()[0] * (idx[1] + grid.getDivision()[1] * idx[2]);
    }

    private SortableVertex[] sortVertices(Grid grid, float[] v) {
        int vc = v.length / 3;
        Object[] sortVertices = new SortableVertex[vc];
        for (int i = 0; i < vc; ++i) {
            sortVertices[i] = new SortableVertex(v[i * 3], this.pointToGridIdx(grid, v[i * 3], v[i * 3 + 1], v[i * 3 + 2]), i);
        }
        Arrays.sort(sortVertices);
        return sortVertices;
    }

    private int[] reIndexIndices(SortableVertex[] sortVertices, int[] indices) {
        int i;
        int[] indexLUT = new int[sortVertices.length];
        int[] newIndices = new int[indices.length];
        for (i = 0; i < sortVertices.length; ++i) {
            indexLUT[sortVertices[i].originalIndex] = i;
        }
        for (i = 0; i < indices.length; ++i) {
            newIndices[i] = indexLUT[indices[i]];
        }
        return newIndices;
    }

    private int[] makeVertexDeltas(float[] vertices, SortableVertex[] sortVertices, Grid grid) {
        int vc = sortVertices.length;
        float scale = 1.0f / this.vertexPrecision;
        float prevGridIndex = 2.1474836E9f;
        int prevDeltaX = 0;
        int[] intVertices = new int[vc * 3];
        for (int i = 0; i < vc; ++i) {
            int gridIdx = sortVertices[i].gridIndex;
            float[] gridOrigin = CommonAlgorithms.gridIdxToPoint(grid, gridIdx);
            int oldIdx = sortVertices[i].originalIndex;
            int deltaX = (int)Math.floor(scale * (vertices[oldIdx * 3] - gridOrigin[0]) + 0.5f);
            intVertices[i * 3] = (float)gridIdx == prevGridIndex ? deltaX - prevDeltaX : deltaX;
            intVertices[i * 3 + 1] = (int)Math.floor(scale * (vertices[oldIdx * 3 + 1] - gridOrigin[1]) + 0.5f);
            intVertices[i * 3 + 2] = (int)Math.floor(scale * (vertices[oldIdx * 3 + 2] - gridOrigin[2]) + 0.5f);
            prevGridIndex = gridIdx;
            prevDeltaX = deltaX;
        }
        return intVertices;
    }

    private int[] makeNormalDeltas(float[] vertices, float[] normals, int[] indices, SortableVertex[] sortVertices) {
        float[] smoothNormals = CommonAlgorithms.calcSmoothNormals(vertices, indices);
        float scale = 1.0f / this.normalPrecision;
        int vc = vertices.length / 3;
        int[] intNormals = new int[vc * 3];
        for (int i = 0; i < vc; ++i) {
            int oldIdx = sortVertices[i].originalIndex;
            float magn = (float)Math.sqrt(normals[oldIdx * 3] * normals[oldIdx * 3] + normals[oldIdx * 3 + 1] * normals[oldIdx * 3 + 1] + normals[oldIdx * 3 + 2] * normals[oldIdx * 3 + 2]);
            if (magn < 1.0E-10f) {
                magn = 1.0f;
            }
            if (smoothNormals[i * 3] * normals[oldIdx * 3] + smoothNormals[i * 3 + 1] * normals[oldIdx * 3 + 1] + smoothNormals[i * 3 + 2] * normals[oldIdx * 3 + 2] < 0.0f) {
                magn = -magn;
            }
            intNormals[i * 3] = (int)Math.floor(scale * magn + 0.5f);
            magn = 1.0f / magn;
            float[] n = new float[3];
            for (int j = 0; j < 3; ++j) {
                n[j] = normals[oldIdx * 3 + j] * magn;
            }
            float[] basisAxes = CommonAlgorithms.makeNormalCoordSys(smoothNormals, i * 3);
            float[] n2 = new float[3];
            for (int j = 0; j < 3; ++j) {
                n2[j] = basisAxes[j * 3] * n[0] + basisAxes[j * 3 + 1] * n[1] + basisAxes[j * 3 + 2] * n[2];
            }
            double phi = n2[2] >= 1.0f ? 0.0 : Math.acos(n2[2]);
            double theta = Math.atan2(n2[1], n2[0]);
            int intPhi = (int)Math.floor(phi * ((double)scale / 1.5707963267948966) + 0.5);
            double thetaScale = intPhi == 0 ? 0.0 : (intPhi <= 4 ? 0.6366197723675814 : (double)intPhi / (Math.PI * 2));
            intNormals[i * 3 + 1] = intPhi;
            intNormals[i * 3 + 2] = (int)Math.floor((theta + Math.PI) * thetaScale + 0.5);
        }
        return intNormals;
    }

    private int[] makeUVCoordDeltas(AttributeData map, SortableVertex[] sortVertices) {
        float scale = 1.0f / map.precision;
        int vc = sortVertices.length;
        int prevU = 0;
        int prevV = 0;
        int[] intUVCoords = new int[vc * 2];
        for (int i = 0; i < vc; ++i) {
            int oldIdx = sortVertices[i].originalIndex;
            int u = (int)Math.floor(scale * map.values[oldIdx * 2] + 0.5f);
            int v = (int)Math.floor(scale * map.values[oldIdx * 2 + 1] + 0.5f);
            intUVCoords[i * 2] = u - prevU;
            intUVCoords[i * 2 + 1] = v - prevV;
            prevU = u;
            prevV = v;
        }
        return intUVCoords;
    }

    private int[] makeAttribDeltas(AttributeData map, SortableVertex[] sortVertices) {
        float scale = 1.0f / map.precision;
        int[] prev = new int[4];
        int vc = sortVertices.length;
        int[] intAttribs = new int[vc * 4];
        for (int i = 0; i < vc; ++i) {
            int oldIdx = sortVertices[i].originalIndex;
            for (int j = 0; j < 4; ++j) {
                int value = (int)Math.floor(scale * map.values[oldIdx * 4 + j] + 0.5f);
                intAttribs[i * 4 + j] = value - prev[j];
                prev[j] = value;
            }
        }
        return intAttribs;
    }
}

