/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.compression;

import darwin.jopenctm.compression.CommonAlgorithms;
import darwin.jopenctm.compression.MG1Decoder;
import darwin.jopenctm.data.AttributeData;
import darwin.jopenctm.data.Grid;
import darwin.jopenctm.data.Mesh;
import darwin.jopenctm.errorhandling.BadFormatException;
import darwin.jopenctm.errorhandling.InvalidDataException;
import darwin.jopenctm.io.CtmFileReader;
import darwin.jopenctm.io.CtmInputStream;
import darwin.jopenctm.io.MeshInfo;
import java.io.IOException;

public class MG2Decoder
extends MG1Decoder {
    public static final int MG2_Tag = CtmFileReader.getTagInt("MG2\u0000");
    public static final int MG2_HEADER_TAG = CtmFileReader.getTagInt("MG2H");
    public static final int GIDX = CtmFileReader.getTagInt("GIDX");

    @Override
    public boolean isFormatSupported(int tag, int version) {
        return tag == MG2_Tag && version == 5;
    }

    @Override
    public Mesh decode(MeshInfo minfo, CtmInputStream in) throws IOException, BadFormatException, InvalidDataException {
        int vc = minfo.getVertexCount();
        this.checkTag(in.readLittleInt(), MG2_HEADER_TAG);
        float vertexPrecision = in.readLittleFloat();
        float normalPrecision = in.readLittleFloat();
        Grid grid = Grid.fromStream(in);
        if (!grid.checkIntegrity()) {
            throw new InvalidDataException("The vertex size grid is corrupt!");
        }
        float[] vertices = this.readVertices(in, grid, vc, vertexPrecision);
        int[] indices = this.readIndices(in, minfo.getTriangleCount(), vc);
        float[] normals = null;
        if (minfo.hasNormals()) {
            normals = this.readNormals(in, vertices, indices, normalPrecision, vc);
        }
        AttributeData[] uvData = new AttributeData[minfo.getUvMapCount()];
        for (int i = 0; i < uvData.length; ++i) {
            uvData[i] = this.readUvData(in, vc);
        }
        AttributeData[] attributs = new AttributeData[minfo.getAttrCount()];
        for (int i = 0; i < attributs.length; ++i) {
            attributs[i] = this.readAttribute(in, vc);
        }
        return new Mesh(vertices, normals, indices, uvData, attributs);
    }

    private float[] readVertices(CtmInputStream in, Grid grid, int vcount, float precision) throws IOException, BadFormatException {
        this.checkTag(in.readLittleInt(), VERT);
        int[] intVertices = in.readPackedInts(vcount, 3, false);
        this.checkTag(in.readLittleInt(), GIDX);
        int[] gridIndices = in.readPackedInts(vcount, 1, false);
        for (int i = 1; i < vcount; ++i) {
            int n = i;
            gridIndices[n] = gridIndices[n] + gridIndices[i - 1];
        }
        return CommonAlgorithms.restoreVertices(intVertices, gridIndices, grid, precision);
    }

    private int[] readIndices(CtmInputStream in, int triCount, int vcount) throws IOException, InvalidDataException, BadFormatException {
        this.checkTag(in.readLittleInt(), INDX);
        int[] indices = in.readPackedInts(triCount, 3, false);
        this.restoreIndices(triCount, indices);
        for (int i : indices) {
            if (i <= vcount) continue;
            throw new InvalidDataException("One element of the indice array points to a none existing vertex(id: " + i + ")");
        }
        return indices;
    }

    private float[] readNormals(CtmInputStream in, float[] vertices, int[] indices, float normalPrecision, int vcount) throws IOException, BadFormatException {
        this.checkTag(in.readLittleInt(), NORM);
        int[] intNormals = in.readPackedInts(vcount, 3, false);
        return this.restoreNormals(intNormals, vertices, indices, normalPrecision);
    }

    private AttributeData readUvData(CtmInputStream in, int vcount) throws IOException, BadFormatException, InvalidDataException {
        this.checkTag(in.readLittleInt(), TEXC);
        String name = in.readString();
        String material = in.readString();
        float precision = in.readLittleFloat();
        if (precision <= 0.0f) {
            throw new InvalidDataException("A uv precision value <= 0.0 was read");
        }
        int[] intCoords = in.readPackedInts(vcount, 2, true);
        float[] data = this.restoreUVCoords(precision, intCoords);
        return new AttributeData(name, material, precision, data);
    }

    private AttributeData readAttribute(CtmInputStream in, int vc) throws IOException, BadFormatException, InvalidDataException {
        this.checkTag(in.readLittleInt(), ATTR);
        String name = in.readString();
        float precision = in.readLittleFloat();
        if (precision <= 0.0f) {
            throw new InvalidDataException("An attribute precision value <= 0.0 was read");
        }
        int[] intData = in.readPackedInts(vc, 4, true);
        float[] data = this.restoreAttribs(precision, intData);
        return new AttributeData(name, null, precision, data);
    }

    private float[] restoreAttribs(float precision, int[] intAttribs) {
        int ae = 4;
        int vc = intAttribs.length / ae;
        float[] values = new float[intAttribs.length];
        int[] prev = new int[ae];
        for (int i = 0; i < vc; ++i) {
            for (int j = 0; j < ae; ++j) {
                int value = intAttribs[i * ae + j] + prev[j];
                values[i * ae + j] = (float)value * precision;
                prev[j] = value;
            }
        }
        return values;
    }

    private float[] restoreUVCoords(float precision, int[] intUVCoords) {
        int vc = intUVCoords.length / 2;
        float[] values = new float[intUVCoords.length];
        int prevU = 0;
        int prevV = 0;
        for (int i = 0; i < vc; ++i) {
            int u = intUVCoords[i * 2] + prevU;
            int v = intUVCoords[i * 2 + 1] + prevV;
            values[i * 2] = (float)u * precision;
            values[i * 2 + 1] = (float)v * precision;
            prevU = u;
            prevV = v;
        }
        return values;
    }

    private float[] restoreNormals(int[] intNormals, float[] vertices, int[] indices, float normalPrecision) {
        float[] smoothNormals = CommonAlgorithms.calcSmoothNormals(vertices, indices);
        float[] normals = new float[vertices.length];
        int vc = vertices.length / 3;
        int ne = 3;
        for (int i = 0; i < vc; ++i) {
            int j;
            float magn = (float)intNormals[i * ne] * normalPrecision;
            int intPhi = intNormals[i * ne + 1];
            double phi = (double)intPhi * 1.5707963267948966 * (double)normalPrecision;
            double thetaScale = intPhi == 0 ? 0.0 : (intPhi <= 4 ? 1.5707963267948966 : Math.PI * 2 / (double)intPhi);
            double theta = (double)intNormals[i * ne + 2] * thetaScale - Math.PI;
            double[] n2 = new double[]{Math.sin(phi) * Math.cos(theta), Math.sin(phi) * Math.sin(theta), Math.cos(phi)};
            float[] basisAxes = CommonAlgorithms.makeNormalCoordSys(smoothNormals, i * ne);
            double[] n = new double[3];
            for (j = 0; j < 3; ++j) {
                n[j] = (double)basisAxes[j] * n2[0] + (double)basisAxes[3 + j] * n2[1] + (double)basisAxes[6 + j] * n2[2];
            }
            for (j = 0; j < 3; ++j) {
                normals[i * ne + j] = (float)(n[j] * (double)magn);
            }
        }
        return normals;
    }
}

