/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.compression;

import darwin.jopenctm.data.Grid;
import java.util.Arrays;

public class CommonAlgorithms {
    public static float[] restoreVertices(int[] intVertices, int[] gridIndices, Grid grid, float vertexPrecision) {
        int ve = 3;
        int vc = intVertices.length / ve;
        int prevGridIndex = Integer.MAX_VALUE;
        int prevDeltaX = 0;
        float[] vertices = new float[vc * ve];
        for (int i = 0; i < vc; ++i) {
            int gridIdx = gridIndices[i];
            float[] gridOrigin = CommonAlgorithms.gridIdxToPoint(grid, gridIdx);
            int deltaX = intVertices[i * ve];
            if (gridIdx == prevGridIndex) {
                deltaX += prevDeltaX;
            }
            vertices[i * ve] = vertexPrecision * (float)deltaX + gridOrigin[0];
            vertices[i * ve + 1] = vertexPrecision * (float)intVertices[i * ve + 1] + gridOrigin[1];
            vertices[i * ve + 2] = vertexPrecision * (float)intVertices[i * ve + 2] + gridOrigin[2];
            prevGridIndex = gridIdx;
            prevDeltaX = deltaX;
        }
        return vertices;
    }

    public static float[] gridIdxToPoint(Grid grid, int idx) {
        int[] gridIdx = new int[3];
        int ydiv = grid.getDivision()[0];
        int zdiv = ydiv * grid.getDivision()[1];
        gridIdx[2] = idx / zdiv;
        gridIdx[1] = (idx -= gridIdx[2] * zdiv) / ydiv;
        gridIdx[0] = idx -= gridIdx[1] * ydiv;
        float[] size = grid.getSize();
        float[] point = new float[3];
        for (int i = 0; i < 3; ++i) {
            point[i] = (float)gridIdx[i] * size[i] + grid.getMin()[i];
        }
        return point;
    }

    public static float[] calcSmoothNormals(float[] vertices, int[] indices) {
        int i;
        int vc = vertices.length / 3;
        int tc = indices.length / 3;
        float[] smoothNormals = new float[vc * 3];
        for (i = 0; i < tc; ++i) {
            int[] tri = Arrays.copyOfRange(indices, i * 3, i * 3 + 3);
            float[] v1 = new float[3];
            float[] v2 = new float[3];
            for (int j = 0; j < 3; ++j) {
                v1[j] = vertices[tri[1] * 3 + j] - vertices[tri[0] * 3 + j];
                v2[j] = vertices[tri[2] * 3 + j] - vertices[tri[0] * 3 + j];
            }
            float[] n = new float[]{v1[1] * v2[2] - v1[2] * v2[1], v1[2] * v2[0] - v1[0] * v2[2], v1[0] * v2[1] - v1[1] * v2[0]};
            float len = (float)Math.sqrt(n[0] * n[0] + n[1] * n[1] + n[2] * n[2]);
            len = len > 1.0E-10f ? 1.0f / len : 1.0f;
            int j = 0;
            while (j < 3) {
                int n2 = j++;
                n[n2] = n[n2] * len;
            }
            for (int k = 0; k < 3; ++k) {
                for (int j2 = 0; j2 < 3; ++j2) {
                    int n3 = tri[k] * 3 + j2;
                    smoothNormals[n3] = smoothNormals[n3] + n[j2];
                }
            }
        }
        for (i = 0; i < vc; ++i) {
            float len = (float)Math.sqrt(smoothNormals[i * 3] * smoothNormals[i * 3] + smoothNormals[i * 3 + 1] * smoothNormals[i * 3 + 1] + smoothNormals[i * 3 + 2] * smoothNormals[i * 3 + 2]);
            len = len > 1.0E-10f ? 1.0f / len : 1.0f;
            for (int j = 0; j < 3; ++j) {
                int n = i * 3 + j;
                smoothNormals[n] = smoothNormals[n] * len;
            }
        }
        return smoothNormals;
    }

    public static float[] makeNormalCoordSys(float[] normals, int offset) {
        float[] m = new float[9];
        m[6] = normals[offset];
        m[7] = normals[offset + 1];
        m[8] = normals[offset + 2];
        m[0] = -normals[offset + 1];
        m[1] = normals[offset] - normals[offset + 2];
        m[2] = normals[offset + 1];
        float len = (float)Math.sqrt(2.0 * (double)m[0] * (double)m[0] + (double)(m[1] * m[1]));
        if (len > 1.0E-20f) {
            len = 1.0f / len;
            m[0] = m[0] * len;
            m[1] = m[1] * len;
            m[2] = m[2] * len;
        }
        m[3] = m[7] * m[2] - m[8] * m[1];
        m[4] = m[8] * m[0] - m[6] * m[2];
        m[5] = m[6] * m[1] - m[7] * m[0];
        return m;
    }
}

