/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.SnapshotArray;

public class VerticalGroup
extends WidgetGroup {
    private float prefWidth;
    private float prefHeight;
    private boolean sizeInvalid = true;
    private int alignment;
    private boolean reverse;

    public VerticalGroup() {
        this.setTouchable(Touchable.childrenOnly);
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    private void computeSize() {
        this.sizeInvalid = false;
        this.prefWidth = 0.0f;
        SnapshotArray<Actor> children = this.getChildren();
        int n = children.size;
        for (int i = 0; i < n; ++i) {
            Actor child = (Actor)children.get(i);
            if (child instanceof Layout) {
                Layout layout = (Layout)((Object)child);
                this.prefWidth = Math.max(this.prefWidth, layout.getPrefWidth());
                this.prefHeight += layout.getPrefHeight();
                continue;
            }
            this.prefWidth = Math.max(this.prefWidth, child.getWidth());
            this.prefHeight += child.getHeight();
        }
    }

    @Override
    public void layout() {
        float groupWidth = this.getWidth();
        float y = this.reverse ? 0.0f : this.getHeight();
        float dir = this.reverse ? 1.0f : -1.0f;
        SnapshotArray<Actor> children = this.getChildren();
        int n = children.size;
        for (int i = 0; i < n; ++i) {
            float height;
            float width;
            Actor child = (Actor)children.get(i);
            if (child instanceof Layout) {
                Layout layout = (Layout)((Object)child);
                width = layout.getPrefWidth();
                height = layout.getPrefHeight();
            } else {
                width = child.getWidth();
                height = child.getHeight();
            }
            float x = (this.alignment & 8) != 0 ? 0.0f : ((this.alignment & 0x10) != 0 ? groupWidth - width : (groupWidth - width) / 2.0f);
            child.setBounds(x, y, width, height);
            y += height * dir;
        }
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }
}

