/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.SnapshotArray;

public class Actor {
    private Stage stage;
    private Group parent;
    private final DelayedRemovalArray<EventListener> listeners = new DelayedRemovalArray(0);
    private final DelayedRemovalArray<EventListener> captureListeners = new DelayedRemovalArray(0);
    private final Array<Action> actions = new Array(0);
    private String name;
    private Touchable touchable = Touchable.enabled;
    private boolean visible = true;
    private float x;
    private float y;
    private float width;
    private float height;
    private float originX;
    private float originY;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float rotation;
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);

    public void draw(SpriteBatch batch, float parentAlpha) {
    }

    public void act(float delta) {
        int n = this.actions.size;
        for (int i = 0; i < n; ++i) {
            Action action = this.actions.get(i);
            if (!action.act(delta)) continue;
            this.actions.removeIndex(i);
            action.setActor(null);
            --i;
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fire(Event event) {
        if (event.getStage() == null) {
            event.setStage(this.getStage());
        }
        event.setTarget(this);
        Array ancestors = Pools.obtain(Array.class);
        for (Group parent = this.getParent(); parent != null; parent = parent.getParent()) {
            ancestors.add(parent);
        }
        try {
            int i;
            for (i = ancestors.size - 1; i >= 0; --i) {
                Group currentTarget = (Group)ancestors.get(i);
                currentTarget.notify(event, true);
                if (!event.isStopped()) continue;
                boolean bl = event.isCancelled();
                return bl;
            }
            this.notify(event, true);
            if (event.isStopped()) {
                i = event.isCancelled() ? 1 : 0;
                return i != 0;
            }
            this.notify(event, false);
            if (!event.getBubbles()) {
                i = event.isCancelled();
                return i != 0;
            }
            if (event.isStopped()) {
                i = event.isCancelled();
                return i != 0;
            }
            int n = ancestors.size;
            for (i = 0; i < n; ++i) {
                ((Group)ancestors.get(i)).notify(event, false);
                if (!event.isStopped()) continue;
                boolean bl = event.isCancelled();
                return bl;
            }
            boolean bl = event.isCancelled();
            return bl;
        }
        finally {
            ancestors.clear();
            Pools.free(ancestors);
        }
    }

    public boolean notify(Event event, boolean capture) {
        DelayedRemovalArray<EventListener> listeners;
        if (event.getTarget() == null) {
            throw new IllegalArgumentException("The event target cannot be null.");
        }
        DelayedRemovalArray<EventListener> delayedRemovalArray = listeners = capture ? this.captureListeners : this.listeners;
        if (listeners.size == 0) {
            return event.isCancelled();
        }
        event.setListenerActor(this);
        event.setCapture(capture);
        if (event.getStage() == null) {
            event.setStage(this.stage);
        }
        listeners.begin();
        int n = listeners.size;
        for (int i = 0; i < n; ++i) {
            InputEvent inputEvent;
            EventListener listener = (EventListener)listeners.get(i);
            if (!listener.handle(event)) continue;
            event.handle();
            if (!(event instanceof InputEvent) || (inputEvent = (InputEvent)event).getType() != InputEvent.Type.touchDown) continue;
            event.getStage().addTouchFocus(listener, this, inputEvent.getTarget(), inputEvent.getPointer(), inputEvent.getButton());
        }
        listeners.end();
        return event.isCancelled();
    }

    public Actor hit(float x, float y, boolean touchable) {
        if (touchable && this.touchable != Touchable.enabled) {
            return null;
        }
        return x >= 0.0f && x < this.width && y >= 0.0f && y < this.height ? this : null;
    }

    public boolean remove() {
        if (this.parent != null) {
            return this.parent.removeActor(this);
        }
        return false;
    }

    public boolean addListener(EventListener listener) {
        if (!this.listeners.contains(listener, true)) {
            this.listeners.add(listener);
            return true;
        }
        return false;
    }

    public boolean removeListener(EventListener listener) {
        return this.listeners.removeValue(listener, true);
    }

    public Array<EventListener> getListeners() {
        return this.listeners;
    }

    public boolean addCaptureListener(EventListener listener) {
        if (!this.captureListeners.contains(listener, true)) {
            this.captureListeners.add(listener);
        }
        return true;
    }

    public boolean removeCaptureListener(EventListener listener) {
        return this.captureListeners.removeValue(listener, true);
    }

    public Array<EventListener> getCaptureListeners() {
        return this.captureListeners;
    }

    public void addAction(Action action) {
        action.setActor(this);
        this.actions.add(action);
    }

    public void removeAction(Action action) {
        if (this.actions.removeValue(action, true)) {
            action.setActor(null);
        }
    }

    public Array<Action> getActions() {
        return this.actions;
    }

    public void clearActions() {
        for (int i = this.actions.size - 1; i >= 0; --i) {
            this.actions.get(i).setActor(null);
        }
        this.actions.clear();
    }

    public Stage getStage() {
        return this.stage;
    }

    protected void setStage(Stage stage) {
        this.stage = stage;
    }

    public boolean isDescendantOf(Actor actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        Actor parent = this;
        while (parent != null) {
            if (parent == actor) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public boolean isAscendantOf(Actor actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        while (actor != null) {
            if (actor == this) {
                return true;
            }
            actor = actor.getParent();
        }
        return false;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Group getParent() {
        return this.parent;
    }

    protected void setParent(Group parent) {
        this.parent = parent;
    }

    public Touchable getTouchable() {
        return this.touchable;
    }

    public void setTouchable(Touchable touchable) {
        this.touchable = touchable;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setPosition(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    public void translate(float x, float y) {
        this.setX(this.x + x);
        this.setY(this.y + y);
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getTop() {
        return this.getY() + this.getHeight();
    }

    public float getRight() {
        return this.getX() + this.getWidth();
    }

    public void setSize(float width, float height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void size(float size) {
        this.setWidth(this.width + size);
        this.setHeight(this.height + size);
    }

    public void size(float width, float height) {
        this.setWidth(this.width + width);
        this.setHeight(this.height + height);
    }

    public void setBounds(float x, float y, float width, float height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public float getOriginX() {
        return this.originX;
    }

    public void setOriginX(float originX) {
        this.originX = originX;
    }

    public float getOriginY() {
        return this.originY;
    }

    public void setOriginY(float originY) {
        this.originY = originY;
    }

    public void setOrigin(float originX, float originY) {
        this.setOriginX(originX);
        this.setOriginY(originY);
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public void setScale(float scale) {
        this.setScaleX(scale);
        this.setScaleY(scale);
    }

    public void setScale(float scaleX, float scaleY) {
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
    }

    public void scale(float scale) {
        this.setScaleX(this.scaleX + scale);
        this.setScaleY(this.scaleY + scale);
    }

    public void scale(float scaleX, float scaleY) {
        this.setScaleX(this.scaleX + scaleX);
        this.setScaleY(this.scaleY + scaleY);
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float degrees) {
        this.rotation = degrees;
    }

    public void rotate(float amountInDegrees) {
        this.setRotation(this.rotation + amountInDegrees);
    }

    public void setColor(Color color) {
        this.color.set(color);
    }

    public void setColor(float r, float g, float b, float a) {
        this.color.set(r, g, b, a);
    }

    public Color getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void toFront() {
        this.setZIndex(Integer.MAX_VALUE);
    }

    public void toBack() {
        this.setZIndex(0);
    }

    public void setZIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("ZIndex cannot be < 0.");
        }
        Group parent = this.getParent();
        if (parent == null) {
            return;
        }
        SnapshotArray<Actor> children = parent.getChildren();
        if (children.size == 1) {
            return;
        }
        if (!((Array)children).removeValue(this, true)) {
            return;
        }
        if (index >= children.size) {
            children.add(this);
        } else {
            ((Array)children).insert(index, this);
        }
    }

    public int getZIndex() {
        Group parent = this.getParent();
        if (parent == null) {
            return -1;
        }
        return parent.getChildren().indexOf(this, true);
    }

    public Vector2 stageToLocalCoordinates(Vector2 stageCoords) {
        if (this.parent == null) {
            return stageCoords;
        }
        this.parent.stageToLocalCoordinates(stageCoords);
        this.parentToLocalCoordinates(stageCoords);
        return stageCoords;
    }

    public Vector2 localToStageCoordinates(Vector2 localCoords) {
        for (Actor actor = this; actor != null; actor = actor.getParent()) {
            if (actor.getRotation() != 0.0f || actor.getScaleX() != 1.0f || actor.getScaleY() != 1.0f) {
                throw new GdxRuntimeException("Only unrotated and unscaled actors may use this method.");
            }
            localCoords.x += actor.getX();
            localCoords.y += actor.getY();
        }
        return localCoords;
    }

    public Vector2 localToParentCoordinates(Vector2 localCoords) {
        if (this.getRotation() != 0.0f || this.getScaleX() != 1.0f || this.getScaleY() != 1.0f) {
            throw new GdxRuntimeException("Only unrotated and unscaled actors may use this method.");
        }
        localCoords.x += this.getX();
        localCoords.y += this.getY();
        return localCoords;
    }

    public Vector2 localToAscendantCoordinates(Actor ascendant, Vector2 localCoords) {
        Actor actor = this;
        while (actor.getParent() != null) {
            actor.localToParentCoordinates(localCoords);
            if ((actor = actor.getParent()) != ascendant) continue;
            break;
        }
        return localCoords;
    }

    public Vector2 parentToLocalCoordinates(Vector2 parentCoords) {
        float rotation = this.getRotation();
        float scaleX = this.getScaleX();
        float scaleY = this.getScaleY();
        float childX = this.getX();
        float childY = this.getY();
        if (rotation == 0.0f) {
            if (scaleX == 1.0f && scaleY == 1.0f) {
                parentCoords.x -= childX;
                parentCoords.y -= childY;
            } else {
                float originX = this.getOriginX();
                float originY = this.getOriginY();
                if (originX == 0.0f && originY == 0.0f) {
                    parentCoords.x = (parentCoords.x - childX) / scaleX;
                    parentCoords.y = (parentCoords.y - childY) / scaleY;
                } else {
                    parentCoords.x = (parentCoords.x - childX - originX) / scaleX + originX;
                    parentCoords.y = (parentCoords.y - childY - originY) / scaleY + originY;
                }
            }
        } else {
            float cos = (float)Math.cos(rotation * ((float)Math.PI / 180));
            float sin = (float)Math.sin(rotation * ((float)Math.PI / 180));
            float originX = this.getOriginX();
            float originY = this.getOriginY();
            if (scaleX == 1.0f && scaleY == 1.0f) {
                if (originX == 0.0f && originY == 0.0f) {
                    float tox = parentCoords.x - childX;
                    float toy = parentCoords.y - childY;
                    parentCoords.x = tox * cos + toy * sin;
                    parentCoords.y = tox * -sin + toy * cos;
                } else {
                    float worldOriginX = childX + originX;
                    float worldOriginY = childY + originY;
                    float fx = -originX;
                    float fy = -originY;
                    float x1 = cos * fx - sin * fy + worldOriginX;
                    float y1 = sin * fx + cos * fy + worldOriginY;
                    float tox = parentCoords.x - x1;
                    float toy = parentCoords.y - y1;
                    parentCoords.x = tox * cos + toy * sin;
                    parentCoords.y = tox * -sin + toy * cos;
                }
            } else if (originX == 0.0f && originY == 0.0f) {
                float tox = parentCoords.x - childX;
                float toy = parentCoords.y - childY;
                parentCoords.x = (tox * cos + toy * sin) / scaleX;
                parentCoords.y = (tox * -sin + toy * cos) / scaleY;
            } else {
                float worldOriginX = childX + originX;
                float worldOriginY = childY + originY;
                float fx = -originX * scaleX;
                float fy = -originY * scaleY;
                float x1 = cos * fx - sin * fy + worldOriginX;
                float y1 = sin * fx + cos * fy + worldOriginY;
                float tox = parentCoords.x - x1;
                float toy = parentCoords.y - y1;
                parentCoords.x = (tox * cos + toy * sin) / scaleX;
                parentCoords.y = (tox * -sin + toy * cos) / scaleY;
            }
        }
        return parentCoords;
    }

    public String toString() {
        int dotIndex;
        String name = this.name;
        if (name == null && (dotIndex = (name = this.getClass().getName()).lastIndexOf(46)) != -1) {
            name = name.substring(dotIndex + 1);
        }
        return name + " " + this.x + "," + this.y + " " + this.width + "x" + this.height;
    }
}

