/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.materials;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.g3d.materials.MaterialAttribute;
import com.badlogic.gdx.graphics.g3d.model.skeleton.Skeleton;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Pool;
import java.nio.FloatBuffer;

public class GpuSkinningAttribute
extends MaterialAttribute {
    private static final int maxNumBones = 32;
    private static final String bonesName = "bones";
    private Skeleton skeleton;
    private final FloatBuffer matrixArray;
    private final float[] tmpValues;
    private final Matrix4 tempMatrix = new Matrix4();
    private Matrix4 modelMatrix = new Matrix4();
    private static final Pool<GpuSkinningAttribute> pool = new Pool<GpuSkinningAttribute>(){

        @Override
        protected GpuSkinningAttribute newObject() {
            return new GpuSkinningAttribute();
        }
    };

    protected GpuSkinningAttribute() {
        int size = 512;
        this.tmpValues = new float[512];
        this.matrixArray = BufferUtils.newFloatBuffer(512);
    }

    public GpuSkinningAttribute(Skeleton skeleton) {
        super(" BONES_NUM " + skeleton.combinedMatrices.size + "\n#define gpuSkinning");
        this.skeleton = skeleton;
        int size = 512;
        this.tmpValues = new float[512];
        this.matrixArray = BufferUtils.newFloatBuffer(512);
    }

    public void setModelMatrix(Matrix4 matrix) {
        this.modelMatrix.set(matrix);
    }

    @Override
    public void bind() {
    }

    @Override
    public void bind(ShaderProgram program) {
        GL20 gl = Gdx.graphics.getGL20();
        int length = this.skeleton.combinedMatrices.size;
        int i = 0;
        while (i < length) {
            Matrix4 matrix = this.skeleton.combinedMatrices.get(i);
            this.tempMatrix.set(this.modelMatrix);
            this.tempMatrix.mul(matrix);
            System.arraycopy(this.tempMatrix.val, 0, this.tmpValues, i * 16, 16);
            program.setUniformMatrix(bonesName, matrix);
            ++i;
        }
        int location = program.getUniformLocation(bonesName);
        this.matrixArray.clear();
        BufferUtils.copy(this.tmpValues, this.matrixArray, length * 16, 0);
        gl.glUniformMatrix4fv(location, length, false, this.matrixArray);
    }

    @Override
    public MaterialAttribute copy() {
        return new GpuSkinningAttribute(this.skeleton);
    }

    @Override
    public void set(MaterialAttribute attr) {
        GpuSkinningAttribute gpuAttr = (GpuSkinningAttribute)attr;
        this.name = gpuAttr.name;
        this.skeleton = gpuAttr.skeleton;
        this.modelMatrix.idt();
    }

    @Override
    public MaterialAttribute pooledCopy() {
        GpuSkinningAttribute attr = pool.obtain();
        attr.set(this);
        return attr;
    }

    @Override
    public void free() {
        if (this.isPooled) {
            pool.free(this);
        }
    }
}

