/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.ogre;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.mesh.BaseGeometry;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.mesh.ColourDiffuse;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.mesh.Face;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.mesh.Mesh;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.mesh.Submesh;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.mesh.Texcoord;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.mesh.Vertex;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.mesh.Vertexboneassignment;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.mesh.Vertexbuffer;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.skeleton.Animation;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.skeleton.Bone;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.skeleton.Boneparent;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.skeleton.Keyframe;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.skeleton.Skeleton;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.skeleton.Track;
import com.badlogic.gdx.graphics.g3d.model.SubMesh;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonAnimation;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonJoint;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonKeyframe;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonModel;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonSubMesh;
import com.badlogic.gdx.graphics.g3d.model.still.StillModel;
import com.badlogic.gdx.graphics.g3d.model.still.StillSubMesh;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class OgreXmlLoader {
    Color color = new Color();

    public SubMesh[] loadMeshes(FileHandle file) {
        InputStream in = null;
        try {
            in = file.read();
            SubMesh[] subMeshArray = this.loadMesh(in);
            return subMeshArray;
        }
        catch (Throwable t) {
            throw new GdxRuntimeException("Couldn't load file '" + file.name() + "'", t);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public SubMesh[] loadMesh(InputStream in) {
        try {
            Mesh ogreMesh = this.loadOgreMesh(in);
            SubMesh[] meshes = this.generateSubMeshes(ogreMesh);
            return meshes;
        }
        catch (Throwable t) {
            throw new GdxRuntimeException("Couldn't load meshes", t);
        }
    }

    public SkeletonModel load(FileHandle mesh, FileHandle skeleton) {
        SubMesh[] meshes = this.loadMeshes(mesh);
        return new SkeletonModel(this.loadSkeleton(skeleton), meshes);
    }

    public StillModel load(FileHandle mesh) {
        SubMesh[] meshes = this.loadMeshes(mesh);
        return new StillModel(meshes);
    }

    private SubMesh[] generateSubMeshes(Mesh ogreMesh) {
        List<Submesh> ogreSubmeshes = ogreMesh.getSubmeshes().getSubmesh();
        SubMesh[] submeshes = new SubMesh[ogreSubmeshes.size()];
        int i = 0;
        while (i < ogreSubmeshes.size()) {
            Submesh ogreSubmesh = ogreSubmeshes.get(i);
            boolean usesTriangleList = false;
            if (ogreSubmesh.use32Bitindexes) {
                throw new GdxRuntimeException("submesh '" + i + "' uses 32-bit indices");
            }
            if (ogreSubmesh.getOperationtype().equals("triangle_list")) {
                usesTriangleList = true;
            }
            short[] indices = new short[ogreSubmesh.getFaces().count * (usesTriangleList ? 3 : 1)];
            int j = 0;
            int idx = 0;
            while (j < ogreSubmesh.getFaces().count) {
                Face face = ogreSubmesh.getFaces().getFace().get(j);
                indices[idx++] = face.v1;
                if (usesTriangleList || j == 0) {
                    indices[idx++] = face.v2;
                    indices[idx++] = face.v3;
                }
                ++j;
            }
            ArrayList<VertexAttribute> attributes = new ArrayList<VertexAttribute>();
            IntArray offsets = new IntArray();
            int offset = 0;
            BaseGeometry geom = ogreSubmesh.useSharedVertices ? ogreMesh.getSharedgeometry() : ogreSubmesh.getGeometry();
            int j2 = 0;
            while (j2 < geom.getVertexbuffer().size()) {
                Vertexbuffer buffer = geom.getVertexbuffer().get(j2);
                offsets.add(offset);
                if (buffer.positions) {
                    attributes.add(new VertexAttribute(0, 3, "a_position"));
                    offset += 3;
                }
                if (buffer.normals) {
                    attributes.add(new VertexAttribute(2, 3, "a_normal"));
                    offset += 3;
                }
                if (buffer.tangents) {
                    attributes.add(new VertexAttribute(4, buffer.tangentDimensions, "a_tangent"));
                    offset += buffer.tangentDimensions;
                }
                if (buffer.binormals) {
                    attributes.add(new VertexAttribute(4, 3, "a_binormal"));
                    offset += 3;
                }
                if (buffer.coloursDiffuse) {
                    attributes.add(new VertexAttribute(5, 4, "a_color"));
                    offset += 4;
                }
                int k = 0;
                while (k < buffer.textureCoords) {
                    try {
                        int numTexCoords = 0;
                        switch (k) {
                            case 0: {
                                numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions0());
                                break;
                            }
                            case 1: {
                                numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions1());
                                break;
                            }
                            case 2: {
                                numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions2());
                                break;
                            }
                            case 3: {
                                numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions3());
                                break;
                            }
                            case 4: {
                                numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions4());
                                break;
                            }
                            case 5: {
                                numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions5());
                                break;
                            }
                            case 6: {
                                numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions6());
                                break;
                            }
                            case 7: {
                                numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions7());
                            }
                        }
                        attributes.add(new VertexAttribute(3, numTexCoords, "a_texCoord" + k));
                        offset += numTexCoords;
                    }
                    catch (NumberFormatException e) {
                        throw new GdxRuntimeException("Can't process texture coords with dimensions != 1, 2, 3, 4 (e.g. float1)");
                    }
                    ++k;
                }
                ++j2;
            }
            VertexAttributes attribs = new VertexAttributes(attributes.toArray(new VertexAttribute[0]));
            int vertexSize = offset;
            float[] vertices = new float[geom.getVertexCount() * offset];
            int j3 = 0;
            while (j3 < geom.getVertexbuffer().size()) {
                Vertexbuffer buffer = geom.getVertexbuffer().get(j3);
                int idx2 = offset = offsets.get(j3);
                int k = 0;
                while (k < buffer.getVertex().size()) {
                    Vertex v = buffer.getVertex().get(k);
                    if (v.getPosition() != null) {
                        vertices[idx2++] = v.getPosition().x;
                        vertices[idx2++] = v.getPosition().y;
                        vertices[idx2++] = v.getPosition().z;
                    }
                    if (v.getNormal() != null) {
                        vertices[idx2++] = v.getNormal().x;
                        vertices[idx2++] = v.getNormal().y;
                        vertices[idx2++] = v.getNormal().z;
                    }
                    if (v.getTangent() != null) {
                        vertices[idx2++] = v.getTangent().x;
                        vertices[idx2++] = v.getTangent().y;
                        vertices[idx2++] = v.getTangent().z;
                        if (buffer.tangentDimensions == 4) {
                            vertices[idx2++] = v.getTangent().w;
                        }
                    }
                    if (v.getBinormal() != null) {
                        vertices[idx2++] = v.getBinormal().x;
                        vertices[idx2++] = v.getBinormal().y;
                        vertices[idx2++] = v.getBinormal().z;
                    }
                    if (v.getColourDiffuse() != null) {
                        float color = this.getColor(v.getColourDiffuse());
                        vertices[idx2++] = color;
                    }
                    if (v.getTexcoord() != null) {
                        int l = 0;
                        while (l < v.getTexcoord().size()) {
                            Texcoord texCoord = v.getTexcoord().get(l);
                            int numTexCoords = 0;
                            switch (l) {
                                case 0: {
                                    numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions0());
                                    break;
                                }
                                case 1: {
                                    numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions1());
                                    break;
                                }
                                case 2: {
                                    numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions2());
                                    break;
                                }
                                case 3: {
                                    numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions3());
                                    break;
                                }
                                case 4: {
                                    numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions4());
                                    break;
                                }
                                case 5: {
                                    numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions5());
                                    break;
                                }
                                case 6: {
                                    numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions6());
                                    break;
                                }
                                case 7: {
                                    numTexCoords = Integer.valueOf(buffer.getTextureCoordDimensions7());
                                }
                            }
                            if (numTexCoords == 1) {
                                vertices[idx2++] = texCoord.u;
                            }
                            if (numTexCoords == 2) {
                                vertices[idx2++] = texCoord.u;
                                vertices[idx2++] = texCoord.v;
                            }
                            if (numTexCoords == 3) {
                                vertices[idx2++] = texCoord.u;
                                vertices[idx2++] = texCoord.v;
                                vertices[idx2++] = texCoord.w;
                            }
                            if (numTexCoords == 4) {
                                vertices[idx2++] = texCoord.u;
                                vertices[idx2++] = texCoord.v;
                                vertices[idx2++] = texCoord.w;
                                vertices[idx2++] = texCoord.x;
                            }
                            ++l;
                        }
                    }
                    idx2 = offset += vertexSize;
                    ++k;
                }
                ++j3;
            }
            com.badlogic.gdx.graphics.Mesh mesh = new com.badlogic.gdx.graphics.Mesh(false, vertices.length / vertexSize, indices.length, attribs);
            mesh.setIndices(indices);
            mesh.setVertices(vertices);
            boolean hasSkeleton = ogreSubmesh.getBoneassignments() != null;
            SubMesh subMesh = hasSkeleton ? new SkeletonSubMesh("", mesh, 4) : new StillSubMesh("", mesh, 4);
            if (hasSkeleton) {
                SubMesh subSkelMesh = subMesh;
                ((SkeletonSubMesh)subSkelMesh).setVertices(vertices);
                ((SkeletonSubMesh)subSkelMesh).setIndices(indices);
                ((SkeletonSubMesh)subSkelMesh).skinnedVertices = new float[vertices.length];
                System.arraycopy(((SkeletonSubMesh)subSkelMesh).vertices, 0, ((SkeletonSubMesh)subSkelMesh).skinnedVertices, 0, ((SkeletonSubMesh)subSkelMesh).vertices.length);
                this.loadBones(ogreSubmesh, (SkeletonSubMesh)subSkelMesh);
            }
            if (ogreSubmesh.getOperationtype().equals("triangle_list")) {
                subMesh.primitiveType = 4;
            }
            if (ogreSubmesh.getOperationtype().equals("triangle_fan")) {
                subMesh.primitiveType = 6;
            }
            if (ogreSubmesh.getOperationtype().equals("triangle_strip")) {
                subMesh.primitiveType = 5;
            }
            submeshes[i] = subMesh;
            ++i;
        }
        return submeshes;
    }

    private void loadBones(Submesh ogreSubmesh, SkeletonSubMesh subMesh) {
        Array<IntArray> boneAssignments = new Array<IntArray>();
        Array<FloatArray> boneWeights = new Array<FloatArray>();
        int j = 0;
        while (j < subMesh.getMesh().getNumVertices()) {
            boneAssignments.add(new IntArray(4));
            boneWeights.add(new FloatArray(4));
            ++j;
        }
        List<Vertexboneassignment> vertexboneassignment = ogreSubmesh.getBoneassignments().getVertexboneassignment();
        int j2 = 0;
        while (j2 < vertexboneassignment.size()) {
            Vertexboneassignment assignment = vertexboneassignment.get(j2);
            int boneIndex = assignment.boneindex;
            int vertexIndex = assignment.vertexindex;
            float weight = assignment.weight;
            ((IntArray)boneAssignments.get(vertexIndex)).add(boneIndex);
            ((FloatArray)boneWeights.get(vertexIndex)).add(weight);
            ++j2;
        }
        subMesh.boneAssignments = new int[boneAssignments.size][];
        subMesh.boneWeights = new float[boneWeights.size][];
        j2 = 0;
        while (j2 < boneAssignments.size) {
            subMesh.boneAssignments[j2] = new int[((IntArray)boneAssignments.get((int)j2)).size];
            subMesh.boneWeights[j2] = new float[((FloatArray)boneWeights.get((int)j2)).size];
            int k = 0;
            while (k < ((IntArray)boneAssignments.get((int)j2)).size) {
                subMesh.boneAssignments[j2][k] = ((IntArray)boneAssignments.get(j2)).get(k);
                ++k;
            }
            k = 0;
            while (k < ((FloatArray)boneWeights.get((int)j2)).size) {
                subMesh.boneWeights[j2][k] = ((FloatArray)boneWeights.get(j2)).get(k);
                ++k;
            }
            ++j2;
        }
    }

    private float getColor(ColourDiffuse colourDiffuse) {
        String[] tokens = colourDiffuse.getValue().split(" ");
        if (tokens.length == 3) {
            this.color.set(Float.valueOf(tokens[0]).floatValue(), Float.valueOf(tokens[1]).floatValue(), Float.valueOf(tokens[2]).floatValue(), 1.0f);
        } else {
            this.color.set(Float.valueOf(tokens[0]).floatValue(), Float.valueOf(tokens[1]).floatValue(), Float.valueOf(tokens[2]).floatValue(), Float.valueOf(tokens[3]).floatValue());
        }
        return this.color.toFloatBits();
    }

    private Mesh loadOgreMesh(InputStream in) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Mesh.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        long start = System.nanoTime();
        Mesh mesh = (Mesh)unmarshaller.unmarshal(in);
        System.out.println("took: " + (float)(System.nanoTime() - start) / 1.0E9f);
        return mesh;
    }

    public com.badlogic.gdx.graphics.g3d.model.skeleton.Skeleton loadSkeleton(FileHandle file) {
        InputStream in = null;
        try {
            in = file.read();
            com.badlogic.gdx.graphics.g3d.model.skeleton.Skeleton skeleton = this.loadSkeleton(in);
            return skeleton;
        }
        catch (Throwable t) {
            throw new GdxRuntimeException("Couldn't load file '" + file.name() + "'", t);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public com.badlogic.gdx.graphics.g3d.model.skeleton.Skeleton loadSkeleton(InputStream in) {
        try {
            Skeleton ogreSkel = this.loadOgreSkeleton(in);
            return this.generateSkeleton(ogreSkel);
        }
        catch (Throwable t) {
            throw new GdxRuntimeException("Couldn't load model", t);
        }
    }

    private com.badlogic.gdx.graphics.g3d.model.skeleton.Skeleton generateSkeleton(Skeleton ogreSkel) {
        SkeletonJoint joint;
        List<Bone> bones = ogreSkel.getBones().getBone();
        ArrayList<SkeletonJoint> joints = new ArrayList<SkeletonJoint>();
        HashMap<String, SkeletonJoint> nameToJoint = new HashMap<String, SkeletonJoint>();
        int i = 0;
        while (i < bones.size()) {
            Bone bone = bones.get(i);
            SkeletonJoint joint2 = new SkeletonJoint();
            joint2.name = bone.name;
            joint2.position.set(bone.position.x, bone.position.y, bone.position.z);
            joint2.rotation.setFromAxis(bone.rotation.axis.x, bone.rotation.axis.y, bone.rotation.axis.z, 57.295776f * bone.rotation.angle);
            if (bone.scale != null) {
                if (bone.scale.factor == 0.0f) {
                    joint2.scale.set(bone.scale.x, bone.scale.y, bone.scale.z);
                } else {
                    joint2.scale.set(bone.scale.factor, bone.scale.factor, bone.scale.factor);
                }
            }
            joints.add(joint2);
            nameToJoint.put(joint2.name, joint2);
            ++i;
        }
        List<Boneparent> hierarchy = ogreSkel.getBonehierarchy().getBoneparent();
        int i2 = 0;
        while (i2 < hierarchy.size()) {
            Boneparent link = hierarchy.get(i2);
            joint = (SkeletonJoint)nameToJoint.get(link.getBone());
            SkeletonJoint parent = (SkeletonJoint)nameToJoint.get(link.getParent());
            parent.children.add(joint);
            joint.parent = parent;
            ++i2;
        }
        com.badlogic.gdx.graphics.g3d.model.skeleton.Skeleton skel = new com.badlogic.gdx.graphics.g3d.model.skeleton.Skeleton();
        int i3 = 0;
        while (i3 < joints.size()) {
            joint = (SkeletonJoint)joints.get(i3);
            if (joint.parent == null) {
                skel.hierarchy.add(joint);
            }
            ++i3;
        }
        skel.buildFromHierarchy();
        List<Animation> animations = ogreSkel.getAnimations().getAnimation();
        int i4 = 0;
        while (i4 < animations.size()) {
            Animation animation = animations.get(i4);
            SkeletonKeyframe[][] perJointkeyFrames = new SkeletonKeyframe[skel.bindPoseJoints.size][];
            List<Track> tracks = animation.getTracks().getTrack();
            if (tracks.size() != perJointkeyFrames.length) {
                throw new IllegalArgumentException("Number of tracks does not equal number of joints");
            }
            Matrix4 rotation = new Matrix4();
            Matrix4 transform = new Matrix4();
            int j = 0;
            while (j < tracks.size()) {
                Track track = tracks.get(j);
                String jointName = track.getBone();
                int jointIndex = skel.namesToIndices.get(jointName);
                if (perJointkeyFrames[jointIndex] != null) {
                    throw new IllegalArgumentException("Track for bone " + jointName + " in animation " + animation.name + " already defined!");
                }
                SkeletonKeyframe[] jointKeyFrames = new SkeletonKeyframe[track.getKeyframes().getKeyframe().size()];
                perJointkeyFrames[jointIndex] = jointKeyFrames;
                int k = 0;
                while (k < track.getKeyframes().getKeyframe().size()) {
                    Keyframe keyFrame = track.getKeyframes().getKeyframe().get(k);
                    SkeletonKeyframe jointKeyframe = new SkeletonKeyframe();
                    jointKeyframe.timeStamp = keyFrame.time;
                    jointKeyframe.position.set(keyFrame.translate.x, keyFrame.translate.y, keyFrame.translate.z);
                    if (keyFrame.scale != null) {
                        if (keyFrame.scale.factor == 0.0f) {
                            jointKeyframe.scale.set(keyFrame.scale.x, keyFrame.scale.y, keyFrame.scale.z);
                        } else {
                            jointKeyframe.scale.set(keyFrame.scale.factor, keyFrame.scale.factor, keyFrame.scale.factor);
                        }
                    }
                    jointKeyframe.rotation.setFromAxis(keyFrame.rotate.axis.x, keyFrame.rotate.axis.y, keyFrame.rotate.axis.z, 57.295776f * keyFrame.rotate.angle).nor();
                    jointKeyframe.parentIndex = skel.bindPoseJoints.get((int)jointIndex).parentIndex;
                    jointKeyFrames[k] = jointKeyframe;
                    rotation.set(jointKeyframe.rotation);
                    rotation.trn(jointKeyframe.position);
                    transform.set(skel.sceneMatrices.get(jointIndex));
                    transform.mul(rotation);
                    if (jointKeyframe.parentIndex != -1) {
                        rotation.set(skel.offsetMatrices.get(jointKeyframe.parentIndex)).mul(transform);
                        transform.set(rotation);
                    }
                    transform.getTranslation(jointKeyframe.position);
                    transform.getRotation(jointKeyframe.rotation);
                    jointKeyframe.rotation.x *= -1.0f;
                    jointKeyframe.rotation.y *= -1.0f;
                    jointKeyframe.rotation.z *= -1.0f;
                    ++k;
                }
                ++j;
            }
            j = 0;
            while (j < perJointkeyFrames.length) {
                if (perJointkeyFrames[i4] == null) {
                    throw new IllegalArgumentException("No track for bone " + skel.jointNames.get(j));
                }
                ++j;
            }
            skel.animations.put(animation.name, new SkeletonAnimation(animation.name, animation.length, perJointkeyFrames));
            ++i4;
        }
        return skel;
    }

    private Skeleton loadOgreSkeleton(InputStream in) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Skeleton.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        long start = System.nanoTime();
        Skeleton skel = (Skeleton)unmarshaller.unmarshal(in);
        System.out.println("took: " + (float)(System.nanoTime() - start) / 1.0E9f);
        return skel;
    }
}

