/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.md5;

import com.badlogic.gdx.graphics.g3d.Animation;
import com.badlogic.gdx.graphics.g3d.loaders.md5.MD5Joints;
import com.badlogic.gdx.graphics.g3d.loaders.md5.MD5Quaternion;
import com.badlogic.gdx.math.collision.BoundingBox;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MD5Animation
extends Animation {
    public int frameRate;
    public float secondsPerFrame;
    public MD5Joints[] frames;
    public BoundingBox[] bounds;
    public String name;
    static MD5Quaternion jointAOrient = new MD5Quaternion();
    static MD5Quaternion jointBOrient = new MD5Quaternion();

    public void write(DataOutputStream out) throws IOException {
        int i;
        out.writeUTF(this.name);
        out.writeInt(this.frameRate);
        out.writeFloat(this.secondsPerFrame);
        out.writeInt(this.frames.length);
        for (i = 0; i < this.frames.length; ++i) {
            this.frames[i].write(out);
        }
        out.writeInt(this.bounds.length);
        for (i = 0; i < this.bounds.length; ++i) {
            out.writeFloat(this.bounds[i].min.x);
            out.writeFloat(this.bounds[i].min.y);
            out.writeFloat(this.bounds[i].min.z);
            out.writeFloat(this.bounds[i].max.x);
            out.writeFloat(this.bounds[i].max.y);
            out.writeFloat(this.bounds[i].max.z);
        }
    }

    public void read(DataInputStream in) throws IOException {
        this.name = in.readUTF();
        this.frameRate = in.readInt();
        this.secondsPerFrame = in.readFloat();
        int numFrames = in.readInt();
        this.frames = new MD5Joints[numFrames];
        for (int i = 0; i < numFrames; ++i) {
            this.frames[i] = new MD5Joints();
            this.frames[i].read(in);
        }
        int numBounds = in.readInt();
        this.bounds = new BoundingBox[numBounds];
        for (int i = 0; i < numBounds; ++i) {
            this.bounds[i] = new BoundingBox();
            this.bounds[i].min.x = in.readFloat();
            this.bounds[i].min.y = in.readFloat();
            this.bounds[i].min.z = in.readFloat();
            this.bounds[i].max.x = in.readFloat();
            this.bounds[i].max.y = in.readFloat();
            this.bounds[i].max.z = in.readFloat();
        }
    }

    public static void interpolate(MD5Joints skeletonA, MD5Joints skeletonB, MD5Joints skeletonOut, float t) {
        int i = 0;
        int idx = 0;
        while (i < skeletonA.numJoints) {
            float jointAPosX = skeletonA.joints[idx + 1];
            float jointAPosY = skeletonA.joints[idx + 2];
            float jointAPosZ = skeletonA.joints[idx + 3];
            MD5Animation.jointAOrient.x = skeletonA.joints[idx + 4];
            MD5Animation.jointAOrient.y = skeletonA.joints[idx + 5];
            MD5Animation.jointAOrient.z = skeletonA.joints[idx + 6];
            MD5Animation.jointAOrient.w = skeletonA.joints[idx + 7];
            float jointBPosX = skeletonB.joints[idx + 1];
            float jointBPosY = skeletonB.joints[idx + 2];
            float jointBPosZ = skeletonB.joints[idx + 3];
            MD5Animation.jointBOrient.x = skeletonB.joints[idx + 4];
            MD5Animation.jointBOrient.y = skeletonB.joints[idx + 5];
            MD5Animation.jointBOrient.z = skeletonB.joints[idx + 6];
            MD5Animation.jointBOrient.w = skeletonB.joints[idx + 7];
            skeletonOut.joints[idx] = skeletonA.joints[idx];
            skeletonOut.joints[idx + 1] = jointAPosX + t * (jointBPosX - jointAPosX);
            skeletonOut.joints[idx + 2] = jointAPosY + t * (jointBPosY - jointAPosY);
            skeletonOut.joints[idx + 3] = jointAPosZ + t * (jointBPosZ - jointAPosZ);
            jointAOrient.slerp(jointBOrient, t);
            skeletonOut.joints[idx + 4] = MD5Animation.jointAOrient.x;
            skeletonOut.joints[idx + 5] = MD5Animation.jointAOrient.y;
            skeletonOut.joints[idx + 6] = MD5Animation.jointAOrient.z;
            skeletonOut.joints[idx + 7] = MD5Animation.jointAOrient.w;
            ++i;
            idx += 8;
        }
    }

    @Override
    public float getLength() {
        return (float)this.frames.length * this.secondsPerFrame;
    }

    @Override
    public int getNumFrames() {
        return this.frames.length;
    }
}

