/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.collada;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.XmlReader;

public class Source {
    String id;
    int components;
    int count;
    float[] data;

    public Source(XmlReader.Element source) {
        this.id = source.getAttribute("id");
        this.parseComponents(source);
    }

    private void parseComponents(XmlReader.Element source) {
        XmlReader.Element floatArray = source.getChildByName("float_array");
        XmlReader.Element technique = source.getChildByName("technique_common");
        if (floatArray == null) {
            throw new GdxRuntimeException("no <float_array> element in source '" + this.id + "'");
        }
        if (technique == null) {
            throw new GdxRuntimeException("no <technique_common> element in source '" + this.id + "'");
        }
        XmlReader.Element accessor = technique.getChildByName("accessor");
        if (accessor == null) {
            throw new GdxRuntimeException("no <accessor> element in source '" + this.id + "'");
        }
        this.data = new float[Integer.parseInt(floatArray.getAttribute("count"))];
        this.count = Integer.parseInt(accessor.getAttribute("count"));
        this.components = Integer.parseInt(accessor.getAttribute("stride"));
        String[] tokens = floatArray.getText().split("\\s+");
        int i = 0;
        while (i < tokens.length) {
            this.data[i] = Float.parseFloat(tokens[i]);
            ++i;
        }
    }
}

