/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.collada;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.g3d.loaders.collada.Faces;
import com.badlogic.gdx.graphics.g3d.loaders.collada.Skin;
import com.badlogic.gdx.graphics.g3d.loaders.collada.Source;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonSubMesh;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.XmlReader;
import java.util.HashMap;

public class Geometry {
    public String id;
    public Faces faces;

    public Geometry(XmlReader.Element colladaGeo) {
        this.id = colladaGeo.getAttribute("id");
        XmlReader.Element colladaMesh = colladaGeo.getChildByName("mesh");
        if (colladaMesh == null) {
            throw new GdxRuntimeException("no <mesh> in <geometry> '" + this.id + "'");
        }
        Array<XmlReader.Element> colladaSources = colladaMesh.getChildrenByName("source");
        HashMap<String, Source> sources = new HashMap<String, Source>();
        int j = 0;
        while (j < colladaSources.size) {
            XmlReader.Element colladaSource = colladaSources.get(j);
            sources.put(colladaSource.getAttribute("id"), new Source(colladaSource));
            ++j;
        }
        HashMap<String, String> mappings = new HashMap<String, String>();
        XmlReader.Element vertices = colladaMesh.getChildByName("vertices");
        if (vertices != null) {
            Array<XmlReader.Element> inputs = vertices.getChildrenByName("input");
            int j2 = 0;
            while (j2 < inputs.size) {
                XmlReader.Element input = inputs.get(j2);
                if (input.getAttribute("semantic").equals("POSITION")) {
                    mappings.put(vertices.getAttribute("id"), input.getAttribute("source").substring(1));
                }
                ++j2;
            }
        }
        XmlReader.Element colladaFaces = null;
        colladaFaces = colladaMesh.getChildByName("triangles");
        if (colladaFaces != null) {
            this.faces = new Faces(colladaFaces, mappings, sources);
        } else {
            colladaFaces = colladaMesh.getChildByName("polylist");
            if (colladaFaces != null) {
                this.faces = new Faces(colladaFaces, mappings, sources);
            } else {
                throw new GdxRuntimeException("no <triangles>/<polylist> element in geometry '" + colladaGeo.getAttribute("id") + "'");
            }
        }
    }

    public Mesh getMesh() {
        return this.faces.getMesh();
    }

    public SkeletonSubMesh getSkeletonSubMesh(Skin skin) {
        return this.faces.getSkeletonSubMesh(skin);
    }
}

