/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.collada;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g3d.ModelLoaderHints;
import com.badlogic.gdx.graphics.g3d.loaders.SkeletonModelLoader;
import com.badlogic.gdx.graphics.g3d.loaders.collada.Animation;
import com.badlogic.gdx.graphics.g3d.loaders.collada.ColladaLoader;
import com.badlogic.gdx.graphics.g3d.loaders.collada.Geometry;
import com.badlogic.gdx.graphics.g3d.loaders.collada.Joint;
import com.badlogic.gdx.graphics.g3d.loaders.collada.Skin;
import com.badlogic.gdx.graphics.g3d.model.SubMesh;
import com.badlogic.gdx.graphics.g3d.model.skeleton.Skeleton;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonAnimation;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonJoint;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonModel;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonSubMesh;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.XmlReader;
import java.io.InputStream;

public class ColladaLoaderSkeleton
implements SkeletonModelLoader {
    @Override
    public SkeletonModel load(FileHandle handle, ModelLoaderHints hints) {
        return ColladaLoaderSkeleton.loadSkeletonModel(handle);
    }

    public static SkeletonModel loadSkeletonModel(FileHandle handle) {
        return ColladaLoaderSkeleton.loadSkeletonModel(handle.read());
    }

    public static SkeletonModel loadSkeletonModel(InputStream in) {
        XmlReader xml = new XmlReader();
        XmlReader.Element root = null;
        try {
            root = xml.parse(in);
        }
        catch (Exception e) {
            throw new GdxRuntimeException("Couldn't load Collada model", e);
        }
        Array<Geometry> geos = ColladaLoader.readGeometries(root);
        Array<Skin> skins = ColladaLoaderSkeleton.readSkins(root);
        Joint joint = ColladaLoaderSkeleton.readJoint(root);
        Animation anim = ColladaLoaderSkeleton.readAnim(root);
        SubMesh[] meshes = ColladaLoaderSkeleton.createSkeletonSubMeshes(geos, skins);
        Skeleton skeleton = ColladaLoaderSkeleton.createSkeleton(skins, joint.joint, anim);
        SkeletonModel model = new SkeletonModel(skeleton, meshes);
        return model;
    }

    private static Array<Skin> readSkins(XmlReader.Element root) {
        XmlReader.Element colladaGeoLibrary = root.getChildByName("library_controllers");
        if (colladaGeoLibrary == null) {
            throw new GdxRuntimeException("not <library_controllers> element in file");
        }
        XmlReader.Element colladaController = colladaGeoLibrary.getChildByName("controller");
        if (colladaController == null) {
            throw new GdxRuntimeException("no <controller> elements in file");
        }
        Array<XmlReader.Element> colladaSkin = colladaController.getChildrenByName("skin");
        if (colladaController == null) {
            throw new GdxRuntimeException("no <controller> elements in file");
        }
        Array<Skin> skins = new Array<Skin>();
        int i = 0;
        while (i < colladaSkin.size) {
            skins.add(new Skin(colladaSkin.get(i)));
            ++i;
        }
        return skins;
    }

    private static Joint readJoint(XmlReader.Element root) {
        XmlReader.Element colladaLibrary = root.getChildByName("library_visual_scenes");
        if (colladaLibrary == null) {
            throw new GdxRuntimeException("not <library_visual_scenes> element in file");
        }
        XmlReader.Element colladaScene = colladaLibrary.getChildByName("visual_scene");
        if (colladaScene == null) {
            throw new GdxRuntimeException("no <controller> elements in file");
        }
        return new Joint(colladaScene);
    }

    private static Animation readAnim(XmlReader.Element root) {
        XmlReader.Element colladaAnimationLib = root.getChildByName("library_animations");
        if (colladaAnimationLib == null) {
            throw new GdxRuntimeException("not <library_animations> element in file");
        }
        return new Animation(colladaAnimationLib);
    }

    private static Skeleton createSkeleton(Array<Skin> skins, SkeletonJoint joint, Animation anim) {
        Skeleton skeleton = new Skeleton();
        int i = 0;
        while (i < joint.children.size) {
            skeleton.hierarchy.add(joint.children.get(i));
            ++i;
        }
        skeleton.buildFromHierarchy();
        float[] times = anim.inputMap.values().next();
        float totalDuration = times[times.length - 1];
        skeleton.animations.put("My Animation", new SkeletonAnimation("My Animation", totalDuration, anim.keyFrames));
        return skeleton;
    }

    private static SkeletonSubMesh[] createSkeletonSubMeshes(Array<Geometry> geos, Array<Skin> skins) {
        SkeletonSubMesh[] meshes = new SkeletonSubMesh[geos.size];
        int i = 0;
        while (i < geos.size) {
            meshes[i] = geos.get(i).getSkeletonSubMesh(skins.get(i));
            ++i;
        }
        return meshes;
    }
}

