/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d;

import com.badlogic.gdx.graphics.g3d.StillModelInstance;
import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;

public class StillModelNode
implements StillModelInstance {
    private static final float[] vec3 = new float[]{0.0f, 0.0f, 0.0f};
    public final Vector3 origin = new Vector3();
    public final Vector3 transformedPosition = new Vector3();
    public final Matrix4 matrix = new Matrix4();
    public Material[] materials;
    public float radius;

    public StillModelNode() {
        this(null);
    }

    public StillModelNode(Material[] materials) {
        this.materials = materials;
    }

    @Override
    public Matrix4 getTransform() {
        return this.matrix;
    }

    @Override
    public Vector3 getSortCenter() {
        StillModelNode.vec3[0] = this.origin.x;
        StillModelNode.vec3[1] = this.origin.y;
        StillModelNode.vec3[2] = this.origin.z;
        Matrix4.mulVec(this.matrix.val, vec3);
        this.transformedPosition.x = vec3[0];
        this.transformedPosition.y = vec3[1];
        this.transformedPosition.z = vec3[2];
        return this.transformedPosition;
    }

    @Override
    public Material[] getMaterials() {
        return this.materials;
    }

    @Override
    public float getBoundingSphereRadius() {
        return this.radius;
    }

    public StillModelNode copy() {
        StillModelNode copy = new StillModelNode();
        if (this.materials != null) {
            int len = this.materials.length;
            Material[] mats = new Material[len];
            int i = 0;
            while (i < len) {
                mats[i] = this.materials[i].copy();
                ++i;
            }
            copy.materials = mats;
        }
        copy.matrix.set(this.matrix.val);
        copy.origin.set(this.origin);
        copy.radius = this.radius;
        copy.transformedPosition.set(this.transformedPosition);
        return copy;
    }
}

