program Copy;

uses dos,crt;       { Units DOS und CRT einbinden }

type TBuf = array[1..18,1..512] of byte; { Speichertyp fr eine
                                           Spur deklarieren }

const MaxVersuche = 5;  { Max. Anzahl an Lese-und Schreibvers. }

var Spur,Seite : byte;  { Zhler fr Spur und Seite der Disk }
    Errorcode  : byte;  { Rckgabewert der Prozeduren }
    lw         : byte;  { LaufWerksnummer: 0 = A: / 1 = B: }
    Buf        : TBuf;  { Speicher fr eine Spur }
    f          : file of TBuf; { Typisierte Datei vom Typ TBuf}
    ch         : char;  { Tastaturabfrage }

{***************************************************************}
{* DISKRESET  : Disk-Reset auf allen Laufwerken                *}
{* Eingabe    : ---                                            *}
{* Ausgabe    : ---                                            *}
{***************************************************************}

procedure DiskReset;
var regs : registers;
begin
 with regs do begin
   regs.ah := $00;
   regs.dl := 0;
 end;
 intr($13,regs);
end;

{***************************************************************}
{* WRITETRACK : Eine Spur schreiben                            *}
{* Eingabe    : Laufwerk, Seite,Spur,Startsektor,Anzahl,Daten  *}
{* Ausgabe    : Fehlercode  ( 0 = OK )                         *}
{***************************************************************}

function WriteTrack(     Laufwerk,
                         Seite,
                         Spur,
                         Start,
                         Anzahl     : byte;
                     var Buffer              ) : Byte;

var versuche : byte;
    Regs : Registers;

begin
  versuche := MaxVersuche;
  repeat
    with Regs do begin
      ah := $03;
      al := Anzahl;         { Anzahl Sektoren pro Spur }
      ch := Spur;
      cl := Start;          { AnfangsSektor }
      dl := Laufwerk;
      dh := Seite;
      es := Seg( Buffer );
      bx := Ofs( Buffer );
    end;
    intr( $13, Regs );
    if ( Regs.flags and fcarry = 1 ) then
      Diskreset;
    dec( Versuche );
  until ( Regs.flags and fcarry = 0 ) or ( Versuche = 0 );
  WriteTrack := Regs.ah;
end;

{***************************************************************}
{* ReadTRACK  : Eine Spur lesen                                *}
{* Eingabe    : Laufwerk,Seite,Spur,Startsektor,Anzahl,Daten   *}
{* Ausgabe    : Fehlercode  ( 0 = OK )                         *}
{***************************************************************}

function ReadTrack(      Laufwerk,
                         Seite,
                         Spur,
                         Start,
                         Anzahl     : byte;
                     var Buffer              ) : Byte;

var versuche : byte;
    Regs : Registers;

begin
  versuche := MaxVersuche;
  repeat
    with Regs do begin
      ah := $02;
      al := Anzahl;         { Anzahl Sektoren pro Spur }
      ch := Spur;
      cl := Start;          { AnfangsSektor }
      dl := Laufwerk;
      dh := Seite;
      es := Seg( Buffer );
      bx := Ofs( Buffer );
    end;
    intr( $13, Regs );
    if ( Regs.flags and fcarry = 1 ) then
      Diskreset;
    dec( Versuche );
  until ( Regs.flags and fcarry = 0 ) or ( Versuche = 0 );
  ReadTrack := Regs.ah;
end;

{***************************************************************}
{* Read_Disk  : Eine Diskette einlesen in temp-Datei           *}
{* Eingabe    : ---                                            *}
{* Ausgabe    : ---                                            *}
{***************************************************************}

procedure Read_Disk;
begin
  for Spur := 0 to 79 do
  for Seite := 0 to 1 do begin
    gotoxy (1,10);writeln('Spur : ',Spur);
    writeln('Seite : ',Seite);
    errorcode := ReadTrack(lw,Seite,Spur,1,18,Buf);
    if errorcode <> 0 then begin
      close(f);
      erase(f);
      exit;
    end;
    write(f,Buf);
    if keypressed then begin
      ch := readkey;
      if ch = #27 then begin
        close(f);
        erase(f);
        exit;
      end;
    end;
  end;
  close(f);
end;

{***************************************************************}
{* Write_Disk : Eine Diskette aus temp-Datei beschreiben       *}
{* Eingabe    : ---                                            *}
{* Ausgabe    : ---                                            *}
{***************************************************************}


procedure Write_Disk;
begin
  reset(f);
  for Spur := 0 to 79 do
    for Seite := 0 to 1 do begin
      gotoxy (1,10);writeln('Spur : ',Spur);
      writeln('Seite : ',Seite);
      read(f,Buf);
      errorcode := WriteTrack(lw,Seite,Spur,1,18,Buf);
      if errorcode <> 0 then begin
        close(f);
        erase(f);
        exit;
      end;
      if keypressed then begin
        ch := readkey;
        if ch = #27 then begin
          close(f);
          erase(f);
          exit;
        end;
      end;
   end;
end;

{***************************************************************}
{* Hauptprog  : Hauptprogramm                                  *}
{* Eingabe    : ---                                            *}
{* Ausgabe    : ---                                            *}
{***************************************************************}


begin
   assign(f,'copy.tmp');   { Temporre Datei fr Diskinhalt }
   rewrite(f);             { erstellen }
   lw := 0;                { 0 = A: / 1 = B: (systemabhngig) }
   DiskReset;              { Reset auf allen Laufwerken }

   clrscr;
   writeln('Quelldiskette einlegen !');
   readln;

   Read_Disk;   { Gesamte Disk auf HDD einlesen }

   clrscr;
   writeln('Zieldiskette einlegen !');
   readln;

   Write_Disk;  { Gesamte Temp-Datei von HDD auf Disk schreiben}

   close(f);    { Temporre Datei schlieen }
   erase(f);    { und lschen }
end.