UNIT NewPrint;

INTERFACE

 USES CRT;

 VAR Lst : Text;

 FUNCTION NumOfPorts : BYTE;
 FUNCTION PrinterState(LptNr : BYTE) : BYTE;
 FUNCTION SelectPrinter : BYTE;
 PROCEDURE Druck(Datei : STRING; VAR Error : BYTE);

IMPLEMENTATION

FUNCTION NumOfPorts : BYTE;
VAR Lpt1, Lpt2, Lpt3, Lpt4 : WORD;
    Nummer                 : BYTE;
BEGIN
 Nummer := 0;
 Lpt1 := WORD(Ptr(Seg0040,$0008)^);   {Abfrage, ob an dieser}
 Lpt2 := WORD(Ptr(Seg0040,$000A)^);   {Speicherstelle eine 1}
 Lpt3 := WORD(Ptr(Seg0040,$000C)^);   {steht. Wenn ja, ist die}
 Lpt4 := WORD(Ptr(Seg0040,$000E)^);   {Schnittstelle vorhanden.}
 IF Lpt1 <> 0 THEN Inc(Nummer);       {Dann soll auch die An-}
 IF Lpt2 <> 0 THEN Inc(Nummer);       {zahl der zur Verfgung}
 IF Lpt3 <> 0 THEN Inc(Nummer);       {stehenden Ports erhht}
 IF Lpt4 <> 0 THEN Inc(Nummer);       {werden.}
 NumOfPorts := Nummer;
END;

FUNCTION PrinterState(LptNr : BYTE) : BYTE;
VAR check : BYTE;
BEGIN
 IF LptNr > 0 THEN BEGIN    { Ist Schittstelle vorhanden ? }
  IF LptNr < 5 THEN BEGIN
   Dec(LptNr);
   ASM
    MOV AX, 0200h           { Ja: Assemblerroutine zur Ab- }
    MOV DL, LptNr           { frage des Status. }
    XOR DH, DH
    INT 17h
    MOV check, AH
   END;
  END ELSE check := 2;
 END ELSE check := 2;
 PrinterState := check;
END;

FUNCTION SelectPrinter : BYTE;
VAR Zaehler, Nummer, Check : BYTE;
BEGIN
 Nummer := $FF;
 FOR Zaehler := NumOfPorts DOWNTO 1 DO
 BEGIN
  Check := PrinterState(Zaehler);
  IF Check IN [80,144,208] THEN Nummer := Zaehler;
 END;
 SelectPrinter := Nummer;
END;

PROCEDURE Druck(Datei : STRING; VAR Error : BYTE);
VAR DruckOK  : BYTE;
    PrinFile : TEXT;
    Zeile    : STRING;
BEGIN
 DruckOK := SelectPrinter;
 IF DruckOK = $FF THEN BEGIN
  Error := 1;
  Exit;
 END;
 CASE DruckOK OF
  1 : Assign(Lst,'LPT1');
  2 : Assign(Lst,'LPT2');
  3 : Assign(Lst,'LPT3');
 ELSE Assign(Lst,'LPT4');
 END;
 Rewrite(Lst);
 Assign(PrinFile,Datei);
 {$I-} Reset(PrinFile); {$I+}
 IF IOResult <> 0 THEN BEGIN
  Error := 2;
  Exit;
 END;
 WriteLn('...drucke...');
 WHILE NOT Eof(PrinFile) DO BEGIN
  ReadLn(PrinFile,Zeile);
  WriteLn(Lst,Zeile);
 END;
 WriteLn(Lst);
 WriteLn(Lst);
 Error := 0;
END;

END.

